/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jwt;

import io.vertx.ext.jwt.Crypto;
import io.vertx.ext.jwt.impl.SignatureHelper;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

class CryptoKeyPair
implements Crypto {
    private final Signature sig;
    private final PublicKey publicKey;
    private final PrivateKey privateKey;
    private final boolean ecdsa;
    private final int ecdsaSignatureLength;

    CryptoKeyPair(String algorithm, PublicKey publicKey, PrivateKey privateKey) {
        Signature signature;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.ecdsa = this.isECDSA(algorithm);
        this.ecdsaSignatureLength = this.ECDSALength(algorithm);
        try {
            signature = Signature.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        this.sig = signature;
    }

    @Override
    public synchronized byte[] sign(byte[] payload) {
        if (this.privateKey == null) {
            throw new RuntimeException("Cannot sign (no private key)");
        }
        try {
            this.sig.initSign(this.privateKey);
            this.sig.update(payload);
            if (this.ecdsa) {
                return SignatureHelper.toJWS(this.sig.sign(), this.ecdsaSignatureLength);
            }
            return this.sig.sign();
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized boolean verify(byte[] signature, byte[] payload) {
        if (this.publicKey == null) {
            throw new RuntimeException("Cannot verify (no public key)");
        }
        try {
            this.sig.initVerify(this.publicKey);
            this.sig.update(payload);
            if (this.ecdsa) {
                return this.sig.verify(SignatureHelper.toDER(signature));
            }
            return this.sig.verify(signature);
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new RuntimeException(e);
        }
    }
}

