/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.groovy;

import groovy.inspect.swingui.AstNodeToScriptVisitor;
import groovy.lang.GroovyClassLoader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.GenericsVisitor;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CONVERSION)
public class VertxTransformation
implements ASTTransformation {
    private GroovyClassLoader loader;
    private final Map<String, Boolean> relocatedTypes = new HashMap<String, Boolean>();
    private boolean modified;
    private final ExpressionTransformer transformer = new ExpressionTransformer(){

        public Expression transform(Expression expr) {
            if (expr instanceof PropertyExpression) {
                String name;
                int idx;
                PropertyExpression objectPropExpr = (PropertyExpression)expr;
                if (objectPropExpr.isDynamic() && (idx = (name = objectPropExpr.getText()).indexOf(".groovy.")) != -1 && VertxTransformation.this.shouldTransformClass(name)) {
                    return VertxTransformation.this.rewrite(objectPropExpr);
                }
            } else if (expr instanceof VariableExpression) {
                VariableExpression variableExpression = (VariableExpression)expr;
                variableExpression.setType(VertxTransformation.this.handleType(variableExpression.getType()));
                ClassNode originType = VertxTransformation.this.handleType(variableExpression.getOriginType());
                if (originType != variableExpression.getOriginType()) {
                    return new VariableExpression(variableExpression.getName(), VertxTransformation.this.rewriteType(variableExpression.getOriginType()));
                }
            } else if (expr instanceof ClassExpression) {
                ClassExpression classExpression = (ClassExpression)expr;
                classExpression.setType(VertxTransformation.this.handleType(classExpression.getType()));
            } else if (expr instanceof ClosureExpression) {
                ClosureExpression closureExpr = (ClosureExpression)expr;
                Parameter[] parameters = closureExpr.getParameters();
                if (parameters != null) {
                    for (Parameter param : parameters) {
                        VertxTransformation.this.handleParam(param);
                    }
                }
            } else if (expr instanceof CastExpression) {
                CastExpression castExpr = (CastExpression)expr;
                castExpr.setType(VertxTransformation.this.handleType(castExpr.getType()));
            }
            return expr.transformExpression((ExpressionTransformer)this);
        }
    };

    public void visit(ASTNode[] astNodes, SourceUnit sourceUnit) {
        this.loader = sourceUnit.getClassLoader();
        try {
            Stream.of(astNodes).forEach(n -> this.visit((ASTNode)n, sourceUnit));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void visit(ASTNode node, SourceUnit sourceUnit) {
        if (node instanceof ModuleNode) {
            this.visit((ModuleNode)node, sourceUnit);
        }
    }

    private void visit(ModuleNode moduleNode, SourceUnit sourceUnit) {
        for (ImportNode importNode : moduleNode.getImports()) {
            if (!this.shouldTransformClass(importNode.getType())) continue;
            moduleNode.addImport(importNode.getAlias(), this.rewriteType(importNode.getType()));
        }
        for (MethodNode methodNode : moduleNode.getMethods()) {
            this.visit(moduleNode, methodNode);
        }
        for (ClassNode classNode : moduleNode.getClasses()) {
            boolean prev = this.modified;
            for (ConstructorNode constructorNode : classNode.getDeclaredConstructors()) {
                this.visit(moduleNode, (MethodNode)constructorNode);
            }
            for (FieldNode fieldNode : classNode.getFields()) {
                this.visit(fieldNode);
            }
            for (MethodNode methodNode : classNode.getMethods()) {
                this.visit(moduleNode, methodNode);
            }
            if (this.modified) {
                StringWriter buffer = new StringWriter();
                PrintWriter writer = new PrintWriter(buffer);
                writer.append("The class ").append(classNode.getName()).println(" uses the legacy Vert.x for Groovy API (io.vertx.groovy.XYZ classes) and should be migrated. Here is the migrated source code:");
                writer.append("// -------- BEGIN ").append(classNode.getName()).println(" --------");
                AstNodeToScriptVisitor visitor = new AstNodeToScriptVisitor((Writer)writer, true, false);
                GeneratorContext ctx = new GeneratorContext(moduleNode.getUnit());
                visitor.call(sourceUnit, ctx, classNode);
                writer.append("// -------- END ").append(classNode.getName()).println(" --------");
                System.out.println(buffer.toString());
            }
            this.modified = prev;
        }
    }

    private void visit(FieldNode fieldNode) {
        fieldNode.setType(this.handleType(fieldNode.getType()));
        fieldNode.setOriginType(this.handleType(fieldNode.getOriginType()));
    }

    private void visit(ModuleNode moduleNode, MethodNode methodNode) {
        for (Parameter param : methodNode.getParameters()) {
            this.handleParam(param);
        }
        methodNode.setReturnType(this.handleType(methodNode.getReturnType()));
        Statement code = methodNode.getCode();
        if (code != null) {
            this.visit(moduleNode, code);
        }
    }

    private void visit(ModuleNode module, Statement statement) {
        statement.visit((GroovyCodeVisitor)new GenericsVisitor(module.getContext()){

            public void visitForLoop(ForStatement forLoop) {
                forLoop.setCollectionExpression(forLoop.getCollectionExpression().transformExpression(VertxTransformation.this.transformer));
                forLoop.getLoopBlock().visit((GroovyCodeVisitor)this);
            }

            public void visitExpressionStatement(ExpressionStatement statement) {
                statement.setExpression(statement.getExpression().transformExpression(VertxTransformation.this.transformer));
            }
        });
    }

    private ClassNode handleType(ClassNode classType) {
        GenericsType[] genericsTypes = classType.getGenericsTypes();
        String s = classType.toString();
        if (genericsTypes != null) {
            for (int j = 0; j < genericsTypes.length; ++j) {
                ClassNode type;
                ClassNode lowerBound;
                GenericsType genericsType = genericsTypes[j];
                if (!this.shouldTransformGenericsType(genericsType)) continue;
                ClassNode[] upperBounds = null;
                if (genericsType.getUpperBounds() != null) {
                    upperBounds = (ClassNode[])genericsType.getUpperBounds().clone();
                    for (int i = 0; i < upperBounds.length; ++i) {
                        if (!this.shouldTransformClass(upperBounds[i])) continue;
                        upperBounds[i] = this.rewriteType(upperBounds[i]);
                    }
                }
                if ((lowerBound = genericsType.getLowerBound()) != null && this.shouldTransformClass(lowerBound)) {
                    lowerBound = this.rewriteType(lowerBound);
                }
                if (this.shouldTransformClass(type = genericsType.getType())) {
                    type = this.rewriteType(type);
                }
                genericsTypes[j] = new GenericsType(type, upperBounds, lowerBound);
            }
        }
        if (this.shouldTransformClass(classType)) {
            return this.rewriteType(classType);
        }
        return classType;
    }

    private void handleParam(Parameter param) {
        param.setType(this.handleType(param.getType()));
        param.setOriginType(this.handleType(param.getOriginType()));
    }

    private boolean shouldTransformGenericsType(GenericsType type) {
        if (this.shouldTransformClass(type.getType())) {
            return true;
        }
        if (type.getLowerBound() != null && this.shouldTransformClass(type.getLowerBound())) {
            return true;
        }
        if (type.getUpperBounds() != null) {
            for (ClassNode upperBound : type.getUpperBounds()) {
                if (!this.shouldTransformClass(upperBound)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean shouldTransformClass(ClassNode clazz) {
        return clazz != null && clazz.getName() != null && this.shouldTransformClass(clazz.getName());
    }

    private boolean shouldTransformClass(String fqn) {
        Boolean cached = this.relocatedTypes.get(fqn);
        if (cached != null) {
            return cached;
        }
        String translateNamed = this.translateClassFqn(fqn);
        if (translateNamed != null) {
            try {
                this.loader.loadClass(translateNamed);
                this.relocatedTypes.put(fqn, true);
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.relocatedTypes.put(fqn, false);
        return false;
    }

    private String translateClassFqn(String fqn) {
        int index = fqn.indexOf(".groovy.");
        if (index == -1) {
            return null;
        }
        return fqn.substring(0, index) + fqn.substring(index + 7);
    }

    private ClassNode rewriteType(ClassNode type) {
        this.modified = true;
        int index = type.getName().indexOf(".groovy.");
        String name = type.getName().substring(0, index) + type.getName().substring(index + 7);
        try {
            Field f = ClassNode.class.getDeclaredField("name");
            f.setAccessible(true);
            f.set(type, name);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return type;
    }

    private PropertyExpression rewrite(PropertyExpression expr) {
        if (expr.getProperty() instanceof ConstantExpression && expr.getObjectExpression() instanceof PropertyExpression) {
            ConstantExpression property = (ConstantExpression)expr.getProperty();
            PropertyExpression objectExpr = (PropertyExpression)expr.getObjectExpression();
            if (objectExpr != null) {
                if (property.getValue().equals("groovy")) {
                    return objectExpr;
                }
                if ((objectExpr = this.rewrite(objectExpr)) != null) {
                    return new PropertyExpression((Expression)objectExpr, (Expression)property);
                }
            } else {
                return expr;
            }
        }
        return null;
    }
}

