/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.groovy.fastclasspathscanner;

import io.vertx.lang.groovy.fastclasspathscanner.utils.Join;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class MatchProcessorException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final List<Throwable> exceptions;

    MatchProcessorException(List<Throwable> exceptions, Exception e) {
        super(e);
        this.exceptions = exceptions;
    }

    MatchProcessorException(List<Throwable> exceptions, String msg) {
        super(msg);
        this.exceptions = exceptions;
    }

    public List<Throwable> getExceptions() {
        return this.exceptions == null ? Collections.emptyList() : this.exceptions;
    }

    public static MatchProcessorException newInstance(List<Throwable> exceptions) {
        if (exceptions.size() == 1) {
            Throwable throwable = exceptions.get(0);
            if (throwable instanceof Exception) {
                return new MatchProcessorException(exceptions, (Exception)throwable);
            }
            return new MatchProcessorException(exceptions, throwable.toString());
        }
        HashSet<String> exceptionMsgs = new HashSet<String>();
        for (Throwable e : exceptions) {
            exceptionMsgs.add(e.toString());
        }
        ArrayList exceptionMsgsSorted = new ArrayList(exceptionMsgs);
        Collections.sort(exceptionMsgsSorted);
        return new MatchProcessorException(exceptions, "Multiple exceptions thrown of type: " + Join.join(", ", exceptionMsgsSorted) + ". To see individual exceptions, call MatchProcessorException#getExceptions(), or call FastClasspathScanner#verbose() before FastClasspathScanner#scan().");
    }

    public static MatchProcessorException newInstance(Throwable throwable) {
        if (throwable instanceof Exception) {
            return new MatchProcessorException(Arrays.asList(throwable), (Exception)throwable);
        }
        return new MatchProcessorException(Arrays.asList(throwable), throwable.toString());
    }
}

