/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.groovy.fastclasspathscanner.classloaderhandler;

import io.vertx.lang.groovy.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.vertx.lang.groovy.fastclasspathscanner.classloaderhandler.EquinoxClassLoaderHandler;
import io.vertx.lang.groovy.fastclasspathscanner.classloaderhandler.FelixClassLoaderHandler;
import io.vertx.lang.groovy.fastclasspathscanner.classloaderhandler.JBossClassLoaderHandler;
import io.vertx.lang.groovy.fastclasspathscanner.classloaderhandler.OSGiDefaultClassLoaderHandler;
import io.vertx.lang.groovy.fastclasspathscanner.classloaderhandler.URLClassLoaderHandler;
import io.vertx.lang.groovy.fastclasspathscanner.classloaderhandler.WeblogicClassLoaderHandler;
import io.vertx.lang.groovy.fastclasspathscanner.classloaderhandler.WebsphereLibertyClassLoaderHandler;
import io.vertx.lang.groovy.fastclasspathscanner.classloaderhandler.WebsphereTraditionalClassLoaderHandler;
import io.vertx.lang.groovy.fastclasspathscanner.utils.ReflectionUtils;
import java.util.Arrays;
import java.util.List;

public class ClassLoaderHandlerRegistry {
    public static final List<ClassLoaderHandlerRegistryEntry> DEFAULT_CLASS_LOADER_HANDLERS = Arrays.asList(new ClassLoaderHandlerRegistryEntry(EquinoxClassLoaderHandler.class), new ClassLoaderHandlerRegistryEntry(FelixClassLoaderHandler.class), new ClassLoaderHandlerRegistryEntry(JBossClassLoaderHandler.class), new ClassLoaderHandlerRegistryEntry(WeblogicClassLoaderHandler.class), new ClassLoaderHandlerRegistryEntry(WebsphereLibertyClassLoaderHandler.class), new ClassLoaderHandlerRegistryEntry(WebsphereTraditionalClassLoaderHandler.class), new ClassLoaderHandlerRegistryEntry(OSGiDefaultClassLoaderHandler.class), new ClassLoaderHandlerRegistryEntry(URLClassLoaderHandler.class));

    public static class ClassLoaderHandlerRegistryEntry {
        public final String[] handledClassLoaderNames;
        public final Class<? extends ClassLoaderHandler> classLoaderHandlerClass;

        public ClassLoaderHandlerRegistryEntry(Class<? extends ClassLoaderHandler> classLoaderHandlerClass) {
            Object handledClassLoaders;
            String fieldName = "HANDLED_CLASSLOADERS";
            try {
                handledClassLoaders = ReflectionUtils.getStaticFieldVal(classLoaderHandlerClass, "HANDLED_CLASSLOADERS");
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                throw new RuntimeException("Could not read field " + classLoaderHandlerClass + "." + "HANDLED_CLASSLOADERS", e);
            }
            if (handledClassLoaders == null) {
                throw new RuntimeException("Class " + classLoaderHandlerClass + " needs a non-null static String[] field " + "HANDLED_CLASSLOADERS");
            }
            if (!handledClassLoaders.getClass().isArray() || handledClassLoaders.getClass().getComponentType() != String.class) {
                throw new RuntimeException("Field " + classLoaderHandlerClass + "." + "HANDLED_CLASSLOADERS" + " has incorrect type, should be String[]");
            }
            this.handledClassLoaderNames = (String[])handledClassLoaders;
            this.classLoaderHandlerClass = classLoaderHandlerClass;
        }
    }
}

