/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.groovy.fastclasspathscanner.classloaderhandler;

import io.vertx.lang.groovy.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.vertx.lang.groovy.fastclasspathscanner.scanner.ClasspathFinder;
import io.vertx.lang.groovy.fastclasspathscanner.scanner.ScanSpec;
import io.vertx.lang.groovy.fastclasspathscanner.utils.LogNode;
import io.vertx.lang.groovy.fastclasspathscanner.utils.ReflectionUtils;
import java.io.File;

public class OSGiDefaultClassLoaderHandler
implements ClassLoaderHandler {
    public static final String[] HANDLED_CLASSLOADERS = new String[]{"org.eclipse.osgi.internal.baseadaptor.DefaultClassLoader"};

    @Override
    public ClassLoaderHandler.DelegationOrder getDelegationOrder(ClassLoader classLoaderInstance) {
        return ClassLoaderHandler.DelegationOrder.PARENT_FIRST;
    }

    @Override
    public void handle(ClassLoader classloader, ClasspathFinder classpathFinder, ScanSpec scanSpec, LogNode log) throws Exception {
        Object classpathManager = ReflectionUtils.invokeMethod(classloader, "getClasspathManager");
        Object[] entries = (Object[])ReflectionUtils.getFieldVal(classpathManager, "entries");
        if (entries != null) {
            for (int i = 0; i < entries.length; ++i) {
                Object bundleFile = ReflectionUtils.invokeMethod(entries[i], "getBundleFile");
                File baseFile = (File)ReflectionUtils.invokeMethod(bundleFile, "getBaseFile");
                if (baseFile == null) continue;
                classpathFinder.addClasspathElement(baseFile.getPath(), classloader, log);
            }
        }
    }
}

