/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.groovy.fastclasspathscanner.scanner;

import io.vertx.lang.groovy.fastclasspathscanner.scanner.ClasspathElement;
import io.vertx.lang.groovy.fastclasspathscanner.scanner.RelativePath;
import io.vertx.lang.groovy.fastclasspathscanner.scanner.ScanSpec;
import io.vertx.lang.groovy.fastclasspathscanner.utils.InterruptionChecker;
import io.vertx.lang.groovy.fastclasspathscanner.utils.LogNode;
import io.vertx.lang.groovy.fastclasspathscanner.utils.NestedJarHandler;
import io.vertx.lang.groovy.fastclasspathscanner.utils.SingletonMap;
import io.vertx.lang.groovy.fastclasspathscanner.utils.WorkQueue;

class RelativePathToElementMap
extends SingletonMap<RelativePath, ClasspathElement>
implements AutoCloseable {
    private final boolean scanFiles;
    private final ScanSpec scanSpec;
    private final NestedJarHandler nestedJarHandler;
    private final InterruptionChecker interruptionChecker;
    private final LogNode log;
    private WorkQueue<RelativePath> workQueue;

    RelativePathToElementMap(boolean scanFiles, ScanSpec scanSpec, NestedJarHandler nestedJarHandler, InterruptionChecker interruptionChecker, LogNode log) {
        this.scanFiles = scanFiles;
        this.scanSpec = scanSpec;
        this.nestedJarHandler = nestedJarHandler;
        this.interruptionChecker = interruptionChecker;
        this.log = log;
    }

    public void setWorkQueue(WorkQueue<RelativePath> workQueue) {
        this.workQueue = workQueue;
    }

    @Override
    public ClasspathElement newInstance(RelativePath classpathElt) {
        return ClasspathElement.newInstance(classpathElt, this.scanFiles, this.scanSpec, this.nestedJarHandler, this.workQueue, this.interruptionChecker, this.log);
    }

    @Override
    public void close() throws Exception {
        for (ClasspathElement classpathElt : this.values()) {
            classpathElt.close();
        }
    }
}

