/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.mail.MailConfig;
import io.vertx.ext.mail.impl.SMTPAuthentication;
import io.vertx.ext.mail.impl.SMTPConnection;
import io.vertx.ext.mail.impl.SMTPInitialDialogue;

class SMTPStarter {
    private static final Logger log = LoggerFactory.getLogger(SMTPStarter.class);
    private final SMTPConnection connection;
    private String hostname;
    private final MailConfig config;
    private final Handler<AsyncResult<Void>> handler;

    SMTPStarter(SMTPConnection connection, MailConfig config, String hostname, Handler<AsyncResult<Void>> handler) {
        this.connection = connection;
        this.hostname = hostname;
        this.config = config;
        this.handler = handler;
    }

    void start() {
        log.debug((Object)"connection.openConnection");
        this.connection.openConnection(this.config, (Handler<String>)((Handler)this::serverGreeting), (Handler<Throwable>)((Handler)this::handleError));
    }

    private void serverGreeting(String message) {
        log.debug((Object)"SMTPInitialDialogue");
        new SMTPInitialDialogue(this.connection, this.config, this.hostname, (Handler<Void>)((Handler)v -> this.doAuthentication()), (Handler<Throwable>)((Handler)this::handleError)).start(message);
    }

    private void doAuthentication() {
        log.debug((Object)"SMTPAuthentication");
        new SMTPAuthentication(this.connection, this.config, (Handler<Void>)((Handler)v -> this.handler.handle((Object)Future.succeededFuture(null))), (Handler<Throwable>)((Handler)this::handleError)).start();
    }

    private void handleError(Throwable throwable) {
        log.debug((Object)("handleError:" + throwable));
        if (this.connection != null) {
            this.connection.setBroken();
        }
        this.handler.handle((Object)Future.failedFuture((Throwable)throwable));
    }
}

