/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl.sasl;

import io.vertx.ext.mail.impl.sasl.AuthBaseClass;
import io.vertx.ext.mail.impl.sasl.CryptUtils;

abstract class AuthCram
extends AuthBaseClass {
    protected boolean firstStep = true;
    protected boolean finished = false;
    private final String hmac;

    protected AuthCram(String username, String password, String hmac) {
        super(username, password);
        this.hmac = hmac;
    }

    @Override
    public String nextStep(String data) {
        if (this.finished) {
            return null;
        }
        if (this.firstStep) {
            this.firstStep = false;
            return "";
        }
        this.finished = true;
        String reply = CryptUtils.hmacHex(this.password, data, this.hmac);
        return this.username + " " + reply;
    }
}

