/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.vertx.codetrans.CodeTranslator;
import io.vertx.codetrans.Lang;
import io.vertx.codetrans.RenderMode;
import io.vertx.codetrans.annotations.CodeTranslate;
import io.vertx.codetrans.lang.groovy.GroovyLang;
import io.vertx.codetrans.lang.js.JavaScriptLang;
import io.vertx.codetrans.lang.kotlin.KotlinLang;
import io.vertx.codetrans.lang.ruby.RubyLang;
import io.vertx.codetrans.lang.scala.ScalaLang;
import io.vertx.core.Verticle;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public class CodeTransProcessor
extends AbstractProcessor {
    private File outputDir;
    private CodeTranslator translator;
    private List<Lang> langs;
    private Set<File> folders = new HashSet<File>();
    private PrintWriter log;
    private ObjectNode config;
    private Map<String, Set<String>> abc = new HashMap<String, Set<String>>();
    private RenderMode renderMode;

    @Override
    public Set<String> getSupportedOptions() {
        return Collections.singleton("codetrans.output");
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton("*");
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        String outputOption = processingEnv.getOptions().get("codetrans.output");
        if (outputOption != null) {
            this.outputDir = new File(outputOption);
        }
        this.translator = new CodeTranslator(processingEnv);
        this.langs = new ArrayList<Lang>();
        String renderOpt = processingEnv.getOptions().get("codetrans.render");
        this.renderMode = renderOpt != null ? RenderMode.valueOf(renderOpt.toUpperCase()) : RenderMode.EXAMPLE;
        String langsOpt = processingEnv.getOptions().get("codetrans.langs");
        HashSet<String> langs = langsOpt != null ? new HashSet<String>(Arrays.asList(langsOpt.split("\\s*,\\s*"))) : new HashSet<String>(Arrays.asList("js", "ruby", "kotlin", "groovy"));
        String configOpt = processingEnv.getOptions().get("codetrans.config");
        if (configOpt != null) {
            ObjectMapper mapper = new ObjectMapper().enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS}).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_SINGLE_QUOTES});
            File file = new File(configOpt);
            try {
                this.config = (ObjectNode)mapper.readTree(file);
            }
            catch (IOException e) {
                System.err.println("[ERROR] Cannot read configuration file " + file.getAbsolutePath() + " : " + e.getMessage());
                e.printStackTrace();
            }
        }
        Iterator iterator2 = langs.iterator();
        block16: while (iterator2.hasNext()) {
            JsonNode excludes;
            JsonNode n;
            Lang l;
            String lang;
            switch (lang = (String)iterator2.next()) {
                case "kotlin": {
                    l = new KotlinLang();
                    break;
                }
                case "groovy": {
                    l = new GroovyLang();
                    break;
                }
                case "js": {
                    l = new JavaScriptLang();
                    break;
                }
                case "scala": {
                    l = new ScalaLang();
                    break;
                }
                case "ruby": {
                    l = new RubyLang();
                    break;
                }
                default: {
                    continue block16;
                }
            }
            this.langs.add(l);
            if (this.config == null || (n = this.config.get(lang)) == null || n.getNodeType() != JsonNodeType.OBJECT || (excludes = n.get("excludes")) == null || excludes.getNodeType() != JsonNodeType.ARRAY) continue;
            HashSet<String> t = new HashSet<String>();
            this.abc.put(l.id(), t);
            for (int i = 0; i < excludes.size(); ++i) {
                JsonNode c = excludes.get(i);
                if (c.getNodeType() != JsonNodeType.STRING) continue;
                TextNode tn = (TextNode)c;
                t.add(tn.asText());
            }
        }
    }

    private PrintWriter getLogger() throws Exception {
        if (this.log == null) {
            this.log = new PrintWriter((Writer)new FileWriter(new File(this.outputDir, "codetrans.log"), false), true);
        }
        return this.log;
    }

    private void copyDirRec(File srcFolder, File dstFolder, final PrintWriter log) throws Exception {
        if (!this.folders.contains(dstFolder)) {
            this.folders.add(dstFolder);
            final Path srcPath = srcFolder.toPath();
            final Path dstPath = dstFolder.toPath();
            SimpleFileVisitor<Path> copyingVisitor = new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Path targetPath = dstPath.resolve(srcPath.relativize(dir));
                    if (!Files.exists(targetPath, new LinkOption[0])) {
                        log.println("Creating dir " + targetPath);
                        Files.createDirectory(targetPath, new FileAttribute[0]);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path srcFile, BasicFileAttributes attrs) throws IOException {
                    if (!srcFile.getFileName().toString().endsWith(".java")) {
                        log.println("Copying resource " + srcFile + " to " + dstPath);
                        Path dstFile = dstPath.resolve(srcPath.relativize(srcFile));
                        Files.copy(srcFile, dstFile, StandardCopyOption.REPLACE_EXISTING);
                    }
                    return FileVisitResult.CONTINUE;
                }
            };
            Files.walkFileTree(srcPath, (FileVisitor<? super Path>)copyingVisitor);
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            if (this.log != null) {
                this.log.close();
            }
            return false;
        }
        if (this.outputDir != null && (this.outputDir.exists() || this.outputDir.mkdirs())) {
            LinkedHashMap<ExecutableElement, Boolean> methods = new LinkedHashMap<ExecutableElement, Boolean>();
            try {
                PrintWriter log = this.getLogger();
                TypeMirror verticleType = this.processingEnv.getElementUtils().getTypeElement(Verticle.class.getName()).asType();
                for (Element element : roundEnv.getRootElements()) {
                    Set<Modifier> modifiers = element.getModifiers();
                    if (element.getKind() != ElementKind.CLASS || modifiers.contains((Object)Modifier.ABSTRACT) || !modifiers.contains((Object)Modifier.PUBLIC) || !this.processingEnv.getTypeUtils().isSubtype(element.asType(), verticleType)) continue;
                    TypeElement typeElt = (TypeElement)element;
                    for (Element element2 : typeElt.getEnclosedElements()) {
                        ExecutableElement methodElt;
                        if (element2.getKind() != ElementKind.METHOD || !(methodElt = (ExecutableElement)element2).getSimpleName().toString().equals("start") || !methodElt.getParameters().isEmpty()) continue;
                        methods.put(methodElt, true);
                    }
                }
                roundEnv.getElementsAnnotatedWith(CodeTranslate.class).forEach(annotatedElt -> methods.put((ExecutableElement)annotatedElt, false));
                for (Map.Entry entry : methods.entrySet()) {
                    ExecutableElement methodElt = (ExecutableElement)entry.getKey();
                    boolean isVerticle = (Boolean)entry.getValue();
                    TypeElement typeElt = (TypeElement)methodElt.getEnclosingElement();
                    FileObject fileObject = this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_PATH, "", typeElt.getQualifiedName().toString().replace('.', '/') + ".java");
                    File srcFolder = new File(fileObject.toUri()).getParentFile();
                    for (Lang lang : this.langs) {
                        if (this.isSkipped(typeElt, lang) || this.isSkipped(methodElt, lang)) {
                            log.write("Skipping " + lang.id() + " translation for " + typeElt.getQualifiedName() + "#" + methodElt.getSimpleName());
                            continue;
                        }
                        List<String> fqn = Arrays.asList(typeElt.toString().split("\\."));
                        File dstFolder = new File(this.outputDir, lang.id());
                        File f = lang.createSourceFile(dstFolder, fqn, !isVerticle ? methodElt.getSimpleName().toString() : null);
                        if (!f.getParentFile().exists() && !f.getParentFile().mkdirs()) continue;
                        try {
                            String translation = this.translator.translate(methodElt, isVerticle, lang, this.renderMode);
                            Files.write(f.toPath(), translation.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                            log.println("Generated " + f.getAbsolutePath());
                            this.copyDirRec(srcFolder, f.getParentFile(), log);
                        }
                        catch (Exception e) {
                            log.println("Skipping generation of " + typeElt.getQualifiedName());
                            e.printStackTrace(log);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    private boolean isSkipped(ExecutableElement methodElt, Lang lang) {
        Set<String> excl = this.abc.get(lang.id());
        if (excl != null) {
            TypeElement typeElt = (TypeElement)methodElt.getEnclosingElement();
            String match = "" + typeElt.getQualifiedName();
            if (excl.contains(match)) {
                return true;
            }
            if (excl.contains(match = match + "#" + methodElt.getSimpleName())) {
                return true;
            }
        }
        return false;
    }

    private boolean isSkipped(TypeElement type, Lang lang) {
        if (this.config == null) {
            return false;
        }
        ArrayNode excludes = (ArrayNode)this.config.get("excludes");
        for (JsonNode exclude : excludes) {
            if (exclude.get("package") == null) {
                throw new IllegalStateException("Malformed configuration - Missing 'package' attribute in the 'codetrans.config' file");
            }
            String pck = exclude.get("package").asText();
            ArrayNode langs = (ArrayNode)exclude.get("langs");
            if (!type.getQualifiedName().toString().startsWith(pck) || !this.isLanguageSkipped(langs, lang)) continue;
            return true;
        }
        return false;
    }

    private boolean isLanguageSkipped(ArrayNode langs, Lang lang) {
        if (langs == null) {
            return true;
        }
        for (JsonNode node : langs) {
            if (!node.asText().equalsIgnoreCase(lang.getExtension())) continue;
            return true;
        }
        return false;
    }
}

