/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans;

import com.sun.source.util.Trees;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeMirrorFactory;
import io.vertx.codegen.type.TypeUse;
import io.vertx.codetrans.Lang;
import io.vertx.codetrans.MethodModel;
import io.vertx.codetrans.ModelBuilder;
import io.vertx.codetrans.RenderMode;
import io.vertx.codetrans.RunnableCompilationUnit;
import io.vertx.codetrans.VisitContext;
import io.vertx.codetrans.statement.StatementModel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Types;

public class CodeTranslator {
    private final Trees trees;
    private final DeclaredType SystemType;
    private final DeclaredType ThrowableType;
    private final Attr attr;
    private final TypeMirrorFactory factory;
    private final Types typeUtils;

    public CodeTranslator(ProcessingEnvironment processingEnv) {
        this.trees = Trees.instance(processingEnv);
        this.SystemType = (DeclaredType)processingEnv.getElementUtils().getTypeElement(System.class.getName()).asType();
        this.ThrowableType = (DeclaredType)processingEnv.getElementUtils().getTypeElement(Throwable.class.getName()).asType();
        Context context = ((JavacProcessingEnvironment)processingEnv).getContext();
        this.attr = Attr.instance(context);
        this.typeUtils = processingEnv.getTypeUtils();
        this.factory = new TypeMirrorFactory(processingEnv.getElementUtils(), processingEnv.getTypeUtils()){

            @Override
            public TypeInfo create(TypeUse use, TypeMirror type) {
                if (type.getKind() == TypeKind.WILDCARD) {
                    WildcardType wildcardType = (WildcardType)type;
                    if (wildcardType.getExtendsBound() != null) {
                        return super.create(wildcardType.getExtendsBound());
                    }
                    if (wildcardType.getSuperBound() != null) {
                        return super.create(use, wildcardType.getSuperBound());
                    }
                }
                return super.create(use, type);
            }
        };
    }

    public String translate(ExecutableElement methodElt, Lang lang) {
        return this.translate(methodElt, false, lang, RenderMode.SNIPPET);
    }

    public String translate(ExecutableElement methodElt, boolean isVerticle, Lang lang) {
        return this.translate(methodElt, isVerticle, lang, RenderMode.SNIPPET);
    }

    public String translate(ExecutableElement methodElt, boolean isVerticle, Lang lang, RenderMode renderMode) {
        TypeElement typeElt = (TypeElement)methodElt.getEnclosingElement();
        this.attributeClass(typeElt);
        ModelBuilder builder = new ModelBuilder(this.trees, typeElt, this.SystemType, this.ThrowableType, this.factory, this.typeUtils, lang);
        VisitContext visitContext = new VisitContext(lang.codeBuilder());
        MethodModel main = builder.build(methodElt, visitContext);
        HashMap<String, MethodModel> methods = new HashMap<String, MethodModel>();
        HashMap<String, StatementModel> fields = new HashMap<String, StatementModel>();
        Map<String, Boolean> pending = visitContext.getReferencedMethods().stream().collect(Collectors.toMap(k -> k, k -> true));
        visitContext.getReferencedFields().forEach(field -> pending.put((String)field, false));
        while (pending.size() > 0) {
            Iterator<Map.Entry<String, Boolean>> it = pending.entrySet().iterator();
            Map.Entry<String, Boolean> entry = it.next();
            String name = entry.getKey();
            it.remove();
            VisitContext other = null;
            if (entry.getValue().booleanValue()) {
                for (Element element : typeElt.getEnclosedElements()) {
                    if (!(element instanceof ExecutableElement) || !element.getSimpleName().toString().equals(name)) continue;
                    other = new VisitContext(visitContext.builder);
                    MethodModel method = builder.build((ExecutableElement)element, other);
                    methods.put(name, method);
                }
            } else {
                for (Element element : typeElt.getEnclosedElements()) {
                    if (!(element instanceof VariableElement) || !element.getSimpleName().toString().equals(name)) continue;
                    other = new VisitContext(visitContext.builder);
                    StatementModel statement = builder.build((VariableElement)element, other);
                    fields.put(name, statement);
                }
            }
            if (other == null) {
                throw new UnsupportedOperationException("Field / method " + name + " could not be resolved ");
            }
            for (String string : other.getReferencedMethods()) {
                if (fields.containsKey(string)) {
                    throw new UnsupportedOperationException("Duplicate field / method " + string);
                }
                if (methods.containsKey(string)) continue;
                pending.put(string, true);
            }
            for (String string : other.getReferencedFields()) {
                if (methods.containsKey(string)) {
                    throw new UnsupportedOperationException("Duplicate field / method " + string);
                }
                if (fields.containsKey(string)) continue;
                pending.put(string, false);
            }
        }
        RunnableCompilationUnit unit = new RunnableCompilationUnit(isVerticle, main, methods, fields);
        return visitContext.builder.render(unit, renderMode);
    }

    private void attributeClass(Element classElement) {
        assert (classElement.getKind() == ElementKind.CLASS);
        JCTree.JCClassDecl ct = (JCTree.JCClassDecl)this.trees.getTree(classElement);
        if (ct.sym != null && (ct.sym.flags_field & 0x10000000L) != 0L) {
            this.attr.attribClass(ct.pos(), ct.sym);
        }
    }
}

