/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.selector;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.Exclusion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExclusionDependencySelector
implements DependencySelector {
    private final Exclusion[] exclusions;
    private int hashCode;

    public ExclusionDependencySelector() {
        this.exclusions = new Exclusion[0];
    }

    public ExclusionDependencySelector(Collection<Exclusion> exclusions) {
        if (exclusions != null && !exclusions.isEmpty()) {
            TreeSet<Exclusion> sorted2 = new TreeSet<Exclusion>(ExclusionComparator.INSTANCE);
            sorted2.addAll(exclusions);
            this.exclusions = sorted2.toArray(new Exclusion[sorted2.size()]);
        } else {
            this.exclusions = new Exclusion[0];
        }
    }

    private ExclusionDependencySelector(Exclusion[] exclusions) {
        this.exclusions = exclusions;
    }

    @Override
    public boolean selectDependency(Dependency dependency) {
        Artifact artifact = dependency.getArtifact();
        for (Exclusion exclusion : this.exclusions) {
            if (!this.matches(exclusion, artifact)) continue;
            return false;
        }
        return true;
    }

    private boolean matches(Exclusion exclusion, Artifact artifact) {
        if (!this.matches(exclusion.getArtifactId(), artifact.getArtifactId())) {
            return false;
        }
        if (!this.matches(exclusion.getGroupId(), artifact.getGroupId())) {
            return false;
        }
        if (!this.matches(exclusion.getExtension(), artifact.getExtension())) {
            return false;
        }
        return this.matches(exclusion.getClassifier(), artifact.getClassifier());
    }

    private boolean matches(String pattern, String value) {
        return "*".equals(pattern) || pattern.equals(value);
    }

    @Override
    public DependencySelector deriveChildSelector(DependencyCollectionContext context) {
        Collection<Exclusion> exclusions;
        Dependency dependency = context.getDependency();
        Collection<Exclusion> collection = exclusions = dependency != null ? dependency.getExclusions() : null;
        if (exclusions == null || exclusions.isEmpty()) {
            return this;
        }
        Exclusion[] merged = this.exclusions;
        int count = merged.length;
        for (Exclusion exclusion : exclusions) {
            int index = Arrays.binarySearch(merged, exclusion, ExclusionComparator.INSTANCE);
            if (index >= 0) continue;
            index = -(index + 1);
            if (count >= merged.length) {
                Exclusion[] tmp = new Exclusion[merged.length + exclusions.size()];
                System.arraycopy(merged, 0, tmp, 0, index);
                tmp[index] = exclusion;
                System.arraycopy(merged, index, tmp, index + 1, count - index);
                merged = tmp;
            } else {
                System.arraycopy(merged, index, merged, index + 1, count - index);
                merged[index] = exclusion;
            }
            ++count;
        }
        if (merged == this.exclusions) {
            return this;
        }
        if (merged.length != count) {
            Exclusion[] tmp = new Exclusion[count];
            System.arraycopy(merged, 0, tmp, 0, count);
            merged = tmp;
        }
        return new ExclusionDependencySelector(merged);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ExclusionDependencySelector that = (ExclusionDependencySelector)obj;
        return Arrays.equals(this.exclusions, that.exclusions);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int hash = this.getClass().hashCode();
            this.hashCode = hash = hash * 31 + Arrays.hashCode(this.exclusions);
        }
        return this.hashCode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExclusionComparator
    implements Comparator<Exclusion> {
        static final ExclusionComparator INSTANCE = new ExclusionComparator();

        private ExclusionComparator() {
        }

        @Override
        public int compare(Exclusion e1, Exclusion e2) {
            if (e1 == null) {
                return e2 == null ? 0 : 1;
            }
            if (e2 == null) {
                return -1;
            }
            int rel = e1.getArtifactId().compareTo(e2.getArtifactId());
            if (rel == 0 && (rel = e1.getGroupId().compareTo(e2.getGroupId())) == 0 && (rel = e1.getExtension().compareTo(e2.getExtension())) == 0) {
                rel = e1.getClassifier().compareTo(e2.getClassifier());
            }
            return rel;
        }
    }
}

