/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.command.base;

import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.Summary;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.impl.ServerID;
import io.vertx.ext.shell.command.AnnotatedCommand;
import io.vertx.ext.shell.command.CommandProcess;
import java.util.Map;

@Name(value="net-ls")
@Summary(value="List all servers")
public class NetCommandLs
extends AnnotatedCommand {
    @Override
    public void process(CommandProcess process) {
        VertxInternal vertx = (VertxInternal)process.vertx();
        process.write("\nNet Servers:\n");
        for (Map.Entry server : vertx.sharedNetServers().entrySet()) {
            process.write(((ServerID)server.getKey()).host + ":" + ((ServerID)server.getKey()).port + "\n");
        }
        process.write("\nHTTP Servers:\n");
        for (Map.Entry server : vertx.sharedHttpServers().entrySet()) {
            process.write(((ServerID)server.getKey()).host + ":" + ((ServerID)server.getKey()).port + "\n");
        }
        process.end();
    }
}

