/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.term.impl;

import io.vertx.core.Handler;
import io.vertx.ext.shell.term.Pty;
import io.vertx.ext.shell.term.Tty;

public class PtyImpl
implements Pty {
    private int width = 80;
    private int height = 24;
    private Handler<String> stdinHandler;
    private Handler<String> stdoutHandler;
    private final String terminalType;
    private Handler<Void> resizeHandler;
    final Tty slave = new Tty(){

        @Override
        public String type() {
            return PtyImpl.this.terminalType;
        }

        @Override
        public Tty stdinHandler(Handler<String> handler) {
            PtyImpl.this.stdinHandler = handler;
            return this;
        }

        @Override
        public Tty write(String data) {
            if (PtyImpl.this.stdoutHandler != null) {
                PtyImpl.this.stdoutHandler.handle((Object)data);
            }
            return this;
        }

        @Override
        public int width() {
            return PtyImpl.this.width;
        }

        @Override
        public int height() {
            return PtyImpl.this.height;
        }

        @Override
        public Tty resizehandler(Handler<Void> handler) {
            PtyImpl.this.resizeHandler = handler;
            return this;
        }
    };

    public PtyImpl(String terminalType) {
        this.terminalType = terminalType;
    }

    @Override
    public Tty slave() {
        return this.slave;
    }

    @Override
    public Pty setSize(int width, int height) {
        this.width = width;
        this.height = height;
        if (this.resizeHandler != null) {
            this.resizeHandler.handle(null);
        }
        return this;
    }

    @Override
    public Pty stdoutHandler(Handler<String> handler) {
        this.stdoutHandler = handler;
        return this;
    }

    @Override
    public Pty write(String data) {
        if (this.stdinHandler != null) {
            this.stdinHandler.handle((Object)data);
        }
        return this;
    }
}

