/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.netty.handler.codec.http.QueryStringDecoder;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.MIMEHeader;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.BlockingHandlerDecorator;
import io.vertx.ext.web.impl.ParsableMIMEValue;
import io.vertx.ext.web.impl.RouterImpl;
import io.vertx.ext.web.impl.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RouteImpl
implements Route {
    private static final Logger log = LoggerFactory.getLogger(RouteImpl.class);
    private final RouterImpl router;
    private final Set<HttpMethod> methods = new HashSet<HttpMethod>();
    private final Set<MIMEHeader> consumes = new LinkedHashSet<MIMEHeader>();
    private final Set<MIMEHeader> produces = new LinkedHashSet<MIMEHeader>();
    private String path;
    private int order;
    private boolean enabled = true;
    private List<Handler<RoutingContext>> contextHandlers;
    private int actualHandlerIndex;
    private List<Handler<RoutingContext>> failureHandlers;
    private int actualFailureHandlerIndex;
    private boolean added;
    private Pattern pattern;
    private List<String> groups;
    private boolean useNormalisedPath = true;
    private static final Pattern RE_OPERATORS_NO_STAR = Pattern.compile("([\\(\\)\\$\\+\\.])");
    private boolean exactPath;

    RouteImpl(RouterImpl router, int order) {
        this.router = router;
        this.order = order;
        this.contextHandlers = new ArrayList<Handler<RoutingContext>>();
        this.failureHandlers = new ArrayList<Handler<RoutingContext>>();
        this.resetIndexes();
    }

    RouteImpl(RouterImpl router, int order, HttpMethod method, String path) {
        this(router, order);
        this.methods.add(method);
        this.checkPath(path);
        this.setPath(path);
    }

    RouteImpl(RouterImpl router, int order, String path) {
        this(router, order);
        this.checkPath(path);
        this.setPath(path);
    }

    RouteImpl(RouterImpl router, int order, HttpMethod method, String regex, boolean bregex) {
        this(router, order);
        this.methods.add(method);
        this.setRegex(regex);
    }

    RouteImpl(RouterImpl router, int order, String regex, boolean bregex) {
        this(router, order);
        this.setRegex(regex);
    }

    @Override
    public synchronized Route method(HttpMethod method) {
        this.methods.add(method);
        return this;
    }

    @Override
    public synchronized Route path(String path) {
        this.checkPath(path);
        this.setPath(path);
        return this;
    }

    @Override
    public synchronized Route pathRegex(String regex) {
        this.setRegex(regex);
        return this;
    }

    @Override
    public synchronized Route produces(String contentType) {
        ParsableMIMEValue value = new ParsableMIMEValue(contentType).forceParse();
        this.produces.add(value);
        return this;
    }

    @Override
    public synchronized Route consumes(String contentType) {
        ParsableMIMEValue value = new ParsableMIMEValue(contentType).forceParse();
        this.consumes.add(value);
        return this;
    }

    @Override
    public synchronized Route order(int order) {
        if (this.added) {
            throw new IllegalStateException("Can't change order after route is active");
        }
        this.order = order;
        return this;
    }

    @Override
    public synchronized Route last() {
        return this.order(Integer.MAX_VALUE);
    }

    @Override
    public synchronized Route handler(Handler<RoutingContext> contextHandler) {
        this.contextHandlers.add(contextHandler);
        this.checkAdd();
        return this;
    }

    @Override
    public Route blockingHandler(Handler<RoutingContext> contextHandler) {
        return this.blockingHandler(contextHandler, true);
    }

    @Override
    public synchronized Route blockingHandler(Handler<RoutingContext> contextHandler, boolean ordered) {
        return this.handler(new BlockingHandlerDecorator(contextHandler, ordered));
    }

    @Override
    public synchronized Route failureHandler(Handler<RoutingContext> exceptionHandler) {
        this.failureHandlers.add(exceptionHandler);
        this.checkAdd();
        return this;
    }

    @Override
    public synchronized Route remove() {
        this.router.remove(this);
        return this;
    }

    @Override
    public synchronized Route disable() {
        this.enabled = false;
        return this;
    }

    @Override
    public synchronized Route enable() {
        this.enabled = true;
        return this;
    }

    @Override
    public Route useNormalisedPath(boolean useNormalisedPath) {
        this.useNormalisedPath = useNormalisedPath;
        return this;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Route setRegexGroupsNames(List<String> groups) {
        this.groups = groups;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Route[ ");
        sb.append("path:").append(this.path);
        sb.append(" pattern:").append(this.pattern);
        sb.append(" handlers:").append(this.contextHandlers);
        sb.append(" failureHandlers:").append(this.failureHandlers);
        sb.append(" order:").append(this.order);
        sb.append(" methods:[");
        int cnt = 0;
        for (HttpMethod method : this.methods) {
            sb.append(method);
            if (++cnt >= this.methods.size()) continue;
            sb.append(",");
        }
        sb.append("]]@").append(System.identityHashCode(this));
        return sb.toString();
    }

    synchronized void handleContext(RoutingContext context) {
        if (this.hasNextContextHandler()) {
            ++this.actualHandlerIndex;
            this.contextHandlers.get(this.actualHandlerIndex - 1).handle((Object)context);
        }
    }

    synchronized void handleFailure(RoutingContext context) {
        if (this.hasNextFailureHandler()) {
            ++this.actualFailureHandlerIndex;
            this.failureHandlers.get(this.actualFailureHandlerIndex - 1).handle((Object)context);
        }
    }

    synchronized boolean matches(RoutingContext context, String mountPoint, boolean failure) {
        MIMEHeader contentType;
        MIMEHeader consumal;
        if (failure && !this.hasNextFailureHandler() || !failure && !this.hasNextContextHandler()) {
            return false;
        }
        if (!this.enabled) {
            return false;
        }
        HttpServerRequest request = context.request();
        if (!this.methods.isEmpty() && !this.methods.contains(request.method())) {
            return false;
        }
        if (this.path != null && this.pattern == null && !this.pathMatches(mountPoint, context)) {
            return false;
        }
        if (this.pattern != null) {
            Object m;
            String path;
            String string = path = this.useNormalisedPath ? Utils.normalizePath(context.request().path()) : context.request().path();
            if (mountPoint != null) {
                path = path.substring(mountPoint.length());
            }
            if (((Matcher)(m = this.pattern.matcher(path))).matches()) {
                if (((Matcher)m).groupCount() > 0) {
                    String value;
                    int i;
                    HashMap<String, String> hashMap = new HashMap<String, String>(((Matcher)m).groupCount());
                    if (this.groups != null) {
                        for (i = 0; i < this.groups.size(); ++i) {
                            String undecodedValue;
                            String k = this.groups.get(i);
                            try {
                                undecodedValue = ((Matcher)m).group("p" + i);
                            }
                            catch (IllegalArgumentException e) {
                                undecodedValue = ((Matcher)m).group(k);
                            }
                            value = Utils.urlDecode(undecodedValue, false);
                            if (!request.params().contains(k)) {
                                hashMap.put(k, value);
                                continue;
                            }
                            context.pathParams().put(k, value);
                        }
                    } else {
                        for (i = 0; i < ((Matcher)m).groupCount(); ++i) {
                            String group = ((Matcher)m).group(i + 1);
                            if (group == null) continue;
                            String k = "param" + i;
                            value = Utils.urlDecode(group, false);
                            if (!request.params().contains(k)) {
                                hashMap.put(k, value);
                                continue;
                            }
                            context.pathParams().put(k, value);
                        }
                    }
                    request.params().addAll(hashMap);
                    context.pathParams().putAll(hashMap);
                }
            } else {
                return false;
            }
        }
        if (context.queryParams().size() == 0) {
            Map decodedParams = new QueryStringDecoder(request.uri()).parameters();
            for (Map.Entry entry : decodedParams.entrySet()) {
                context.queryParams().add((String)entry.getKey(), (Iterable)entry.getValue());
            }
        }
        if (!this.consumes.isEmpty() && (consumal = (contentType = context.parsedHeaders().contentType()).findMatchedBy(this.consumes)) == null) {
            return false;
        }
        List<MIMEHeader> acceptableTypes = context.parsedHeaders().accept();
        if (!this.produces.isEmpty() && !acceptableTypes.isEmpty()) {
            MIMEHeader selectedAccept = context.parsedHeaders().findBestUserAcceptedIn(acceptableTypes, this.produces);
            if (selectedAccept != null) {
                context.setAcceptableContentType(selectedAccept.rawValue());
                return true;
            }
            return false;
        }
        return true;
    }

    RouterImpl router() {
        return this.router;
    }

    private boolean pathMatches(String mountPoint, RoutingContext ctx) {
        String requestPath;
        String thePath;
        String string = thePath = mountPoint == null ? this.path : mountPoint + this.path;
        if (this.useNormalisedPath) {
            requestPath = Utils.normalizePath(ctx.request().path());
        } else {
            requestPath = ctx.request().path();
            if (requestPath == null) {
                requestPath = "/";
            }
        }
        if (this.exactPath) {
            return this.pathMatchesExact(requestPath, thePath);
        }
        if (thePath.endsWith("/") && requestPath.equals(this.removeTrailing(thePath))) {
            return true;
        }
        return requestPath.startsWith(thePath);
    }

    private boolean pathMatchesExact(String path1, String path2) {
        return this.removeTrailing(path1).equals(this.removeTrailing(path2));
    }

    private String removeTrailing(String path) {
        int i = path.length();
        if (path.charAt(i - 1) == '/') {
            path = path.substring(0, i - 1);
        }
        return path;
    }

    private void setPath(String path) {
        if (path.indexOf(58) != -1) {
            this.createPatternRegex(path);
            this.path = path;
        } else if (path.charAt(path.length() - 1) != '*') {
            this.exactPath = true;
            this.path = path;
        } else {
            this.exactPath = false;
            this.path = path.substring(0, path.length() - 1);
        }
    }

    private void setRegex(String regex) {
        this.pattern = Pattern.compile(regex);
    }

    private void createPatternRegex(String path) {
        if ((path = RE_OPERATORS_NO_STAR.matcher(path).replaceAll("\\\\$1")).charAt(path.length() - 1) == '*') {
            path = path.substring(0, path.length() - 1) + ".*";
        }
        Matcher m = Pattern.compile(":([A-Za-z][A-Za-z0-9_]*)").matcher(path);
        StringBuffer sb = new StringBuffer();
        this.groups = new ArrayList<String>();
        int index = 0;
        while (m.find()) {
            String param = "p" + index;
            String group = m.group().substring(1);
            if (this.groups.contains(group)) {
                throw new IllegalArgumentException("Cannot use identifier " + group + " more than once in pattern string");
            }
            m.appendReplacement(sb, "(?<" + param + ">[^/]+)");
            this.groups.add(group);
            ++index;
        }
        m.appendTail(sb);
        path = sb.toString();
        this.pattern = Pattern.compile(path);
    }

    private void checkPath(String path) {
        if ("".equals(path) || path.charAt(0) != '/') {
            throw new IllegalArgumentException("Path must start with /");
        }
    }

    int order() {
        return this.order;
    }

    private void checkAdd() {
        if (!this.added) {
            this.router.add(this);
            this.added = true;
        }
    }

    protected synchronized boolean hasNextContextHandler() {
        return this.actualHandlerIndex < this.contextHandlers.size();
    }

    protected synchronized boolean hasNextFailureHandler() {
        return this.actualFailureHandlerIndex < this.failureHandlers.size();
    }

    protected synchronized void resetIndexes() {
        this.actualFailureHandlerIndex = 0;
        this.actualHandlerIndex = 0;
    }
}

