/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation;

import brave.Tracing;
import brave.internal.Nullable;
import brave.internal.PredefinedPropagationFields;
import brave.internal.PropagationFields;
import brave.internal.PropagationFieldsFactory;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class ExtraFieldPropagation<K>
implements Propagation<K> {
    final Propagation<K> delegate;
    final ExtraFactory extraFactory;
    final String[] fieldNames;
    final List<K> keys;
    final List<K> allKeys;

    public static Propagation.Factory newFactory(Propagation.Factory delegate, String ... fieldNames) {
        if (delegate == null) {
            throw new NullPointerException("delegate == null");
        }
        if (fieldNames == null) {
            throw new NullPointerException("fieldNames == null");
        }
        String[] validated = ExtraFieldPropagation.ensureLowerCase(Arrays.asList(fieldNames));
        return new Factory(delegate, validated, validated);
    }

    public static Propagation.Factory newFactory(Propagation.Factory delegate, Collection<String> fieldNames) {
        if (delegate == null) {
            throw new NullPointerException("delegate == null");
        }
        if (fieldNames == null) {
            throw new NullPointerException("fieldNames == null");
        }
        String[] validated = ExtraFieldPropagation.ensureLowerCase(fieldNames);
        return new Factory(delegate, validated, validated);
    }

    public static FactoryBuilder newFactoryBuilder(Propagation.Factory delegate) {
        return new FactoryBuilder(delegate);
    }

    @Nullable
    public static String current(String name) {
        return ExtraFieldPropagation.get(name);
    }

    @Nullable
    public static String get(String name) {
        TraceContext context = ExtraFieldPropagation.currentTraceContext();
        return context != null ? ExtraFieldPropagation.get(context, name) : null;
    }

    public static void set(String name, String value) {
        TraceContext context = ExtraFieldPropagation.currentTraceContext();
        if (context != null) {
            ExtraFieldPropagation.set(context, name, value);
        }
    }

    public static Map<String, String> getAll() {
        TraceContext context = ExtraFieldPropagation.currentTraceContext();
        if (context == null) {
            return Collections.emptyMap();
        }
        return ExtraFieldPropagation.getAll(context);
    }

    public static Map<String, String> getAll(TraceContextOrSamplingFlags extracted) {
        if (extracted == null) {
            throw new NullPointerException("extracted == null");
        }
        TraceContext extractedContext = extracted.context();
        if (extractedContext != null) {
            return ExtraFieldPropagation.getAll(extractedContext.extra());
        }
        return ExtraFieldPropagation.getAll(extracted.extra());
    }

    public static Map<String, String> getAll(TraceContext context) {
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        return ExtraFieldPropagation.getAll(context.extra());
    }

    @Nullable
    static TraceContext currentTraceContext() {
        Tracing tracing = Tracing.current();
        return tracing != null ? tracing.currentTraceContext().get() : null;
    }

    @Nullable
    public static String get(TraceContext context, String name) {
        return PropagationFields.get(context, ExtraFieldPropagation.lowercase(name));
    }

    public static void set(TraceContext context, String name, String value) {
        PropagationFields.put(context, ExtraFieldPropagation.lowercase(name), value);
    }

    ExtraFieldPropagation(Factory factory, Propagation.KeyFactory<K> keyFactory, List<K> keys) {
        this.delegate = factory.delegate.create(keyFactory);
        this.extraFactory = factory.extraFactory;
        this.fieldNames = factory.fieldNames;
        this.keys = keys;
        ArrayList<K> allKeys = new ArrayList<K>(this.delegate.keys());
        allKeys.addAll(keys);
        this.allKeys = allKeys;
    }

    @Override
    public List<K> keys() {
        return this.allKeys;
    }

    @Override
    public <C> TraceContext.Injector<C> injector(Propagation.Setter<C, K> setter) {
        return new ExtraFieldInjector<C, K>(this, setter);
    }

    @Override
    public <C> TraceContext.Extractor<C> extractor(Propagation.Getter<C, K> getter) {
        return new ExtraFieldExtractor<C, K>(this, getter);
    }

    static Map<String, String> getAll(List<Object> extraList) {
        PropagationFields fields = PropagationFields.find(extraList);
        return fields != null ? fields.toMap() : Collections.emptyMap();
    }

    static String[] ensureLowerCase(Collection<String> names) {
        if (names.isEmpty()) {
            throw new IllegalArgumentException("names is empty");
        }
        Iterator<String> nextName = names.iterator();
        String[] result = new String[names.size()];
        int i = 0;
        while (nextName.hasNext()) {
            String name = nextName.next();
            if (name == null) {
                throw new NullPointerException("names[" + i + "] == null");
            }
            if ((name = name.trim()).isEmpty()) {
                throw new IllegalArgumentException("names[" + i + "] is empty");
            }
            result[i] = name.toLowerCase(Locale.ROOT);
            ++i;
        }
        return result;
    }

    static String lowercase(String name) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        return name.toLowerCase(Locale.ROOT);
    }

    static final class Extra
    extends PredefinedPropagationFields {
        Extra(String ... fieldNames) {
            super(fieldNames);
        }

        Extra(Extra parent, String ... fieldNames) {
            super(parent, fieldNames);
        }
    }

    static final class ExtraFactory
    extends PropagationFieldsFactory<Extra> {
        final String[] fieldNames;

        ExtraFactory(String[] fieldNames) {
            this.fieldNames = fieldNames;
        }

        @Override
        protected Class<Extra> type() {
            return Extra.class;
        }

        @Override
        protected Extra create() {
            return new Extra(this.fieldNames);
        }

        @Override
        protected Extra create(Extra parent) {
            return new Extra(parent, this.fieldNames);
        }
    }

    static final class ExtraFieldExtractor<C, K>
    implements TraceContext.Extractor<C> {
        final ExtraFieldPropagation<K> propagation;
        final TraceContext.Extractor<C> delegate;
        final Propagation.Getter<C, K> getter;

        ExtraFieldExtractor(ExtraFieldPropagation<K> propagation, Propagation.Getter<C, K> getter) {
            this.propagation = propagation;
            this.delegate = propagation.delegate.extractor(getter);
            this.getter = getter;
        }

        @Override
        public TraceContextOrSamplingFlags extract(C carrier) {
            TraceContextOrSamplingFlags result = this.delegate.extract(carrier);
            Extra fields = this.propagation.extraFactory.create();
            int length = this.propagation.fieldNames.length;
            for (int i = 0; i < length; ++i) {
                String maybeValue = this.getter.get(carrier, this.propagation.keys.get(i));
                if (maybeValue == null) continue;
                fields.put(i, maybeValue);
            }
            return result.toBuilder().addExtra(fields).build();
        }
    }

    static final class ExtraFieldInjector<C, K>
    implements TraceContext.Injector<C> {
        final TraceContext.Injector<C> delegate;
        final Propagation.Setter<C, K> setter;
        final String[] fieldNames;
        final List<K> keys;

        ExtraFieldInjector(ExtraFieldPropagation<K> propagation, Propagation.Setter<C, K> setter) {
            this.delegate = propagation.delegate.injector(setter);
            this.fieldNames = propagation.fieldNames;
            this.keys = propagation.keys;
            this.setter = setter;
        }

        @Override
        public void inject(TraceContext traceContext, C carrier) {
            this.delegate.inject(traceContext, carrier);
            List<Object> extra = traceContext.extra();
            int length = extra.size();
            for (int i = 0; i < length; ++i) {
                Object next = extra.get(i);
                if (!(next instanceof Extra)) continue;
                this.inject((Extra)next, carrier);
                return;
            }
        }

        void inject(Extra fields, C carrier) {
            int length = this.keys.size();
            for (int i = 0; i < length; ++i) {
                String maybeValue = fields.get(i);
                if (maybeValue == null) continue;
                this.setter.put(carrier, this.keys.get(i), maybeValue);
            }
        }
    }

    static final class Factory
    extends Propagation.Factory {
        final Propagation.Factory delegate;
        final String[] fieldNames;
        final String[] keyNames;
        final ExtraFactory extraFactory;

        Factory(Propagation.Factory delegate, String[] fieldNames, String[] keyNames) {
            this.delegate = delegate;
            this.fieldNames = fieldNames;
            this.keyNames = keyNames;
            this.extraFactory = new ExtraFactory(fieldNames);
        }

        @Override
        public boolean supportsJoin() {
            return this.delegate.supportsJoin();
        }

        @Override
        public boolean requires128BitTraceId() {
            return this.delegate.requires128BitTraceId();
        }

        @Override
        public final <K> Propagation<K> create(Propagation.KeyFactory<K> keyFactory) {
            int length = this.fieldNames.length;
            ArrayList<K> keys = new ArrayList<K>(length);
            for (int i = 0; i < length; ++i) {
                keys.add(keyFactory.create(this.keyNames[i]));
            }
            return new ExtraFieldPropagation<K>(this, keyFactory, keys);
        }

        @Override
        public TraceContext decorate(TraceContext context) {
            TraceContext result = this.delegate.decorate(context);
            return this.extraFactory.decorate(result);
        }
    }

    public static final class FactoryBuilder {
        final Propagation.Factory delegate;
        final List<String> fieldNames = new ArrayList<String>();
        final Map<String, String[]> prefixedNames = new LinkedHashMap<String, String[]>();

        FactoryBuilder(Propagation.Factory delegate) {
            if (delegate == null) {
                throw new NullPointerException("delegate == null");
            }
            this.delegate = delegate;
        }

        public FactoryBuilder addField(String fieldName) {
            if (fieldName == null) {
                throw new NullPointerException("fieldName == null");
            }
            if ((fieldName = fieldName.trim()).isEmpty()) {
                throw new IllegalArgumentException("fieldName is empty");
            }
            this.fieldNames.add(fieldName.toLowerCase(Locale.ROOT));
            return this;
        }

        public FactoryBuilder addPrefixedFields(String prefix, Collection<String> fieldNames) {
            if (prefix == null) {
                throw new NullPointerException("prefix == null");
            }
            if (prefix.isEmpty()) {
                throw new IllegalArgumentException("prefix is empty");
            }
            if (fieldNames == null) {
                throw new NullPointerException("fieldNames == null");
            }
            this.prefixedNames.put(prefix, ExtraFieldPropagation.ensureLowerCase(fieldNames));
            return this;
        }

        public Factory build() {
            if (this.prefixedNames.isEmpty()) {
                String[] validated = ExtraFieldPropagation.ensureLowerCase(this.fieldNames);
                return new Factory(this.delegate, validated, validated);
            }
            ArrayList<String> fields = new ArrayList<String>();
            ArrayList<String> keys = new ArrayList<String>();
            if (!this.fieldNames.isEmpty()) {
                List<String> validated = Arrays.asList(ExtraFieldPropagation.ensureLowerCase(this.fieldNames));
                fields.addAll(validated);
                keys.addAll(validated);
            }
            for (Map.Entry<String, String[]> entry : this.prefixedNames.entrySet()) {
                String[] nextFieldNames;
                String nextPrefix = entry.getKey();
                for (String nextFieldName : nextFieldNames = entry.getValue()) {
                    fields.add(nextFieldName);
                    keys.add(nextPrefix + nextFieldName);
                }
            }
            return new Factory(this.delegate, fields.toArray(new String[0]), keys.toArray(new String[0]));
        }
    }
}

