/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation;

import brave.internal.Nullable;

public class SamplingFlags {
    static final int FLAG_SAMPLED = 2;
    static final int FLAG_SAMPLED_SET = 4;
    static final int FLAG_DEBUG = 8;
    public static final SamplingFlags EMPTY = new SamplingFlags(0);
    public static final SamplingFlags NOT_SAMPLED = new SamplingFlags(4);
    public static final SamplingFlags SAMPLED = new SamplingFlags(SamplingFlags.NOT_SAMPLED.flags | 2);
    public static final SamplingFlags DEBUG = new SamplingFlags(SamplingFlags.SAMPLED.flags | 8);
    final int flags;

    SamplingFlags(int flags) {
        this.flags = flags;
    }

    @Nullable
    public final Boolean sampled() {
        return SamplingFlags.sampled(this.flags);
    }

    public final boolean debug() {
        return SamplingFlags.debug(this.flags);
    }

    public String toString() {
        return "SamplingFlags(sampled=" + this.sampled() + ", debug=" + this.debug() + ")";
    }

    private static Boolean sampled(int flags) {
        return (flags & 4) == 4 ? Boolean.valueOf((flags & 2) == 2) : null;
    }

    private static boolean debug(int flags) {
        return (flags & 8) == 8;
    }

    public static final class Builder {
        int flags = 0;

        public Builder sampled(@Nullable Boolean sampled) {
            if (sampled == null) {
                this.flags &= 0xFFFFFFFB;
                this.flags &= 0xFFFFFFFD;
                return this;
            }
            this.flags |= 4;
            this.flags = sampled.booleanValue() ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
            return this;
        }

        public Builder debug(boolean debug) {
            if (debug) {
                this.flags |= 8;
                this.flags |= 4;
                this.flags |= 2;
            } else {
                this.flags &= 0xFFFFFFF7;
            }
            return this;
        }

        public static SamplingFlags build(@Nullable Boolean sampled) {
            if (sampled != null) {
                return sampled != false ? SAMPLED : NOT_SAMPLED;
            }
            return EMPTY;
        }

        public SamplingFlags build() {
            return this.flags == 0 ? EMPTY : (SamplingFlags.debug(this.flags) ? DEBUG : (SamplingFlags.sampled(this.flags) != false ? SAMPLED : NOT_SAMPLED));
        }
    }
}

