/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation;

import brave.internal.Nullable;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;

public final class StrictCurrentTraceContext
extends CurrentTraceContext {
    final ThreadLocal<TraceContext> local = new ThreadLocal();

    @Override
    public TraceContext get() {
        return this.local.get();
    }

    @Override
    public CurrentTraceContext.Scope newScope(@Nullable TraceContext currentSpan) {
        TraceContext previous = this.local.get();
        this.local.set(currentSpan);
        return new StrictScope(previous, new Error(String.format("Thread %s opened scope for %s here:", Thread.currentThread().getName(), currentSpan)));
    }

    class StrictScope
    implements CurrentTraceContext.Scope {
        final TraceContext previous;
        final Throwable caller;
        final long threadId = Thread.currentThread().getId();

        StrictScope(TraceContext previous, Throwable caller) {
            this.previous = previous;
            this.caller = caller;
        }

        @Override
        public void close() {
            if (Thread.currentThread().getId() != this.threadId) {
                throw new IllegalStateException("scope closed in a different thread: " + Thread.currentThread().getName(), this.caller);
            }
            StrictCurrentTraceContext.this.local.set(this.previous);
        }

        public String toString() {
            return this.caller.toString();
        }
    }
}

