/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation;

import brave.internal.HexCodec;
import brave.internal.Nullable;
import brave.propagation.SamplingFlags;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class TraceIdContext
extends SamplingFlags {
    static final Logger LOG = Logger.getLogger(TraceIdContext.class.getName());
    final long traceIdHigh;
    final long traceId;

    public static Builder newBuilder() {
        return new Builder();
    }

    public long traceIdHigh() {
        return this.traceIdHigh;
    }

    public long traceId() {
        return this.traceId;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public String toString() {
        boolean traceHi = this.traceIdHigh != 0L;
        char[] result = new char[traceHi ? 32 : 16];
        int pos = 0;
        if (traceHi) {
            HexCodec.writeHexLong(result, pos, this.traceIdHigh);
            pos += 16;
        }
        HexCodec.writeHexLong(result, pos, this.traceId);
        return new String(result);
    }

    TraceIdContext(Builder builder) {
        super(builder.flags);
        this.traceIdHigh = builder.traceIdHigh;
        this.traceId = builder.traceId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TraceIdContext)) {
            return false;
        }
        TraceIdContext that = (TraceIdContext)o;
        return this.traceIdHigh == that.traceIdHigh && this.traceId == that.traceId;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= (int)(this.traceIdHigh >>> 32 ^ this.traceIdHigh);
        h *= 1000003;
        return h ^= (int)(this.traceId >>> 32 ^ this.traceId);
    }

    static abstract class InternalBuilder {
        long traceIdHigh;
        long traceId;
        int flags = 0;

        InternalBuilder() {
        }

        abstract Logger logger();

        final boolean parseTraceId(String traceIdString, Object key) {
            if (this.isNull(key, traceIdString)) {
                return false;
            }
            int length = traceIdString.length();
            if (this.invalidIdLength(key, length, 32)) {
                return false;
            }
            int traceIdIndex = Math.max(0, length - 16);
            if (traceIdIndex > 0) {
                this.traceIdHigh = HexCodec.lenientLowerHexToUnsignedLong(traceIdString, 0, traceIdIndex);
                if (this.traceIdHigh == 0L) {
                    this.maybeLogNotLowerHex(key, traceIdString);
                    return false;
                }
            }
            this.traceId = HexCodec.lenientLowerHexToUnsignedLong(traceIdString, traceIdIndex, length);
            if (this.traceId == 0L) {
                this.maybeLogNotLowerHex(key, traceIdString);
                return false;
            }
            return true;
        }

        boolean invalidIdLength(Object key, int length, int max) {
            if (length > 1 && length <= max) {
                return false;
            }
            Logger log = this.logger();
            if (log.isLoggable(Level.FINE)) {
                log.fine(key + " should be a 1 to " + max + " character lower-hex string with no prefix");
            }
            return true;
        }

        boolean isNull(Object key, String maybeNull) {
            if (maybeNull != null) {
                return false;
            }
            Logger log = this.logger();
            if (log.isLoggable(Level.FINE)) {
                log.fine(key + " was null");
            }
            return true;
        }

        void maybeLogNotLowerHex(Object key, String notLowerHex) {
            Logger log = this.logger();
            if (log.isLoggable(Level.FINE)) {
                log.fine(key + ": " + notLowerHex + " is not a lower-hex string");
            }
        }

        InternalBuilder sampled(boolean sampled) {
            this.flags |= 4;
            this.flags = sampled ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
            return this;
        }

        InternalBuilder sampled(@Nullable Boolean sampled) {
            if (sampled != null) {
                return this.sampled((boolean)sampled);
            }
            this.flags &= 0xFFFFFFFB;
            return this;
        }

        InternalBuilder debug(boolean debug) {
            if (debug) {
                this.flags |= 8;
                this.flags |= 4;
                this.flags |= 2;
            } else {
                this.flags &= 0xFFFFFFF7;
            }
            return this;
        }
    }

    public static final class Builder
    extends InternalBuilder {
        Builder(TraceIdContext context) {
            this.traceIdHigh = context.traceIdHigh;
            this.traceId = context.traceId;
            this.flags = context.flags;
        }

        public Builder traceIdHigh(long traceIdHigh) {
            this.traceIdHigh = traceIdHigh;
            return this;
        }

        public Builder traceId(long traceId) {
            this.traceId = traceId;
            return this;
        }

        @Override
        public Builder sampled(boolean sampled) {
            super.sampled(sampled);
            return this;
        }

        @Override
        public Builder sampled(@Nullable Boolean sampled) {
            super.sampled(sampled);
            return this;
        }

        @Override
        public Builder debug(boolean debug) {
            super.debug(debug);
            return this;
        }

        public final TraceIdContext build() {
            if (this.traceId == 0L) {
                throw new IllegalStateException("Missing: traceId");
            }
            return new TraceIdContext(this);
        }

        @Override
        Logger logger() {
            return LOG;
        }

        Builder() {
        }
    }
}

