/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.apps.cockpit;

import contribs.com.centerkey.utils.BareBonesBrowserLaunch;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.jets3t.apps.cockpit.CockpitPreferences;
import org.jets3t.apps.cockpit.gui.AccessControlDialog;
import org.jets3t.apps.cockpit.gui.BucketLoggingDialog;
import org.jets3t.apps.cockpit.gui.BucketTableModel;
import org.jets3t.apps.cockpit.gui.CreateBucketDialog;
import org.jets3t.apps.cockpit.gui.ObjectTableModel;
import org.jets3t.apps.cockpit.gui.PreferencesDialog;
import org.jets3t.apps.cockpit.gui.RequesterPaysDialog;
import org.jets3t.apps.cockpit.gui.SignedGetUrlDialog;
import org.jets3t.apps.cockpit.gui.StartupDialog;
import org.jets3t.gui.AuthenticationDialog;
import org.jets3t.gui.CopyObjectsDialog;
import org.jets3t.gui.ErrorDialog;
import org.jets3t.gui.GuiUtils;
import org.jets3t.gui.HyperlinkActivatedListener;
import org.jets3t.gui.ItemPropertiesDialog;
import org.jets3t.gui.JHtmlLabel;
import org.jets3t.gui.ManageDistributionsDialog;
import org.jets3t.gui.ObjectsAttributesDialog;
import org.jets3t.gui.ProgressDialog;
import org.jets3t.gui.TableSorter;
import org.jets3t.gui.skins.SkinsFactory;
import org.jets3t.service.CloudFrontService;
import org.jets3t.service.CloudFrontServiceException;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.StorageObjectsChunk;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.io.BytesProgressWatcher;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.model.cloudfront.Distribution;
import org.jets3t.service.multithread.CancelEventTrigger;
import org.jets3t.service.multithread.CopyObjectsEvent;
import org.jets3t.service.multithread.CreateBucketsEvent;
import org.jets3t.service.multithread.CreateObjectsEvent;
import org.jets3t.service.multithread.DeleteObjectsEvent;
import org.jets3t.service.multithread.DeleteVersionedObjectsEvent;
import org.jets3t.service.multithread.DownloadObjectsEvent;
import org.jets3t.service.multithread.DownloadPackage;
import org.jets3t.service.multithread.GetObjectHeadsEvent;
import org.jets3t.service.multithread.GetObjectsEvent;
import org.jets3t.service.multithread.ListObjectsEvent;
import org.jets3t.service.multithread.LookupACLEvent;
import org.jets3t.service.multithread.S3ServiceEventListener;
import org.jets3t.service.multithread.S3ServiceMulti;
import org.jets3t.service.multithread.ThreadWatcher;
import org.jets3t.service.multithread.UpdateACLEvent;
import org.jets3t.service.security.EncryptionUtil;
import org.jets3t.service.security.ProviderCredentials;
import org.jets3t.service.utils.ByteFormatter;
import org.jets3t.service.utils.FileComparer;
import org.jets3t.service.utils.FileComparerResults;
import org.jets3t.service.utils.Mimetypes;
import org.jets3t.service.utils.ObjectUtils;
import org.jets3t.service.utils.TimeFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cockpit
extends JApplet
implements S3ServiceEventListener,
ActionListener,
ListSelectionListener,
HyperlinkActivatedListener,
CredentialsProvider {
    private static final long serialVersionUID = -3193198830234682011L;
    private static final Log log = LogFactory.getLog(Cockpit.class);
    public static final String JETS3T_COCKPIT_HELP_PAGE = "http://www.jets3t.org/applications/cockpit.html";
    public static final String AMAZON_S3_PAGE = "http://www.amazon.com/s3";
    public static final String OS_NAME_MAC = "Mac OS X";
    public static final String APPLICATION_DESCRIPTION = "Cockpit/0.9.4";
    public static final String APPLICATION_TITLE = "JetS3t Cockpit";
    private static final int BUCKET_LIST_CHUNKING_SIZE = 1000;
    private final File cockpitHomeDirectory = Constants.DEFAULT_PREFERENCES_DIRECTORY;
    private CockpitPreferences cockpitPreferences = null;
    private final Insets insetsZero = new Insets(0, 0, 0, 0);
    private final Insets insetsDefault = new Insets(5, 7, 5, 7);
    private final ByteFormatter byteFormatter = new ByteFormatter();
    private final TimeFormatter timeFormatter = new TimeFormatter();
    private final SimpleDateFormat yearAndTimeSDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final SimpleDateFormat timeSDF = new SimpleDateFormat("HH:mm:ss");
    private final GuiUtils guiUtils = new GuiUtils();
    private boolean isTargetS3 = true;
    private String originalTargetEndpoint = null;
    private S3ServiceMulti s3ServiceMulti = null;
    private CloudFrontService cloudFrontService = null;
    private boolean cloudFrontMembershipChecked = false;
    private JFrame ownerFrame = null;
    private boolean isStandAloneApplication = false;
    private JMenuItem loginMenuItem = null;
    private JMenuItem logoutMenuItem = null;
    private JMenu loginSwitchMenu = null;
    private JPopupMenu bucketActionMenu = null;
    private JMenuItem viewBucketPropertiesMenuItem = null;
    private JMenuItem refreshBucketMenuItem = null;
    private JMenuItem createBucketMenuItem = null;
    private JMenuItem manageDistributionsMenuItem = null;
    private JMenuItem updateBucketACLMenuItem = null;
    private JMenuItem updateBucketRequesterPaysStatusMenuItem = null;
    private JMenuItem deleteBucketMenuItem = null;
    private JPopupMenu objectActionMenu = null;
    private JMenuItem refreshObjectMenuItem = null;
    private JMenuItem viewOrModifyObjectAttributesMenuItem = null;
    private JMenuItem copyObjectsMenuItem = null;
    private JMenuItem updateObjectACLMenuItem = null;
    private JMenuItem downloadObjectMenuItem = null;
    private JMenuItem uploadFilesMenuItem = null;
    private JMenuItem generatePublicGetUrls = null;
    private JMenuItem generateTorrentUrl = null;
    private JMenuItem deleteObjectMenuItem = null;
    private JMenuItem bucketLoggingMenuItem = null;
    private JMenuItem preferencesDialogMenuItem = null;
    private JMenuItem cockpitHelpMenuItem = null;
    private JMenuItem amazonS3HelpMenuItem = null;
    private JTable bucketsTable = null;
    private JTable objectsTable = null;
    private JScrollPane objectsTableSP = null;
    private BucketTableModel bucketTableModel = null;
    private TableSorter bucketTableModelSorter = null;
    private ObjectTableModel objectTableModel = null;
    private TableSorter objectTableModelSorter = null;
    private JLabel objectsSummaryLabel = null;
    private final HashMap cachedBuckets = new HashMap();
    private ProgressDialog progressDialog = null;
    private ObjectsAttributesDialog objectsAttributesDialog = null;
    private File downloadDirectory = null;
    private File fileChoosersLastUploadDirectory = null;
    private JPanel filterObjectsPanel = null;
    private JCheckBox filterObjectsCheckBox = null;
    private JTextField filterObjectsPrefix = null;
    private JComboBox filterObjectsDelimiter = null;
    private static final String UPLOAD_NEW_FILES_ONLY = "Only upload new files";
    private static final String UPLOAD_NEW_AND_CHANGED_FILES = "Upload new and changed files";
    private static final String UPLOAD_ALL_FILES = "Upload all files";
    private static final String DOWNLOAD_NEW_FILES_ONLY = "Only download new files";
    private static final String DOWNLOAD_NEW_AND_CHANGED_FILES = "Download new and changed files";
    private static final String DOWNLOAD_ALL_FILES = "Download all files";
    private EncryptionUtil encryptionUtil = null;
    private Jets3tProperties cockpitProperties = null;
    private SkinsFactory skinsFactory = null;
    private S3Bucket currentSelectedBucket = null;
    private final HashMap<String, ProviderCredentials> loginAwsCredentialsMap = new HashMap();
    private final CredentialsProvider mCredentialProvider = new BasicCredentialsProvider();

    public Cockpit() {
    }

    public Cockpit(JFrame ownerFrame) throws S3ServiceException {
        this();
        this.ownerFrame = ownerFrame;
        this.isStandAloneApplication = true;
        this.init();
        ownerFrame.getContentPane().add(this);
        ownerFrame.setBounds(this.getBounds());
        ownerFrame.setVisible(true);
    }

    protected RestS3Service getRestS3Service(ProviderCredentials credentials) throws S3ServiceException {
        if (!this.isTargetS3) {
            this.originalTargetEndpoint = this.cockpitProperties.getStringProperty("s3service.s3-endpoint", Constants.S3_DEFAULT_HOSTNAME);
            this.cockpitProperties.setProperty("s3service.s3-endpoint", Constants.GS_DEFAULT_HOSTNAME);
        } else if (this.originalTargetEndpoint != null) {
            this.cockpitProperties.setProperty("s3service.s3-endpoint", this.originalTargetEndpoint);
        }
        return new RestS3Service(credentials, APPLICATION_DESCRIPTION, this, this.cockpitProperties);
    }

    @Override
    public void init() {
        File jets3tPropertiesFile;
        super.init();
        if (this.ownerFrame == null) {
            Container c = this;
            while (!(c instanceof Frame) && c.getParent() != null) {
                c = c.getParent();
            }
            this.ownerFrame = !(c instanceof JFrame) ? new JFrame() : (JFrame)c;
        }
        this.initGui();
        File mimeTypesFile = new File(this.cockpitHomeDirectory, "mime.types");
        if (mimeTypesFile.exists()) {
            try {
                Mimetypes.getInstance().loadAndReplaceMimetypes(new FileInputStream(mimeTypesFile));
            }
            catch (IOException e) {
                String message = "Unable to load mime.types file: " + mimeTypesFile;
                log.error((Object)message, (Throwable)e);
                ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, message, (Throwable)e);
            }
        }
        if ((jets3tPropertiesFile = new File(this.cockpitHomeDirectory, "jets3t.properties")).exists()) {
            try {
                Jets3tProperties.getInstance(Constants.JETS3T_PROPERTIES_FILENAME).loadAndReplaceProperties(new FileInputStream(jets3tPropertiesFile), "jets3t.properties in Cockpit's home folder " + this.cockpitHomeDirectory);
            }
            catch (IOException e) {
                String message = "Unable to load jets3t.properties file: " + jets3tPropertiesFile;
                log.error((Object)message, (Throwable)e);
                ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, message, (Throwable)e);
            }
        }
        this.cockpitPreferences = new CockpitPreferences();
        File cockpitPreferencesPropertiesFile = new File(this.cockpitHomeDirectory, Constants.COCKPIT_PROPERTIES_FILENAME);
        if (cockpitPreferencesPropertiesFile.exists()) {
            try {
                Properties properties = new Properties();
                properties.load(new FileInputStream(cockpitPreferencesPropertiesFile));
                this.cockpitPreferences.fromProperties(properties);
            }
            catch (IOException e) {
                String message = "Unable to load your preferences";
                log.error((Object)message, (Throwable)e);
                ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, message, (Throwable)e);
            }
        }
        this.cockpitProperties = Jets3tProperties.getInstance(Constants.JETS3T_PROPERTIES_FILENAME);
        this.skinsFactory = SkinsFactory.getInstance(this.cockpitProperties.getProperties());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Cockpit.this.loginEvent(null);
            }
        });
    }

    private void initGui() {
        this.initMenus();
        JPanel appContent = new JPanel(new GridBagLayout());
        this.getContentPane().add(appContent);
        JPanel bucketsPanel = new JPanel(new GridBagLayout());
        JButton bucketActionButton = new JButton();
        bucketActionButton.setToolTipText("Bucket actions menu");
        this.guiUtils.applyIcon(bucketActionButton, "/images/nuvola/16x16/actions/misc.png");
        bucketActionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JButton sourceButton = (JButton)e.getSource();
                Cockpit.this.bucketActionMenu.show(sourceButton, 0, sourceButton.getHeight());
            }
        });
        bucketsPanel.add((Component)new JHtmlLabel("<html><b>Buckets</b></html>", this), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, this.insetsZero, 0, 0));
        bucketsPanel.add((Component)bucketActionButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, this.insetsZero, 0, 0));
        this.bucketTableModel = new BucketTableModel(false);
        this.bucketTableModelSorter = new TableSorter(this.bucketTableModel);
        this.bucketsTable = new JTable(this.bucketTableModelSorter);
        this.bucketTableModelSorter.setTableHeader(this.bucketsTable.getTableHeader());
        this.bucketsTable.setSelectionMode(0);
        this.bucketsTable.getSelectionModel().addListSelectionListener(this);
        this.bucketsTable.setShowHorizontalLines(true);
        this.bucketsTable.setShowVerticalLines(false);
        this.bucketsTable.addMouseListener(new ContextMenuListener());
        bucketsPanel.add((Component)new JScrollPane(this.bucketsTable), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, this.insetsZero, 0, 0));
        bucketsPanel.add((Component)new JLabel(" "), new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, this.insetsDefault, 0, 0));
        this.filterObjectsPanel = new JPanel(new GridBagLayout());
        this.filterObjectsPrefix = new JTextField();
        this.filterObjectsPrefix.setToolTipText("Only show objects with this prefix");
        this.filterObjectsPrefix.addActionListener(this);
        this.filterObjectsPrefix.setActionCommand("RefreshObjects");
        this.filterObjectsDelimiter = new JComboBox<String>(new String[]{"", "/", "?", "\\"});
        this.filterObjectsDelimiter.setEditable(true);
        this.filterObjectsDelimiter.setToolTipText("Object name delimiter");
        this.filterObjectsDelimiter.addActionListener(this);
        this.filterObjectsDelimiter.setActionCommand("RefreshObjects");
        this.filterObjectsPanel.add((Component)new JHtmlLabel("Prefix:", this), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, this.insetsZero, 0, 0));
        this.filterObjectsPanel.add((Component)this.filterObjectsPrefix, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        this.filterObjectsPanel.add((Component)new JHtmlLabel("Delimiter:", this), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, this.insetsDefault, 0, 0));
        this.filterObjectsPanel.add((Component)this.filterObjectsDelimiter, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, this.insetsZero, 0, 0));
        this.filterObjectsPanel.setVisible(false);
        JPanel objectsPanel = new JPanel(new GridBagLayout());
        int row = 0;
        this.filterObjectsCheckBox = new JCheckBox("Filter objects");
        this.filterObjectsCheckBox.addActionListener(this);
        this.filterObjectsCheckBox.setToolTipText("Check this option to filter the objects listed");
        objectsPanel.add((Component)new JHtmlLabel("<html><b>Objects</b></html>", this), new GridBagConstraints(0, row, 1, 1, 1.0, 0.0, 17, 2, this.insetsZero, 0, 0));
        objectsPanel.add((Component)this.filterObjectsCheckBox, new GridBagConstraints(1, row, 1, 1, 0.0, 0.0, 13, 2, this.insetsZero, 0, 0));
        JButton objectActionButton = new JButton();
        objectActionButton.setToolTipText("Object actions menu");
        this.guiUtils.applyIcon(objectActionButton, "/images/nuvola/16x16/actions/misc.png");
        objectActionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JButton sourceButton = (JButton)e.getSource();
                Cockpit.this.objectActionMenu.show(sourceButton, 0, sourceButton.getHeight());
            }
        });
        objectsPanel.add((Component)objectActionButton, new GridBagConstraints(2, row, 1, 1, 0.0, 0.0, 13, 2, this.insetsZero, 0, 0));
        objectsPanel.add((Component)this.filterObjectsPanel, new GridBagConstraints(0, ++row, 3, 1, 0.0, 0.0, 17, 2, this.insetsZero, 0, 0));
        this.objectsTable = new JTable();
        this.objectTableModel = new ObjectTableModel();
        this.objectTableModelSorter = new TableSorter(this.objectTableModel);
        this.objectTableModelSorter.setTableHeader(this.objectsTable.getTableHeader());
        this.objectsTable.setModel(this.objectTableModelSorter);
        this.objectsTable.setDefaultRenderer(Long.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 301092191828910402L;

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                String formattedSize = Cockpit.this.byteFormatter.formatByteSize((Long)value);
                return super.getTableCellRendererComponent(table, formattedSize, isSelected, hasFocus, row, column);
            }
        });
        this.objectsTable.setDefaultRenderer(Date.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 7285511556343895652L;

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Date date = (Date)value;
                return super.getTableCellRendererComponent(table, Cockpit.this.yearAndTimeSDF.format(date), isSelected, hasFocus, row, column);
            }
        });
        this.objectsTable.setSelectionMode(2);
        this.objectsTable.getSelectionModel().addListSelectionListener(this);
        this.objectsTable.setShowHorizontalLines(true);
        this.objectsTable.setShowVerticalLines(true);
        this.objectsTable.addMouseListener(new ContextMenuListener());
        this.objectsTableSP = new JScrollPane(this.objectsTable);
        objectsPanel.add((Component)this.objectsTableSP, new GridBagConstraints(0, ++row, 3, 1, 1.0, 1.0, 10, 1, this.insetsZero, 0, 0));
        this.objectsSummaryLabel = new JHtmlLabel("Please select a bucket", this);
        this.objectsSummaryLabel.setHorizontalAlignment(0);
        this.objectsSummaryLabel.setFocusable(false);
        objectsPanel.add((Component)this.objectsSummaryLabel, new GridBagConstraints(0, ++row, 3, 1, 1.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
        JSplitPane splitPane = new JSplitPane(1, bucketsPanel, objectsPanel);
        splitPane.setOneTouchExpandable(true);
        splitPane.setContinuousLayout(true);
        appContent.add((Component)splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.insetsDefault, 0, 0));
        int preferredWidth = 800;
        int preferredHeight = 600;
        this.setBounds(new Rectangle(new Dimension(preferredWidth, preferredHeight)));
        splitPane.setResizeWeight(0.3);
        this.initDropTarget(new JComponent[]{this.objectsTableSP, this.objectsTable});
        this.objectsTable.getDropTarget().setActive(false);
        this.objectsTableSP.getDropTarget().setActive(false);
    }

    private void initMenus() {
        JMenuBar appMenuBar = new JMenuBar();
        if (this.isStandAloneApplication && OS_NAME_MAC.equals(System.getProperty("os.name"))) {
            this.ownerFrame.setJMenuBar(appMenuBar);
        } else {
            this.setJMenuBar(appMenuBar);
        }
        JMenu serviceMenu = new JMenu("Service");
        this.loginMenuItem = new JMenuItem("Log in...");
        this.loginMenuItem.setActionCommand("LoginEvent");
        this.loginMenuItem.addActionListener(this);
        this.guiUtils.applyIcon(this.loginMenuItem, "/images/nuvola/16x16/actions/connect_creating.png");
        serviceMenu.add(this.loginMenuItem);
        this.logoutMenuItem = new JMenuItem("Log out");
        this.logoutMenuItem.setActionCommand("LogoutEvent");
        this.logoutMenuItem.addActionListener(this);
        this.guiUtils.applyIcon(this.logoutMenuItem, "/images/nuvola/16x16/actions/connect_no.png");
        serviceMenu.add(this.logoutMenuItem);
        this.loginSwitchMenu = new JMenu("Switch login");
        this.loginSwitchMenu.addActionListener(this);
        serviceMenu.add(new JSeparator());
        this.guiUtils.applyIcon(this.loginSwitchMenu, "/images/nuvola/16x16/actions/connect_established.png");
        serviceMenu.add(this.loginSwitchMenu);
        this.loginSwitchMenu.setEnabled(false);
        if (this.isStandAloneApplication) {
            serviceMenu.add(new JSeparator());
            JMenuItem quitMenuItem = new JMenuItem("Quit");
            quitMenuItem.setActionCommand("QuitEvent");
            quitMenuItem.addActionListener(this);
            this.guiUtils.applyIcon(quitMenuItem, "/images/nuvola/16x16/actions/exit.png");
            serviceMenu.add(quitMenuItem);
        }
        this.logoutMenuItem.setEnabled(false);
        this.bucketActionMenu = new JPopupMenu();
        this.refreshBucketMenuItem = new JMenuItem("Refresh bucket listing");
        this.refreshBucketMenuItem.setActionCommand("RefreshBuckets");
        this.refreshBucketMenuItem.addActionListener(this);
        this.guiUtils.applyIcon(this.refreshBucketMenuItem, "/images/nuvola/16x16/actions/reload.png");
        this.bucketActionMenu.add(this.refreshBucketMenuItem);
        this.viewBucketPropertiesMenuItem = new JMenuItem("View bucket properties...");
        this.viewBucketPropertiesMenuItem.setActionCommand("ViewBucketProperties");
        this.viewBucketPropertiesMenuItem.addActionListener(this);
        this.guiUtils.applyIcon(this.viewBucketPropertiesMenuItem, "/images/nuvola/16x16/actions/viewmag.png");
        this.bucketActionMenu.add(this.viewBucketPropertiesMenuItem);
        this.updateBucketACLMenuItem = new JMenuItem("Update bucket's Access Control List...");
        this.updateBucketACLMenuItem.setActionCommand("UpdateBucketACL");
        this.updateBucketACLMenuItem.addActionListener(this);
        this.guiUtils.applyIcon(this.updateBucketACLMenuItem, "/images/nuvola/16x16/actions/encrypted.png");
        this.bucketActionMenu.add(this.updateBucketACLMenuItem);
        this.updateBucketRequesterPaysStatusMenuItem = new JMenuItem("Update bucket's Requester Pays status...");
        this.updateBucketRequesterPaysStatusMenuItem.setActionCommand("UpdateBucketRequesterPaysStatus");
        this.updateBucketRequesterPaysStatusMenuItem.addActionListener(this);
        this.guiUtils.applyIcon(this.updateBucketRequesterPaysStatusMenuItem, "/images/nuvola/16x16/actions/identity.png");
        this.bucketActionMenu.add(this.updateBucketRequesterPaysStatusMenuItem);
        this.bucketActionMenu.add(new JSeparator());
        this.createBucketMenuItem = new JMenuItem("Create new bucket...");
        this.createBucketMenuItem.setActionCommand("CreateBucket");
        this.createBucketMenuItem.addActionListener(this);
        this.guiUtils.applyIcon(this.createBucketMenuItem, "/images/nuvola/16x16/actions/viewmag+.png");
        this.bucketActionMenu.add(this.createBucketMenuItem);
        JMenuItem thirdPartyBucketMenuItem = new JMenuItem("Add third-party bucket...");
        thirdPartyBucketMenuItem.setActionCommand("AddThirdPartyBucket");
        thirdPartyBucketMenuItem.addActionListener(this);
        this.guiUtils.applyIcon(thirdPartyBucketMenuItem, "/images/nuvola/16x16/actions/viewmagfit.png");
        this.bucketActionMenu.add(thirdPartyBucketMenuItem);
        this.bucketActionMenu.add(new JSeparator());
        this.deleteBucketMenuItem = new JMenuItem("Delete bucket...");
        this.deleteBucketMenuItem.setActionCommand("DeleteBucket");
        this.deleteBucketMenuItem.addActionListener(this);
        this.guiUtils.applyIcon(this.deleteBucketMenuItem, "/images/nuvola/16x16/actions/cancel.png");
        this.bucketActionMenu.add(this.deleteBucketMenuItem);
        this.viewBucketPropertiesMenuItem.setEnabled(false);
        this.refreshBucketMenuItem.setEnabled(false);
        this.createBucketMenuItem.setEnabled(false);
        this.updateBucketACLMenuItem.setEnabled(false);
        this.updateBucketRequesterPaysStatusMenuItem.setEnabled(false);
        this.deleteBucketMenuItem.setEnabled(false);
        this.objectActionMenu = new JPopupMenu();
        this.refreshObjectMenuItem = new JMenuItem("Refresh object listing");
        this.refreshObjectMenuItem.setActionCommand("RefreshObjects");
        this.refreshObjectMenuItem.addActionListener(this);
        this.guiUtils.applyIcon(this.refreshObjectMenuItem, "/images/nuvola/16x16/actions/reload.png");
        this.objectActionMenu.add(this.refreshObjectMenuItem);
        this.viewOrModifyObjectAttributesMenuItem = new JMenuItem("View or Modify object attributes...");
        this.viewOrModifyObjectAttributesMenuItem.setActionCommand("ViewOrModifyObjectAttributes");
        this.viewOrModifyObjectAttributesMenuItem.addActionListener(this);
        this.guiUtils.applyIcon(this.viewOrModifyObjectAttributesMenuItem, "/images/nuvola/16x16/actions/viewmag.png");
        this.objectActionMenu.add(this.viewOrModifyObjectAttributesMenuItem);
        this.copyObjectsMenuItem = new JMenuItem("Copy or Move objects...");
        this.copyObjectsMenuItem.setActionCommand("CopyObjects");
        this.copyObjectsMenuItem.addActionListener(this);
        this.guiUtils.applyIcon(this.copyObjectsMenuItem, "/images/nuvola/16x16/actions/filenew.png");
        this.objectActionMenu.add(this.copyObjectsMenuItem);
        this.updateObjectACLMenuItem = new JMenuItem("View or Modify Access Control Lists...");
        this.updateObjectACLMenuItem.setActionCommand("UpdateObjectACL");
        this.updateObjectACLMenuItem.addActionListener(this);
        this.guiUtils.applyIcon(this.updateObjectACLMenuItem, "/images/nuvola/16x16/actions/encrypted.png");
        this.objectActionMenu.add(this.updateObjectACLMenuItem);
        this.downloadObjectMenuItem = new JMenuItem("Download objects...");
        this.downloadObjectMenuItem.setActionCommand("DownloadObjects");
        this.downloadObjectMenuItem.addActionListener(this);
        this.guiUtils.applyIcon(this.downloadObjectMenuItem, "/images/nuvola/16x16/actions/1downarrow.png");
        this.objectActionMenu.add(this.downloadObjectMenuItem);
        this.uploadFilesMenuItem = new JMenuItem("Upload files...");
        this.uploadFilesMenuItem.setActionCommand("UploadFiles");
        this.uploadFilesMenuItem.addActionListener(this);
        this.guiUtils.applyIcon(this.uploadFilesMenuItem, "/images/nuvola/16x16/actions/1uparrow.png");
        this.objectActionMenu.add(this.uploadFilesMenuItem);
        this.objectActionMenu.add(new JSeparator());
        this.generatePublicGetUrls = new JMenuItem("Generate Public GET URLs...");
        this.generatePublicGetUrls.setActionCommand("GeneratePublicGetURLs");
        this.generatePublicGetUrls.addActionListener(this);
        this.guiUtils.applyIcon(this.generatePublicGetUrls, "/images/nuvola/16x16/actions/wizard.png");
        this.objectActionMenu.add(this.generatePublicGetUrls);
        this.generateTorrentUrl = new JMenuItem("Generate Torrent URL...");
        this.generateTorrentUrl.setActionCommand("GenerateTorrentURL");
        this.generateTorrentUrl.addActionListener(this);
        this.guiUtils.applyIcon(this.generateTorrentUrl, "/images/nuvola/16x16/actions/wizard.png");
        this.objectActionMenu.add(this.generateTorrentUrl);
        this.objectActionMenu.add(new JSeparator());
        this.deleteObjectMenuItem = new JMenuItem("Delete objects...");
        this.deleteObjectMenuItem.setActionCommand("DeleteObjects");
        this.deleteObjectMenuItem.addActionListener(this);
        this.guiUtils.applyIcon(this.deleteObjectMenuItem, "/images/nuvola/16x16/actions/cancel.png");
        this.objectActionMenu.add(this.deleteObjectMenuItem);
        this.viewOrModifyObjectAttributesMenuItem.setEnabled(false);
        this.copyObjectsMenuItem.setEnabled(false);
        this.refreshObjectMenuItem.setEnabled(false);
        this.updateObjectACLMenuItem.setEnabled(false);
        this.downloadObjectMenuItem.setEnabled(false);
        this.uploadFilesMenuItem.setEnabled(false);
        this.generatePublicGetUrls.setEnabled(false);
        this.generateTorrentUrl.setEnabled(false);
        this.deleteObjectMenuItem.setEnabled(false);
        JMenu toolsMenu = new JMenu("Tools");
        this.bucketLoggingMenuItem = new JMenuItem("Configure Bucket logging...");
        this.bucketLoggingMenuItem.setActionCommand("BucketLogging");
        this.bucketLoggingMenuItem.addActionListener(this);
        this.bucketLoggingMenuItem.setEnabled(false);
        this.guiUtils.applyIcon(this.bucketLoggingMenuItem, "/images/nuvola/16x16/actions/toggle_log.png");
        toolsMenu.add(this.bucketLoggingMenuItem);
        this.manageDistributionsMenuItem = new JMenuItem("CloudFront Distributions...");
        this.manageDistributionsMenuItem.setActionCommand("ManageDistributions");
        this.manageDistributionsMenuItem.addActionListener(this);
        this.guiUtils.applyIcon(this.manageDistributionsMenuItem, "/images/nuvola/16x16/actions/irkick.png");
        this.manageDistributionsMenuItem.setEnabled(false);
        toolsMenu.add(this.manageDistributionsMenuItem);
        toolsMenu.add(new JSeparator());
        this.preferencesDialogMenuItem = new JMenuItem("Preferences...");
        this.preferencesDialogMenuItem.setActionCommand("PreferencesDialog");
        this.preferencesDialogMenuItem.addActionListener(this);
        this.guiUtils.applyIcon(this.preferencesDialogMenuItem, "/images/nuvola/16x16/actions/configure.png");
        toolsMenu.add(this.preferencesDialogMenuItem);
        JMenu helpMenu = new JMenu("Help");
        this.cockpitHelpMenuItem = new JMenuItem("Cockpit Guide");
        this.guiUtils.applyIcon(this.cockpitHelpMenuItem, "/images/nuvola/16x16/actions/help.png");
        this.cockpitHelpMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Cockpit.this.followHyperlink(new URL(Cockpit.JETS3T_COCKPIT_HELP_PAGE), "_blank");
                }
                catch (MalformedURLException ex) {
                    throw new IllegalStateException("Invalid URL embedded in program: http://www.jets3t.org/applications/cockpit.html");
                }
            }
        });
        helpMenu.add(this.cockpitHelpMenuItem);
        this.amazonS3HelpMenuItem = new JMenuItem("Amazon S3");
        this.guiUtils.applyIcon(this.amazonS3HelpMenuItem, "/images/nuvola/16x16/actions/gohome.png");
        this.amazonS3HelpMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Cockpit.this.followHyperlink(new URL(Cockpit.AMAZON_S3_PAGE), "_blank");
                }
                catch (MalformedURLException ex) {
                    throw new IllegalStateException("Invalid URL embedded in program: http://www.amazon.com/s3");
                }
            }
        });
        helpMenu.add(this.amazonS3HelpMenuItem);
        appMenuBar.add(serviceMenu);
        appMenuBar.add(toolsMenu);
        appMenuBar.add(helpMenu);
    }

    private void initDropTarget(JComponent[] dropTargetComponents) {
        DropTargetListener dropTargetListener = new DropTargetListener(){

            private boolean checkValidDrag(DropTargetDragEvent dtde) {
                if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor) && (1 == dtde.getDropAction() || 2 == dtde.getDropAction())) {
                    dtde.acceptDrag(dtde.getDropAction());
                    return true;
                }
                dtde.rejectDrag();
                return false;
            }

            public void dragEnter(DropTargetDragEvent dtde) {
                if (this.checkValidDrag(dtde)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Cockpit.this.objectsTable.requestFocusInWindow();
                        }
                    });
                }
            }

            public void dragOver(DropTargetDragEvent dtde) {
                this.checkValidDrag(dtde);
            }

            public void dropActionChanged(DropTargetDragEvent dtde) {
                if (this.checkValidDrag(dtde)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Cockpit.this.objectsTable.requestFocusInWindow();
                        }
                    });
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Cockpit.this.ownerFrame.requestFocusInWindow();
                        }
                    });
                }
            }

            public void dragExit(DropTargetEvent dte) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Cockpit.this.ownerFrame.requestFocusInWindow();
                    }
                });
            }

            public void drop(DropTargetDropEvent dtde) {
                if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor) && (1 == dtde.getDropAction() || 2 == dtde.getDropAction())) {
                    dtde.acceptDrop(dtde.getDropAction());
                    try {
                        List fileList = (List)dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                        if (fileList != null && fileList.size() > 0) {
                            Cockpit.this.uploadFiles(fileList.toArray(new File[fileList.size()]));
                        }
                    }
                    catch (Exception e) {
                        String message = "Unable to start accept dropped items";
                        log.error((Object)message, (Throwable)e);
                        ErrorDialog.showDialog(Cockpit.this.ownerFrame, null, message, (Throwable)e);
                    }
                } else {
                    dtde.rejectDrop();
                }
            }
        };
        for (int i = 0; i < dropTargetComponents.length; ++i) {
            new DropTarget(dropTargetComponents[i], 1, dropTargetListener, true);
        }
    }

    private synchronized void runInBackgroundThread(Runnable runnable) {
        Thread t = new Thread(runnable);
        t.start();
    }

    private synchronized boolean runInDispatcherThreadImmediately(Runnable runnable) {
        try {
            SwingUtilities.invokeAndWait(runnable);
            return true;
        }
        catch (Exception e) {
            log.error((Object)"Error displaying graphical elements", (Throwable)e);
            return false;
        }
    }

    private void startProgressDialog(String statusText) {
        this.startProgressDialog(statusText, null, 0, 0, null, null);
    }

    private void startProgressDialog(final String statusMessage, final String detailsText, final int minTaskValue, final int maxTaskValue, final String cancelButtonText, final CancelEventTrigger cancelEventListener) {
        if (this.progressDialog == null) {
            this.progressDialog = new ProgressDialog((Frame)this.ownerFrame, "Please wait...", null);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Cockpit.this.progressDialog.startDialog(statusMessage, detailsText, minTaskValue, maxTaskValue, cancelEventListener, cancelButtonText);
            }
        });
    }

    private void updateProgressDialog(final String statusMessage, final String detailsText, final int progressValue) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Cockpit.this.progressDialog.updateDialog(statusMessage, detailsText, progressValue);
            }
        });
    }

    private void stopProgressDialog() {
        this.runInDispatcherThreadImmediately(new Runnable(){

            public void run() {
                Cockpit.this.progressDialog.stopDialog();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if ("LoginEvent".equals(event.getActionCommand())) {
            this.loginEvent(null);
        } else if ("LogoutEvent".equals(event.getActionCommand())) {
            this.logoutEvent();
        } else if (event.getActionCommand() != null && event.getActionCommand().startsWith("LoginSwitch")) {
            String loginName = event.getActionCommand().substring("LoginSwitch:".length());
            ProviderCredentials credentials = this.loginAwsCredentialsMap.get(loginName);
            this.loginEvent(credentials);
        } else if ("QuitEvent".equals(event.getActionCommand())) {
            System.exit(0);
        } else if ("ViewBucketProperties".equals(event.getActionCommand())) {
            this.listBucketProperties();
        } else if ("RefreshBuckets".equals(event.getActionCommand())) {
            this.listAllBuckets();
        } else if ("CreateBucket".equals(event.getActionCommand())) {
            this.createBucketAction();
        } else if ("DeleteBucket".equals(event.getActionCommand())) {
            this.deleteSelectedBucket();
        } else if ("ManageDistributions".equals(event.getActionCommand())) {
            S3Bucket[] buckets = this.bucketTableModel.getBuckets();
            String[] bucketNames = new String[buckets.length];
            for (int i = 0; i < buckets.length; ++i) {
                bucketNames[i] = buckets[i].getName();
            }
            ManageDistributionsDialog.showDialog(this.ownerFrame, this.cloudFrontService, bucketNames, this);
        } else if ("AddThirdPartyBucket".equals(event.getActionCommand())) {
            this.addThirdPartyBucket();
        } else if ("UpdateBucketACL".equals(event.getActionCommand())) {
            this.updateBucketAccessControlList();
        } else if ("UpdateBucketRequesterPaysStatus".equals(event.getActionCommand())) {
            this.updateBucketRequesterPaysSetting();
        } else if ("ViewOrModifyObjectAttributes".equals(event.getActionCommand())) {
            this.displayObjectsAttributesDialog();
        } else if ("CopyObjects".equals(event.getActionCommand())) {
            this.copyObjects();
        } else if ("RefreshObjects".equals(event.getActionCommand())) {
            this.listObjects();
        } else if ("UpdateObjectACL".equals(event.getActionCommand())) {
            this.displayAclModificationDialog();
        } else if ("GeneratePublicGetURLs".equals(event.getActionCommand())) {
            this.generatePublicGetUrls();
        } else if ("GenerateTorrentURL".equals(event.getActionCommand())) {
            this.generateTorrentUrl();
        } else if ("DeleteObjects".equals(event.getActionCommand())) {
            this.deleteSelectedObjects();
        } else if ("DownloadObjects".equals(event.getActionCommand())) {
            this.downloadSelectedObjects();
        } else if ("UploadFiles".equals(event.getActionCommand())) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setMultiSelectionEnabled(true);
            fileChooser.setDialogTitle("Choose files to upload");
            fileChooser.setFileSelectionMode(2);
            fileChooser.setApproveButtonText("Upload files");
            fileChooser.setCurrentDirectory(this.fileChoosersLastUploadDirectory);
            int returnVal = fileChooser.showOpenDialog(this.ownerFrame);
            if (returnVal != 0) {
                return;
            }
            File[] uploadFiles = fileChooser.getSelectedFiles();
            if (uploadFiles.length == 0) {
                return;
            }
            this.fileChoosersLastUploadDirectory = uploadFiles[0].getParentFile();
            this.uploadFiles(uploadFiles);
        } else if (event.getSource().equals(this.filterObjectsCheckBox)) {
            if (this.filterObjectsCheckBox.isSelected()) {
                this.filterObjectsPanel.setVisible(true);
            } else {
                this.filterObjectsPanel.setVisible(false);
                this.filterObjectsPrefix.setText("");
                if (this.filterObjectsDelimiter.getSelectedIndex() != 0) {
                    this.filterObjectsDelimiter.setSelectedIndex(0);
                }
            }
        } else if ("BucketLogging".equals(event.getActionCommand())) {
            S3Bucket[] buckets = this.bucketTableModel.getBuckets();
            BucketLoggingDialog.showDialog((Frame)this.ownerFrame, this.s3ServiceMulti.getS3Service(), buckets, (HyperlinkActivatedListener)this);
        } else if ("PreferencesDialog".equals(event.getActionCommand())) {
            String message;
            PreferencesDialog.showDialog(this.cockpitPreferences, this.ownerFrame, this);
            File cockpitPreferencesPropertiesFile = new File(this.cockpitHomeDirectory, Constants.COCKPIT_PROPERTIES_FILENAME);
            if (this.cockpitPreferences.isRememberPreferences()) {
                try {
                    Properties properties = this.cockpitPreferences.toProperties();
                    if (!this.cockpitHomeDirectory.exists()) {
                        this.cockpitHomeDirectory.mkdir();
                    }
                    properties.list(new PrintStream(new FileOutputStream(cockpitPreferencesPropertiesFile)));
                }
                catch (IOException e) {
                    message = "Unable to save your preferences";
                    log.error((Object)message, (Throwable)e);
                    ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, message, (Throwable)e);
                }
            } else if (cockpitPreferencesPropertiesFile.exists()) {
                cockpitPreferencesPropertiesFile.delete();
            }
            if (this.cockpitPreferences.isEncryptionPasswordSet()) {
                try {
                    this.encryptionUtil = new EncryptionUtil(this.cockpitPreferences.getEncryptionPassword(), this.cockpitPreferences.getEncryptionAlgorithm(), "2");
                }
                catch (Exception e) {
                    message = "Unable to start encryption utility";
                    log.error((Object)message, (Throwable)e);
                    ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, message, (Throwable)e);
                }
            } else {
                this.encryptionUtil = null;
            }
        } else {
            log.debug((Object)("Unrecognised ActionEvent command '" + event.getActionCommand() + "' in " + event));
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (e.getSource().equals(this.bucketsTable.getSelectionModel())) {
            this.bucketSelectedAction();
        } else if (e.getSource().equals(this.objectsTable.getSelectionModel())) {
            this.objectSelectedAction();
        }
    }

    private void loginEvent(ProviderCredentials credentials) {
        try {
            String loginName;
            if (credentials == null) {
                StartupDialog startupDialog = new StartupDialog((Frame)this.ownerFrame, this.cockpitProperties, this);
                startupDialog.setVisible(true);
                credentials = startupDialog.getProviderCredentials();
                this.isTargetS3 = startupDialog.isTargetS3();
                startupDialog.dispose();
                if (credentials == null) {
                    log.debug((Object)"Log in cancelled by user");
                    return;
                }
            }
            this.s3ServiceMulti = new S3ServiceMulti(this.getRestS3Service(credentials), this);
            this.cloudFrontMembershipChecked = false;
            this.listAllBuckets();
            this.objectsSummaryLabel.setText(" ");
            this.logoutMenuItem.setEnabled(true);
            this.refreshBucketMenuItem.setEnabled(true);
            this.createBucketMenuItem.setEnabled(true);
            this.bucketLoggingMenuItem.setEnabled(true);
            String string = loginName = credentials.hasFriendlyName() ? credentials.getFriendlyName() : credentials.getAccessKey();
            if (!this.loginAwsCredentialsMap.containsKey(loginName)) {
                this.loginAwsCredentialsMap.put(loginName, credentials);
                JMenuItem menuItem = new JMenuItem(loginName);
                menuItem.setActionCommand("LoginSwitch:" + loginName);
                menuItem.addActionListener(this);
                this.loginSwitchMenu.add(menuItem);
                this.loginSwitchMenu.setEnabled(true);
            }
        }
        catch (Exception e) {
            String message = "Unable to log in to storage service";
            log.error((Object)message, (Throwable)e);
            ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, message, (Throwable)e);
            this.logoutEvent();
        }
    }

    private void logoutEvent() {
        log.debug((Object)"Logging out");
        try {
            String loginName;
            ProviderCredentials credentials = this.s3ServiceMulti.getAWSCredentials();
            String string = loginName = credentials.hasFriendlyName() ? credentials.getFriendlyName() : credentials.getAccessKey();
            if (this.loginAwsCredentialsMap.containsKey(loginName)) {
                Component[] components = this.loginSwitchMenu.getMenuComponents();
                for (int i = 0; i < components.length; ++i) {
                    JMenuItem menuItem = (JMenuItem)components[i];
                    if (!loginName.equals(menuItem.getText())) continue;
                    this.loginSwitchMenu.remove(components[i]);
                    break;
                }
                this.loginAwsCredentialsMap.remove(loginName);
                this.loginSwitchMenu.setEnabled(this.loginAwsCredentialsMap.size() > 0);
            }
            this.s3ServiceMulti = new S3ServiceMulti(this.getRestS3Service(null), this);
            this.cloudFrontService = null;
            this.bucketsTable.clearSelection();
            this.bucketTableModel.removeAllBuckets();
            this.objectTableModel.removeAllObjects();
            this.objectsSummaryLabel.setText(" ");
            this.ownerFrame.setTitle(APPLICATION_TITLE);
            this.logoutMenuItem.setEnabled(false);
            this.refreshBucketMenuItem.setEnabled(false);
            this.createBucketMenuItem.setEnabled(false);
            this.bucketLoggingMenuItem.setEnabled(false);
            this.manageDistributionsMenuItem.setEnabled(false);
        }
        catch (Exception e) {
            String message = "Unable to log out from S3";
            log.error((Object)message, (Throwable)e);
            ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, message, (Throwable)e);
        }
    }

    private void listBucketProperties() {
        final S3Bucket selectedBucket = this.currentSelectedBucket;
        if (selectedBucket.getAcl() == null || !selectedBucket.isLocationKnown()) {
            this.runInBackgroundThread(new Runnable(){

                public void run() {
                    Cockpit.this.startProgressDialog("Retrieving details for bucket " + selectedBucket.getName());
                    try {
                        try {
                            if (selectedBucket.getAcl() == null) {
                                selectedBucket.setAcl(Cockpit.this.s3ServiceMulti.getS3Service().getBucketAcl(selectedBucket));
                            }
                            if (!selectedBucket.isLocationKnown()) {
                                selectedBucket.setLocation(Cockpit.this.s3ServiceMulti.getS3Service().getBucketLocation(selectedBucket.getName()));
                            }
                            if (!selectedBucket.isRequesterPaysKnown()) {
                                selectedBucket.setRequesterPays(Cockpit.this.s3ServiceMulti.getS3Service().isRequesterPaysBucket(selectedBucket.getName()));
                            }
                        }
                        catch (S3ServiceException e) {
                            // empty catch block
                        }
                        Cockpit.this.stopProgressDialog();
                        Cockpit.this.runInDispatcherThreadImmediately(new Runnable(){

                            public void run() {
                                ItemPropertiesDialog.showDialog(Cockpit.this.ownerFrame, selectedBucket, null);
                            }
                        });
                    }
                    catch (Exception e) {
                        Cockpit.this.stopProgressDialog();
                        String message = "Unable to retrieve details for bucket";
                        log.error((Object)message, (Throwable)e);
                        ErrorDialog.showDialog(Cockpit.this.ownerFrame, null, message, (Throwable)e);
                    }
                }
            });
        } else {
            ItemPropertiesDialog.showDialog(this.ownerFrame, selectedBucket, null);
        }
    }

    private void displayObjectsAttributesDialog() {
        final S3Bucket selectedBucket = this.currentSelectedBucket;
        this.runInBackgroundThread(new Runnable(){

            public void run() {
                S3Object[] sourceObjects;
                boolean ok;
                if (!Cockpit.this.retrieveObjectsDetails(Cockpit.this.getSelectedObjects())) {
                    return;
                }
                if (Cockpit.this.objectsAttributesDialog == null) {
                    Cockpit.this.objectsAttributesDialog = new ObjectsAttributesDialog((Frame)Cockpit.this.ownerFrame, "Object Attributes", Cockpit.this.skinsFactory);
                }
                if (!(ok = Cockpit.this.runInDispatcherThreadImmediately(new Runnable(sourceObjects = Cockpit.this.getSelectedObjects()){
                    final /* synthetic */ S3Object[] val$sourceObjects;
                    {
                        this.val$sourceObjects = s3ObjectArray;
                    }

                    public void run() {
                        Cockpit.this.objectsAttributesDialog.displayDialog(this.val$sourceObjects, true);
                    }
                }))) {
                    return;
                }
                String[] sourceObjectKeys = Cockpit.this.objectsAttributesDialog.getSourceObjectKeys();
                S3Object[] destinationObjects = Cockpit.this.objectsAttributesDialog.getDestinationObjects();
                if (!Cockpit.this.objectsAttributesDialog.isModifyActionApproved()) {
                    return;
                }
                if (!Cockpit.this.s3ServiceMulti.getObjectACLs(selectedBucket, sourceObjects)) {
                    return;
                }
                for (int i = 0; i < sourceObjects.length; ++i) {
                    destinationObjects[i].setAcl(sourceObjects[i].getAcl());
                }
                ok = Cockpit.this.s3ServiceMulti.copyObjects(selectedBucket.getName(), selectedBucket.getName(), sourceObjectKeys, destinationObjects, true);
                if (ok) {
                    Cockpit.this.s3ServiceMulti.getObjectsHeads(selectedBucket, destinationObjects);
                }
            }
        });
    }

    private void listAllBuckets() {
        this.cachedBuckets.clear();
        this.bucketsTable.clearSelection();
        this.bucketTableModel.removeAllBuckets();
        this.objectTableModel.removeAllObjects();
        final Cockpit myself = this;
        this.runInBackgroundThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                block15: {
                    if (!Cockpit.this.cloudFrontMembershipChecked) {
                        Cockpit.this.startProgressDialog("Checking for CloudFront account membership");
                        try {
                            Object var3_1;
                            try {
                                Cockpit.this.cloudFrontService = new CloudFrontService(Cockpit.this.s3ServiceMulti.getAWSCredentials(), Cockpit.APPLICATION_DESCRIPTION, myself, null);
                                Cockpit.this.cloudFrontService.listDistributions();
                            }
                            catch (CloudFrontServiceException e) {
                                Cockpit.this.stopProgressDialog();
                                if ("OptInRequired".equals(e.getErrorCode())) {
                                    log.debug((Object)"Your AWS account is not subscribed to the Amazon CloudFront service, you will not be able to manage distributions");
                                }
                                Cockpit.this.cloudFrontService = null;
                                var3_1 = null;
                                Cockpit.this.stopProgressDialog();
                                Cockpit.this.cloudFrontMembershipChecked = true;
                                Cockpit.this.bucketTableModel = new BucketTableModel(Cockpit.this.cloudFrontService != null);
                                Cockpit.this.bucketTableModelSorter = new TableSorter(Cockpit.this.bucketTableModel);
                                Cockpit.this.bucketsTable.setModel(Cockpit.this.bucketTableModelSorter);
                                Cockpit.this.bucketTableModelSorter.setTableHeader(Cockpit.this.bucketsTable.getTableHeader());
                                if (Cockpit.this.cloudFrontService != null) {
                                    TableColumn distributionFlagColumn = Cockpit.this.bucketsTable.getColumnModel().getColumn(1);
                                    int distributionFlagColumnWidth = 18;
                                    distributionFlagColumn.setPreferredWidth(distributionFlagColumnWidth);
                                    distributionFlagColumn.setMaxWidth(distributionFlagColumnWidth);
                                    distributionFlagColumn.setMinWidth(0);
                                }
                                Cockpit.this.manageDistributionsMenuItem.setEnabled(Cockpit.this.cloudFrontService != null);
                                break block15;
                            }
                            var3_1 = null;
                        }
                        catch (Throwable throwable) {
                            Object var3_2 = null;
                            Cockpit.this.stopProgressDialog();
                            Cockpit.this.cloudFrontMembershipChecked = true;
                            Cockpit.this.bucketTableModel = new BucketTableModel(Cockpit.this.cloudFrontService != null);
                            Cockpit.this.bucketTableModelSorter = new TableSorter(Cockpit.this.bucketTableModel);
                            Cockpit.this.bucketsTable.setModel(Cockpit.this.bucketTableModelSorter);
                            Cockpit.this.bucketTableModelSorter.setTableHeader(Cockpit.this.bucketsTable.getTableHeader());
                            if (Cockpit.this.cloudFrontService != null) {
                                TableColumn distributionFlagColumn = Cockpit.this.bucketsTable.getColumnModel().getColumn(1);
                                int distributionFlagColumnWidth = 18;
                                distributionFlagColumn.setPreferredWidth(distributionFlagColumnWidth);
                                distributionFlagColumn.setMaxWidth(distributionFlagColumnWidth);
                                distributionFlagColumn.setMinWidth(0);
                            }
                            Cockpit.this.manageDistributionsMenuItem.setEnabled(Cockpit.this.cloudFrontService != null);
                            throw throwable;
                        }
                        Cockpit.this.stopProgressDialog();
                        Cockpit.this.cloudFrontMembershipChecked = true;
                        Cockpit.this.bucketTableModel = new BucketTableModel(Cockpit.this.cloudFrontService != null);
                        Cockpit.this.bucketTableModelSorter = new TableSorter(Cockpit.this.bucketTableModel);
                        Cockpit.this.bucketsTable.setModel(Cockpit.this.bucketTableModelSorter);
                        Cockpit.this.bucketTableModelSorter.setTableHeader(Cockpit.this.bucketsTable.getTableHeader());
                        if (Cockpit.this.cloudFrontService != null) {
                            TableColumn distributionFlagColumn = Cockpit.this.bucketsTable.getColumnModel().getColumn(1);
                            int distributionFlagColumnWidth = 18;
                            distributionFlagColumn.setPreferredWidth(distributionFlagColumnWidth);
                            distributionFlagColumn.setMaxWidth(distributionFlagColumnWidth);
                            distributionFlagColumn.setMinWidth(0);
                        }
                        Cockpit.this.manageDistributionsMenuItem.setEnabled(Cockpit.this.cloudFrontService != null);
                    }
                }
                Cockpit.this.startProgressDialog("Listing buckets for " + Cockpit.this.s3ServiceMulti.getAWSCredentials().getAccessKey());
                try {
                    try {
                        final S3Bucket[] buckets = Cockpit.this.s3ServiceMulti.getS3Service().listAllBuckets();
                        Distribution[] distributions = new Distribution[]{};
                        if (Cockpit.this.cloudFrontService != null) {
                            Cockpit.this.updateProgressDialog("Listing distributions for " + Cockpit.this.cloudFrontService.getAWSCredentials().getAccessKey(), "", 0);
                            distributions = Cockpit.this.cloudFrontService.listDistributions();
                        }
                        final Distribution[] finalDistributions = distributions;
                        Cockpit.this.runInDispatcherThreadImmediately(new Runnable(){

                            public void run() {
                                for (int i = 0; i < buckets.length; ++i) {
                                    boolean bucketHasDistribution = false;
                                    for (int j = 0; j < finalDistributions.length; ++j) {
                                        if (!finalDistributions[j].getOrigin().equals(buckets[i].getName() + ".s3.amazonaws.com")) continue;
                                        bucketHasDistribution = true;
                                    }
                                    Cockpit.this.bucketTableModel.addBucket(buckets[i], bucketHasDistribution);
                                    if (i != 0) continue;
                                    Cockpit.this.ownerFrame.setTitle("JetS3t Cockpit : " + buckets[i].getOwner().getDisplayName());
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        Cockpit.this.stopProgressDialog();
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                Cockpit.this.logoutEvent();
                                String message = "Unable to list your buckets in S3, please log in again";
                                log.error((Object)message, (Throwable)e);
                                ErrorDialog.showDialog(Cockpit.this.ownerFrame, null, message, (Throwable)e);
                                Cockpit.this.loginEvent(null);
                            }
                        });
                        Object var7_15 = null;
                        Cockpit.this.stopProgressDialog();
                        return;
                    }
                    Object var7_14 = null;
                }
                catch (Throwable throwable) {
                    Object var7_16 = null;
                    Cockpit.this.stopProgressDialog();
                    throw throwable;
                }
                Cockpit.this.stopProgressDialog();
            }
        });
    }

    @Override
    public void s3ServiceEventPerformed(GetObjectsEvent event) {
    }

    @Override
    public void s3ServiceEventPerformed(ListObjectsEvent event) {
    }

    @Override
    public void s3ServiceEventPerformed(DeleteVersionedObjectsEvent event) {
    }

    private void bucketSelectedAction() {
        this.currentSelectedBucket = null;
        if (this.bucketsTable.getSelectedRows().length != 0) {
            this.currentSelectedBucket = this.bucketTableModel.getBucket(this.bucketTableModelSorter.modelIndex(this.bucketsTable.getSelectedRows()[0]));
        }
        if (this.currentSelectedBucket == null) {
            this.viewBucketPropertiesMenuItem.setEnabled(false);
            this.refreshBucketMenuItem.setEnabled(true);
            this.updateBucketACLMenuItem.setEnabled(false);
            this.updateBucketRequesterPaysStatusMenuItem.setEnabled(false);
            this.deleteBucketMenuItem.setEnabled(false);
            this.refreshObjectMenuItem.setEnabled(false);
            this.uploadFilesMenuItem.setEnabled(false);
            this.objectTableModel.removeAllObjects();
            this.objectsTable.getDropTarget().setActive(false);
            this.objectsTableSP.getDropTarget().setActive(false);
        } else {
            this.viewBucketPropertiesMenuItem.setEnabled(true);
            this.refreshBucketMenuItem.setEnabled(true);
            this.updateBucketACLMenuItem.setEnabled(true);
            this.updateBucketRequesterPaysStatusMenuItem.setEnabled(true);
            this.deleteBucketMenuItem.setEnabled(true);
            this.refreshObjectMenuItem.setEnabled(true);
            this.uploadFilesMenuItem.setEnabled(true);
            this.objectsTable.getDropTarget().setActive(true);
            this.objectsTableSP.getDropTarget().setActive(true);
            if (this.cachedBuckets.containsKey(this.currentSelectedBucket.getName())) {
                S3Object[] objects = (S3Object[])this.cachedBuckets.get(this.currentSelectedBucket.getName());
                this.objectTableModel.removeAllObjects();
                this.objectTableModel.addObjects(objects);
                this.updateObjectsSummary(false);
            } else {
                this.listObjects();
            }
        }
    }

    private void objectSelectedAction() {
        int count = this.getSelectedObjects().length;
        this.updateObjectACLMenuItem.setEnabled(count > 0);
        this.downloadObjectMenuItem.setEnabled(count > 0);
        this.deleteObjectMenuItem.setEnabled(count > 0);
        this.viewOrModifyObjectAttributesMenuItem.setEnabled(count > 0);
        this.copyObjectsMenuItem.setEnabled(count > 0);
        this.generatePublicGetUrls.setEnabled(count >= 1 && this.s3ServiceMulti.getAWSCredentials() != null);
        this.generateTorrentUrl.setEnabled(count == 1);
    }

    private void listObjects() {
        if (this.currentSelectedBucket == null) {
            return;
        }
        final boolean[] listingCancelled = new boolean[1];
        final CancelEventTrigger cancelListener = new CancelEventTrigger(){
            private static final long serialVersionUID = 6939193243303189876L;

            public void cancelTask(Object eventSource) {
                listingCancelled[0] = true;
            }
        };
        this.objectTableModel.removeAllObjects();
        this.objectsSummaryLabel.setText(" ");
        this.runInBackgroundThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    try {
                        Cockpit.this.startProgressDialog("Listing objects in " + Cockpit.this.currentSelectedBucket.getName(), "", 0, 0, "Cancel bucket listing", cancelListener);
                        String prefix = Cockpit.this.filterObjectsPrefix.getText();
                        String delimiter = (String)Cockpit.this.filterObjectsDelimiter.getSelectedItem();
                        ArrayList<S3Object> allObjects = new ArrayList<S3Object>();
                        String priorLastKey = null;
                        do {
                            StorageObjectsChunk chunk = Cockpit.this.s3ServiceMulti.getS3Service().listObjectsChunked(Cockpit.this.currentSelectedBucket.getName(), prefix, delimiter, 1000L, priorLastKey);
                            final S3Object[] objects = S3Object.cast(chunk.getObjects());
                            for (int i = 0; i < objects.length; ++i) {
                                objects[i].setOwner(Cockpit.this.currentSelectedBucket.getOwner());
                            }
                            priorLastKey = chunk.getPriorLastKey();
                            allObjects.addAll(Arrays.asList(objects));
                            Cockpit.this.updateProgressDialog("Listed " + allObjects.size() + " objects in " + Cockpit.this.currentSelectedBucket.getName(), "", 0);
                            Cockpit.this.runInDispatcherThreadImmediately(new Runnable(){

                                public void run() {
                                    Cockpit.this.objectTableModel.addObjects(objects);
                                    Cockpit.this.updateObjectsSummary(true);
                                }
                            });
                        } while (!listingCancelled[0] && priorLastKey != null);
                        Cockpit.this.runInDispatcherThreadImmediately(new Runnable(){

                            public void run() {
                                Cockpit.this.updateObjectsSummary(listingCancelled[0]);
                                S3Object[] allObjects = Cockpit.this.objectTableModel.getObjects();
                                Cockpit.this.cachedBuckets.put(Cockpit.this.currentSelectedBucket.getName(), allObjects);
                            }
                        });
                    }
                    catch (Exception e) {
                        Cockpit.this.stopProgressDialog();
                        String message = "Unable to list objects";
                        log.error((Object)message, (Throwable)e);
                        ErrorDialog.showDialog(Cockpit.this.ownerFrame, null, message, (Throwable)e);
                        Object var9_11 = null;
                        Cockpit.this.stopProgressDialog();
                        return;
                    }
                    Object var9_10 = null;
                }
                catch (Throwable throwable) {
                    Object var9_12 = null;
                    Cockpit.this.stopProgressDialog();
                    throw throwable;
                }
                Cockpit.this.stopProgressDialog();
            }
        });
    }

    private void updateObjectsSummary(boolean isIncompleteListing) {
        S3Object[] objects = this.objectTableModel.getObjects();
        try {
            String summary = "Please select a bucket";
            long totalBytes = 0L;
            if (objects != null) {
                summary = "<html>" + objects.length + " item" + (objects.length != 1 ? "s" : "");
                for (int i = 0; i < objects.length; ++i) {
                    totalBytes += objects[i].getContentLength();
                }
                if (totalBytes > 0L) {
                    summary = summary + ", " + this.byteFormatter.formatByteSize(totalBytes);
                }
                summary = summary + " @ " + this.timeSDF.format(new Date());
                if (this.isObjectFilteringActive()) {
                    summary = summary + " - <font color=\"blue\">Filtered</font>";
                }
                if (isIncompleteListing) {
                    summary = summary + " - <font color=\"red\">Incomplete</font>";
                }
                summary = summary + "</html>";
            }
            this.objectsSummaryLabel.setText(summary);
        }
        catch (Throwable t) {
            String message = "Unable to update object list summary";
            log.error((Object)message, t);
            ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, message, t);
        }
    }

    private void showBucketPopupMenu(JComponent invoker, int xPos, int yPos) {
        if (this.s3ServiceMulti == null) {
            return;
        }
        this.bucketActionMenu.show(invoker, xPos, yPos);
    }

    private void showObjectPopupMenu(JComponent invoker, int xPos, int yPos) {
        if (this.currentSelectedBucket == null || this.getSelectedObjects().length == 0) {
            return;
        }
        this.objectActionMenu.show(invoker, xPos, yPos);
    }

    private void createBucketAction() {
        String proposedNewName = this.s3ServiceMulti.getAWSCredentials().getAccessKey().toLowerCase() + "." + "bucket-name";
        CreateBucketDialog dialog = new CreateBucketDialog(proposedNewName, this.ownerFrame, this);
        dialog.setVisible(true);
        if (!dialog.getOkClicked()) {
            return;
        }
        final S3Bucket newBucket = new S3Bucket(dialog.getBucketName(), dialog.getBucketLocation());
        dialog.dispose();
        this.runInBackgroundThread(new Runnable(){

            public void run() {
                if (Cockpit.this.s3ServiceMulti.createBuckets(new S3Bucket[]{newBucket})) {
                    int modelIndex = Cockpit.this.bucketTableModel.getBucketIndexByName(newBucket.getName());
                    int viewIndex = Cockpit.this.bucketTableModelSorter.viewIndex(modelIndex);
                    Cockpit.this.bucketsTable.setRowSelectionInterval(viewIndex, viewIndex);
                }
            }
        });
    }

    @Override
    public void s3ServiceEventPerformed(final CreateBucketsEvent event) {
        if (1 == event.getEventCode()) {
            this.startProgressDialog("Creating " + event.getThreadWatcher().getThreadCount() + " buckets", "", 0, (int)event.getThreadWatcher().getThreadCount(), "Cancel bucket creation", event.getThreadWatcher().getCancelEventListener());
        } else if (3 == event.getEventCode()) {
            this.runInDispatcherThreadImmediately(new Runnable(){

                public void run() {
                    for (int i = 0; i < event.getCreatedBuckets().length; ++i) {
                        Cockpit.this.bucketTableModel.addBucket(event.getCreatedBuckets()[i], false);
                    }
                }
            });
            ThreadWatcher progressStatus = event.getThreadWatcher();
            String statusText = "Created " + progressStatus.getCompletedThreads() + " buckets of " + progressStatus.getThreadCount();
            this.updateProgressDialog(statusText, "", (int)progressStatus.getCompletedThreads());
        } else if (2 == event.getEventCode()) {
            this.stopProgressDialog();
        } else if (4 == event.getEventCode()) {
            this.stopProgressDialog();
        } else if (0 == event.getEventCode()) {
            this.stopProgressDialog();
            String message = "Unable to create a bucket";
            log.error((Object)message, event.getErrorCause());
            ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, message, event.getErrorCause());
        }
    }

    private void deleteSelectedBucket() {
        if (this.currentSelectedBucket == null) {
            log.warn((Object)"Ignoring delete bucket command, no currently selected bucket");
            return;
        }
        int response = JOptionPane.showConfirmDialog(this.ownerFrame, "Are you sure you want to delete '" + this.currentSelectedBucket.getName() + "'?", "Delete Bucket?", 0);
        if (response == 1) {
            return;
        }
        try {
            this.s3ServiceMulti.getS3Service().deleteBucket(this.currentSelectedBucket.getName());
            this.bucketTableModel.removeBucket(this.currentSelectedBucket);
            this.currentSelectedBucket = null;
        }
        catch (Exception e) {
            String message = "Unable to delete bucket";
            log.error((Object)message, (Throwable)e);
            ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, message, (Throwable)e);
        }
    }

    private void addThirdPartyBucket() {
        try {
            String bucketName = JOptionPane.showInputDialog(this.ownerFrame, "Name for third-party bucket:", "Add a third-party bucket", 3);
            if (bucketName != null) {
                if (this.s3ServiceMulti.getS3Service().isBucketAccessible(bucketName)) {
                    S3Bucket thirdPartyBucket = new S3Bucket(bucketName);
                    this.bucketTableModel.addBucket(thirdPartyBucket, false);
                } else {
                    String message = "Unable to access third-party bucket: " + bucketName;
                    log.error((Object)message);
                    ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, message, null);
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            String message = "Unable to access third-party bucket";
            log.error((Object)message, (Throwable)e);
            ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, message, (Throwable)e);
        }
    }

    private void updateBucketAccessControlList() {
        try {
            AccessControlList bucketACL = this.s3ServiceMulti.getS3Service().getBucketAcl(this.currentSelectedBucket);
            AccessControlList updatedBucketACL = AccessControlDialog.showDialog(this.ownerFrame, new S3Bucket[]{this.currentSelectedBucket}, bucketACL, this);
            if (updatedBucketACL != null) {
                this.currentSelectedBucket.setAcl(updatedBucketACL);
                this.s3ServiceMulti.getS3Service().putBucketAcl(this.currentSelectedBucket);
            }
        }
        catch (Exception e) {
            String message = "Unable to update bucket's Access Control List";
            log.error((Object)message, (Throwable)e);
            ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, message, (Throwable)e);
        }
    }

    private void updateBucketRequesterPaysSetting() {
        try {
            final S3Bucket selectedBucket = this.currentSelectedBucket;
            if (!selectedBucket.isRequesterPaysKnown()) {
                selectedBucket.setRequesterPays(this.s3ServiceMulti.getS3Service().isRequesterPaysBucket(selectedBucket.getName()));
            }
            boolean originalRequesterPaysFlag = selectedBucket.isRequesterPays();
            RequesterPaysDialog dialog = new RequesterPaysDialog(selectedBucket, this.ownerFrame, this);
            dialog.setVisible(true);
            if (!dialog.getOkClicked()) {
                return;
            }
            final boolean newRequesterPaysFlag = dialog.isRequesterPaysSelected();
            dialog.dispose();
            if (newRequesterPaysFlag != originalRequesterPaysFlag) {
                this.runInBackgroundThread(new Runnable(){

                    public void run() {
                        try {
                            Cockpit.this.s3ServiceMulti.getS3Service().setRequesterPaysBucket(selectedBucket.getName(), newRequesterPaysFlag);
                            selectedBucket.setRequesterPays(newRequesterPaysFlag);
                        }
                        catch (Exception e) {
                            String message = "Unable to update Requester Pays status";
                            log.error((Object)message, (Throwable)e);
                            ErrorDialog.showDialog(Cockpit.this.ownerFrame, null, message, (Throwable)e);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            String message = "Unable to update bucket's Access Control List";
            log.error((Object)message, (Throwable)e);
            ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, message, (Throwable)e);
        }
    }

    private S3Object[] getSelectedObjects() {
        int[] viewRows = this.objectsTable.getSelectedRows();
        if (viewRows.length == 0) {
            return new S3Object[0];
        }
        S3Object[] objects = new S3Object[viewRows.length];
        for (int i = 0; i < viewRows.length; ++i) {
            int modelRow = this.objectTableModelSorter.modelIndex(viewRows[i]);
            objects[i] = this.objectTableModel.getObject(modelRow);
        }
        return objects;
    }

    private void displayAclModificationDialog() {
        final Cockpit hyperlinkListener = this;
        final S3Bucket selectedBucket = this.currentSelectedBucket;
        this.runInBackgroundThread(new Runnable(){

            public void run() {
                final S3Object[] selectedObjects = Cockpit.this.getSelectedObjects();
                boolean aclLookupSucceeded = Cockpit.this.s3ServiceMulti.getObjectACLs(selectedBucket, selectedObjects);
                if (!aclLookupSucceeded) {
                    return;
                }
                final AccessControlList[] updatedObjectACL = new AccessControlList[]{null};
                Cockpit.this.runInDispatcherThreadImmediately(new Runnable(){

                    public void run() {
                        AccessControlList mergedACL = new AccessControlList();
                        for (int i = 0; i < selectedObjects.length; ++i) {
                            AccessControlList objectACL = selectedObjects[i].getAcl();
                            mergedACL.grantAllPermissions(objectACL.getGrantAndPermissions());
                            if (mergedACL.getOwner() != null) continue;
                            mergedACL.setOwner(objectACL.getOwner());
                        }
                        updatedObjectACL[0] = AccessControlDialog.showDialog(Cockpit.this.ownerFrame, selectedObjects, mergedACL, hyperlinkListener);
                    }
                });
                if (updatedObjectACL[0] != null) {
                    for (int i = 0; i < selectedObjects.length; ++i) {
                        selectedObjects[i].setAcl(updatedObjectACL[0]);
                    }
                    Cockpit.this.s3ServiceMulti.putACLs(selectedBucket, selectedObjects);
                }
            }
        });
    }

    @Override
    public void s3ServiceEventPerformed(LookupACLEvent event) {
        if (1 == event.getEventCode()) {
            this.startProgressDialog("Retrieved 0 of " + event.getThreadWatcher().getThreadCount() + " ACLs", "", 0, (int)event.getThreadWatcher().getThreadCount(), "Cancel Lookup", event.getThreadWatcher().getCancelEventListener());
        } else if (3 == event.getEventCode()) {
            ThreadWatcher progressStatus = event.getThreadWatcher();
            String statusText = "Retrieved " + progressStatus.getCompletedThreads() + " of " + progressStatus.getThreadCount() + " ACLs";
            this.updateProgressDialog(statusText, "", (int)progressStatus.getCompletedThreads());
        } else if (2 == event.getEventCode()) {
            this.stopProgressDialog();
        } else if (4 == event.getEventCode()) {
            this.stopProgressDialog();
        } else if (0 == event.getEventCode()) {
            this.stopProgressDialog();
            String message = "Unable to lookup Access Control list for objects";
            log.error((Object)message, event.getErrorCause());
            ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, message, event.getErrorCause());
        }
    }

    @Override
    public void s3ServiceEventPerformed(UpdateACLEvent event) {
        if (1 == event.getEventCode()) {
            this.startProgressDialog("Updated 0 of " + event.getThreadWatcher().getThreadCount() + " ACLs", "", 0, (int)event.getThreadWatcher().getThreadCount(), "Cancel Update", event.getThreadWatcher().getCancelEventListener());
        } else if (3 == event.getEventCode()) {
            ThreadWatcher progressStatus = event.getThreadWatcher();
            String statusText = "Updated " + progressStatus.getCompletedThreads() + " of " + progressStatus.getThreadCount() + " ACLs";
            this.updateProgressDialog(statusText, "", (int)progressStatus.getCompletedThreads());
        } else if (2 == event.getEventCode()) {
            this.stopProgressDialog();
        } else if (4 == event.getEventCode()) {
            this.stopProgressDialog();
        } else if (0 == event.getEventCode()) {
            this.stopProgressDialog();
            String message = "Unable to update Access Control Lists";
            log.error((Object)message, event.getErrorCause());
            ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, message, event.getErrorCause());
        }
    }

    private void downloadSelectedObjects() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Choose directory to save S3 files in");
        fileChooser.setFileSelectionMode(1);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setSelectedFile(this.downloadDirectory);
        int returnVal = fileChooser.showDialog(this.ownerFrame, "Choose Directory");
        if (returnVal != 0) {
            return;
        }
        this.downloadDirectory = fileChooser.getSelectedFile();
        boolean storeEmptyDirectories = Jets3tProperties.getInstance(Constants.JETS3T_PROPERTIES_FILENAME).getBoolProperty("uploads.storeEmptyDirectories", true);
        final Map<String, String> objectKeyToFilepathMap = FileComparer.getInstance().buildObjectKeyToFilepathMap(this.downloadDirectory.listFiles(), "", storeEmptyDirectories);
        final Map<String, StorageObject> s3DownloadObjectsMap = FileComparer.getInstance().populateObjectMap("", this.getSelectedObjects());
        final Cockpit hyperlinkListener = this;
        this.runInBackgroundThread(new Runnable(){

            public void run() {
                if (!Cockpit.this.retrieveObjectsDetails(Cockpit.this.getSelectedObjects())) {
                    return;
                }
                try {
                    FileComparerResults comparisonResults = Cockpit.this.compareRemoteAndLocalFiles(objectKeyToFilepathMap, s3DownloadObjectsMap);
                    DownloadPackage[] downloadPackages = Cockpit.this.buildDownloadPackageList(comparisonResults, s3DownloadObjectsMap);
                    if (downloadPackages == null) {
                        return;
                    }
                    Cockpit.this.s3ServiceMulti.downloadObjects(Cockpit.this.currentSelectedBucket, downloadPackages);
                }
                catch (Exception e) {
                    Cockpit.this.runInDispatcherThreadImmediately(new Runnable(){

                        public void run() {
                            String message = "Unable to download objects";
                            log.error((Object)message, (Throwable)e);
                            ErrorDialog.showDialog(Cockpit.this.ownerFrame, hyperlinkListener, message, (Throwable)e);
                        }
                    });
                }
            }
        });
    }

    private void uploadFiles(File[] uploadFiles) {
        if (this.cockpitPreferences.isUploadEncryptionActive() && !this.cockpitPreferences.isEncryptionPasswordSet()) {
            ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, "Upload encryption is enabled but you have not yet set a password in the Encryption Preferences.", null);
            return;
        }
        try {
            boolean storeEmptyDirectories = Jets3tProperties.getInstance(Constants.JETS3T_PROPERTIES_FILENAME).getBoolProperty("uploads.storeEmptyDirectories", true);
            Map<String, String> objectKeyToFilepathMap = FileComparer.getInstance().buildObjectKeyToFilepathMap(uploadFiles, "", storeEmptyDirectories);
            ArrayList<S3Object> objectsWithExistingKeys = new ArrayList<S3Object>();
            StorageObject[] existingObjects = this.objectTableModel.getObjects();
            for (int i = 0; i < existingObjects.length; ++i) {
                if (!objectKeyToFilepathMap.containsKey(existingObjects[i].getKey())) continue;
                objectsWithExistingKeys.add(existingObjects[i]);
            }
            existingObjects = objectsWithExistingKeys.toArray(new S3Object[objectsWithExistingKeys.size()]);
            Map<String, StorageObject> s3ExistingObjectsMap = FileComparer.getInstance().populateObjectMap("", existingObjects);
            Cockpit hyperlinkListener = this;
            StorageObject[] clashingObjects = existingObjects;
            this.runInBackgroundThread(new Runnable((S3Object[])clashingObjects, objectKeyToFilepathMap, s3ExistingObjectsMap, hyperlinkListener){
                final /* synthetic */ S3Object[] val$clashingObjects;
                final /* synthetic */ Map val$objectKeyToFilepathMap;
                final /* synthetic */ Map val$s3ExistingObjectsMap;
                final /* synthetic */ HyperlinkActivatedListener val$hyperlinkListener;
                {
                    this.val$clashingObjects = s3ObjectArray;
                    this.val$objectKeyToFilepathMap = map;
                    this.val$s3ExistingObjectsMap = map2;
                    this.val$hyperlinkListener = hyperlinkActivatedListener;
                }

                public void run() {
                    if (this.val$clashingObjects.length > 0 && !Cockpit.this.retrieveObjectsDetails(this.val$clashingObjects)) {
                        return;
                    }
                    try {
                        FileComparerResults comparisonResults = Cockpit.this.compareRemoteAndLocalFiles(this.val$objectKeyToFilepathMap, this.val$s3ExistingObjectsMap);
                        S3Object[] uploadObjects = Cockpit.this.buildUploadObjectsList(comparisonResults, this.val$objectKeyToFilepathMap);
                        if (uploadObjects == null) {
                            return;
                        }
                        Cockpit.this.s3ServiceMulti.putObjects(Cockpit.this.currentSelectedBucket, uploadObjects);
                    }
                    catch (Exception e) {
                        Cockpit.this.runInDispatcherThreadImmediately(new Runnable(){

                            public void run() {
                                String message = "Unable to upload objects";
                                log.error((Object)message, (Throwable)e);
                                ErrorDialog.showDialog(Cockpit.this.ownerFrame, val$hyperlinkListener, message, (Throwable)e);
                            }
                        });
                    }
                }
            });
        }
        catch (Exception e) {
            String message = "Unable to upload objects";
            log.error((Object)message, (Throwable)e);
            ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, message, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileComparerResults compareRemoteAndLocalFiles(Map<String, String> objectKeyToFilepathMap, Map s3ObjectsMap) throws Exception {
        try {
            final String statusText = "Comparing " + s3ObjectsMap.size() + " object" + (s3ObjectsMap.size() > 1 ? "s" : "") + " in S3 with " + objectKeyToFilepathMap.size() + " local file" + (objectKeyToFilepathMap.size() > 1 ? "s" : "");
            this.startProgressDialog(statusText, "", 0, 100, null, null);
            long[] filesSizeTotal = new long[1];
            for (String filepath : objectKeyToFilepathMap.values()) {
                filesSizeTotal[0] = filesSizeTotal[0] + new File(filepath).length();
            }
            BytesProgressWatcher progressWatcher = new BytesProgressWatcher(filesSizeTotal[0]){

                public void updateBytesTransferred(long byteCount) {
                    super.updateBytesTransferred(byteCount);
                    String detailsText = Cockpit.this.formatBytesProgressWatcherDetails(this, true);
                    int progressValue = (int)((double)this.getBytesTransferred() * 100.0 / (double)this.getBytesToTransfer());
                    Cockpit.this.updateProgressDialog(statusText, detailsText, progressValue);
                }
            };
            FileComparerResults comparisonResults = FileComparer.getInstance().buildDiscrepancyLists(objectKeyToFilepathMap, s3ObjectsMap, progressWatcher);
            this.stopProgressDialog();
            FileComparerResults fileComparerResults = comparisonResults;
            Object var9_8 = null;
            this.stopProgressDialog();
            return fileComparerResults;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.stopProgressDialog();
            throw throwable;
        }
    }

    private DownloadPackage[] buildDownloadPackageList(FileComparerResults comparisonResults, Map s3DownloadObjectsMap) throws Exception {
        ArrayList<String> objectKeysForDownload = new ArrayList<String>();
        objectKeysForDownload.addAll(comparisonResults.onlyOnServerKeys);
        int newFiles = comparisonResults.onlyOnServerKeys.size();
        int unchangedFiles = comparisonResults.alreadySynchronisedKeys.size();
        int changedFiles = comparisonResults.updatedOnClientKeys.size() + comparisonResults.updatedOnServerKeys.size();
        if (unchangedFiles > 0 || changedFiles > 0) {
            Object response;
            log.debug((Object)"Files for download clash with existing local files, prompting user to choose which files to replace");
            ArrayList<String> options = new ArrayList<String>();
            String message = "Of the " + (newFiles + unchangedFiles + changedFiles) + " objects being downloaded:\n\n";
            if (newFiles > 0) {
                message = message + newFiles + " files are new.\n\n";
                options.add(DOWNLOAD_NEW_FILES_ONLY);
            }
            if (changedFiles > 0) {
                message = message + changedFiles + " files have changed.\n\n";
                options.add(DOWNLOAD_NEW_AND_CHANGED_FILES);
            }
            if (unchangedFiles > 0) {
                message = message + unchangedFiles + " files already exist and are unchanged.\n\n";
                options.add(DOWNLOAD_ALL_FILES);
            }
            if ((response = JOptionPane.showInputDialog(this.ownerFrame, message = message + "Please choose which files you wish to download:", "Replace files?", 3, null, options.toArray(), DOWNLOAD_NEW_AND_CHANGED_FILES)) == null) {
                return null;
            }
            if (!DOWNLOAD_NEW_FILES_ONLY.equals(response)) {
                if (DOWNLOAD_ALL_FILES.equals(response)) {
                    objectKeysForDownload.addAll(comparisonResults.updatedOnClientKeys);
                    objectKeysForDownload.addAll(comparisonResults.updatedOnServerKeys);
                    objectKeysForDownload.addAll(comparisonResults.alreadySynchronisedKeys);
                } else if (DOWNLOAD_NEW_AND_CHANGED_FILES.equals(response)) {
                    objectKeysForDownload.addAll(comparisonResults.updatedOnClientKeys);
                    objectKeysForDownload.addAll(comparisonResults.updatedOnServerKeys);
                } else {
                    return null;
                }
            }
        }
        log.debug((Object)("Downloading " + objectKeysForDownload.size() + " objects"));
        if (objectKeysForDownload.size() == 0) {
            return null;
        }
        S3Object[] objects = new S3Object[objectKeysForDownload.size()];
        int objectIndex = 0;
        Iterator iter = objectKeysForDownload.iterator();
        while (iter.hasNext()) {
            objects[objectIndex++] = (S3Object)s3DownloadObjectsMap.get(iter.next());
        }
        HashMap<String, File> downloadObjectsToFileMap = new HashMap<String, File>();
        ArrayList<DownloadPackage> downloadPackageList = new ArrayList<DownloadPackage>();
        for (int i = 0; i < objects.length; ++i) {
            DownloadPackage downloadPackage;
            File file = new File(this.downloadDirectory, objects[i].getKey());
            String encryptionPassword = null;
            if (this.cockpitPreferences.isEncryptionPasswordSet()) {
                encryptionPassword = this.cockpitPreferences.getEncryptionPassword();
            }
            if (objects[i].isDirectoryPlaceholder()) {
                file = new File(this.downloadDirectory, ObjectUtils.convertDirPlaceholderKeyNameToDirName(objects[i].getKey()));
                file.mkdirs();
            }
            if ((downloadPackage = ObjectUtils.createPackageForDownload(objects[i], file, true, true, encryptionPassword)) == null) continue;
            downloadObjectsToFileMap.put(objects[i].getKey(), file);
            downloadPackageList.add(downloadPackage);
        }
        return downloadPackageList.toArray(new DownloadPackage[downloadPackageList.size()]);
    }

    @Override
    public void s3ServiceEventPerformed(DownloadObjectsEvent event) {
        if (1 == event.getEventCode()) {
            ThreadWatcher watcher = event.getThreadWatcher();
            if (watcher.isBytesTransferredInfoAvailable()) {
                this.startProgressDialog("Downloaded " + watcher.getCompletedThreads() + "/" + watcher.getThreadCount() + " - " + this.byteFormatter.formatByteSize(watcher.getBytesTransferred()) + " of " + this.byteFormatter.formatByteSize(watcher.getBytesTotal()), "", 0, 100, "Cancel Download", watcher.getCancelEventListener());
            } else {
                this.startProgressDialog("Downloaded " + watcher.getCompletedThreads() + " of " + watcher.getThreadCount() + " objects", "", 0, (int)watcher.getThreadCount(), "Cancel Download", watcher.getCancelEventListener());
            }
        } else if (3 == event.getEventCode()) {
            ThreadWatcher watcher = event.getThreadWatcher();
            if (watcher.isBytesTransferredInfoAvailable()) {
                String bytesCompletedStr = this.byteFormatter.formatByteSize(watcher.getBytesTransferred());
                String bytesTotalStr = this.byteFormatter.formatByteSize(watcher.getBytesTotal());
                String statusText = "Downloaded " + watcher.getCompletedThreads() + "/" + watcher.getThreadCount() + " - " + bytesCompletedStr + " of " + bytesTotalStr;
                String detailsText = this.formatTransferDetails(watcher);
                int percentage = (int)((double)watcher.getBytesTransferred() / (double)watcher.getBytesTotal() * 100.0);
                this.updateProgressDialog(statusText, detailsText, percentage);
            } else {
                ThreadWatcher progressStatus = event.getThreadWatcher();
                String statusText = "Downloaded " + progressStatus.getCompletedThreads() + " of " + progressStatus.getThreadCount() + " objects";
                this.updateProgressDialog(statusText, "", (int)progressStatus.getCompletedThreads());
            }
        } else if (2 == event.getEventCode()) {
            this.stopProgressDialog();
        } else if (4 == event.getEventCode()) {
            this.stopProgressDialog();
        } else if (0 == event.getEventCode()) {
            this.stopProgressDialog();
            String message = "Unable to download objects";
            log.error((Object)message, event.getErrorCause());
            ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, message, event.getErrorCause());
        }
    }

    private S3Object[] buildUploadObjectsList(FileComparerResults comparisonResults, Map<String, String> objectKeyToFilepathMap) throws Exception {
        ArrayList<String> fileKeysForUpload = new ArrayList<String>();
        fileKeysForUpload.addAll(comparisonResults.onlyOnClientKeys);
        int newFiles = comparisonResults.onlyOnClientKeys.size();
        int unchangedFiles = comparisonResults.alreadySynchronisedKeys.size();
        int changedFiles = comparisonResults.updatedOnClientKeys.size() + comparisonResults.updatedOnServerKeys.size();
        if (unchangedFiles > 0 || changedFiles > 0) {
            Object response;
            log.debug((Object)"Files for upload clash with existing S3 objects, prompting user to choose which files to replace");
            ArrayList<String> options = new ArrayList<String>();
            String message = "Of the " + objectKeyToFilepathMap.size() + " files being uploaded:\n\n";
            if (newFiles > 0) {
                message = message + newFiles + " files are new.\n\n";
                options.add(UPLOAD_NEW_FILES_ONLY);
            }
            if (changedFiles > 0) {
                message = message + changedFiles + " files have changed.\n\n";
                options.add(UPLOAD_NEW_AND_CHANGED_FILES);
            }
            if (unchangedFiles > 0) {
                message = message + unchangedFiles + " files already exist and are unchanged.\n\n";
                options.add(UPLOAD_ALL_FILES);
            }
            if ((response = JOptionPane.showInputDialog(this.ownerFrame, message = message + "Please choose which files you wish to upload:", "Replace files?", 3, null, options.toArray(), UPLOAD_NEW_AND_CHANGED_FILES)) == null) {
                return null;
            }
            if (!UPLOAD_NEW_FILES_ONLY.equals(response)) {
                if (UPLOAD_ALL_FILES.equals(response)) {
                    fileKeysForUpload.addAll(comparisonResults.updatedOnClientKeys);
                    fileKeysForUpload.addAll(comparisonResults.updatedOnServerKeys);
                    fileKeysForUpload.addAll(comparisonResults.alreadySynchronisedKeys);
                } else if (UPLOAD_NEW_AND_CHANGED_FILES.equals(response)) {
                    fileKeysForUpload.addAll(comparisonResults.updatedOnClientKeys);
                    fileKeysForUpload.addAll(comparisonResults.updatedOnServerKeys);
                } else {
                    this.stopProgressDialog();
                    return null;
                }
            }
        }
        if (fileKeysForUpload.size() == 0) {
            return null;
        }
        final String[] statusText = new String[]{"Prepared 0 of " + fileKeysForUpload.size() + " files for upload"};
        this.startProgressDialog(statusText[0], "", 0, 100, null, null);
        long bytesToProcess = 0L;
        Iterator iter = fileKeysForUpload.iterator();
        while (iter.hasNext()) {
            File file = new File(objectKeyToFilepathMap.get(iter.next().toString()));
            bytesToProcess += file.length() * (long)(this.cockpitPreferences.isUploadEncryptionActive() || this.cockpitPreferences.isUploadCompressionActive() ? 3 : 1);
        }
        BytesProgressWatcher progressWatcher = new BytesProgressWatcher(bytesToProcess){

            public void updateBytesTransferred(long byteCount) {
                super.updateBytesTransferred(byteCount);
                String detailsText = Cockpit.this.formatBytesProgressWatcherDetails(this, false);
                int progressValue = (int)((double)this.getBytesTransferred() * 100.0 / (double)this.getBytesToTransfer());
                Cockpit.this.updateProgressDialog(statusText[0], detailsText, progressValue);
            }
        };
        S3Object[] objects = new S3Object[fileKeysForUpload.size()];
        int objectIndex = 0;
        Iterator iter2 = fileKeysForUpload.iterator();
        while (iter2.hasNext()) {
            String fileKey = iter2.next().toString();
            File file = new File(objectKeyToFilepathMap.get(fileKey));
            S3Object newObject = ObjectUtils.createObjectForUpload(fileKey, file, this.cockpitPreferences.isUploadEncryptionActive() ? this.encryptionUtil : null, this.cockpitPreferences.isUploadCompressionActive(), progressWatcher);
            String aclPreferenceString = this.cockpitPreferences.getUploadACLPermission();
            if (!"PRIVATE".equals(aclPreferenceString)) {
                if ("PUBLIC_READ".equals(aclPreferenceString)) {
                    newObject.setAcl(AccessControlList.REST_CANNED_PUBLIC_READ);
                } else if ("PUBLIC_READ_WRITE".equals(aclPreferenceString)) {
                    newObject.setAcl(AccessControlList.REST_CANNED_PUBLIC_READ_WRITE);
                } else {
                    log.warn((Object)("Ignoring unrecognised upload ACL permission setting: " + aclPreferenceString));
                }
            }
            newObject.setStorageClass(this.cockpitPreferences.getUploadStorageClass());
            statusText[0] = "Prepared " + (objectIndex + 1) + " of " + fileKeysForUpload.size() + " files for upload";
            objects[objectIndex++] = newObject;
        }
        this.stopProgressDialog();
        return objects;
    }

    @Override
    public void s3ServiceEventPerformed(final CreateObjectsEvent event) {
        if (1 == event.getEventCode()) {
            ThreadWatcher watcher = event.getThreadWatcher();
            if (watcher.isBytesTransferredInfoAvailable()) {
                String bytesTotalStr = this.byteFormatter.formatByteSize(watcher.getBytesTotal());
                String statusText = "Uploaded " + watcher.getCompletedThreads() + "/" + watcher.getThreadCount() + " - " + "0 of " + bytesTotalStr;
                this.startProgressDialog(statusText, " ", 0, 100, "Cancel Upload", event.getThreadWatcher().getCancelEventListener());
            } else {
                this.startProgressDialog("Uploaded 0 of " + watcher.getThreadCount() + " objects", "", (int)watcher.getCompletedThreads(), (int)watcher.getThreadCount(), "Cancel upload", event.getThreadWatcher().getCancelEventListener());
            }
        } else if (3 == event.getEventCode()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    for (int i = 0; i < event.getCreatedObjects().length; ++i) {
                        S3Object object = event.getCreatedObjects()[i];
                        object.setBucketName(Cockpit.this.currentSelectedBucket.getName());
                        Cockpit.this.objectTableModel.addObject(object);
                    }
                    if (event.getCreatedObjects().length > 0) {
                        Cockpit.this.updateObjectsSummary(true);
                    }
                }
            });
            ThreadWatcher watcher = event.getThreadWatcher();
            if (watcher.isBytesTransferredInfoAvailable()) {
                if (watcher.getBytesTransferred() >= watcher.getBytesTotal()) {
                    String statusText = "Upload completed, awaiting confirmation";
                    this.updateProgressDialog(statusText, "", 100);
                } else {
                    String bytesCompletedStr = this.byteFormatter.formatByteSize(watcher.getBytesTransferred());
                    String bytesTotalStr = this.byteFormatter.formatByteSize(watcher.getBytesTotal());
                    String statusText = "Uploaded " + watcher.getCompletedThreads() + "/" + watcher.getThreadCount() + " - " + bytesCompletedStr + " of " + bytesTotalStr;
                    int percentage = (int)((double)watcher.getBytesTransferred() / (double)watcher.getBytesTotal() * 100.0);
                    String detailsText = this.formatTransferDetails(watcher);
                    this.updateProgressDialog(statusText, detailsText, percentage);
                }
            } else {
                ThreadWatcher progressStatus = event.getThreadWatcher();
                String statusText = "Uploaded " + progressStatus.getCompletedThreads() + " of " + progressStatus.getThreadCount() + " objects";
                this.updateProgressDialog(statusText, "", (int)progressStatus.getCompletedThreads());
            }
        } else if (2 == event.getEventCode()) {
            this.stopProgressDialog();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Cockpit.this.updateObjectsSummary(false);
                    S3Object[] allObjects = Cockpit.this.objectTableModel.getObjects();
                    Cockpit.this.cachedBuckets.put(Cockpit.this.currentSelectedBucket.getName(), allObjects);
                }
            });
        } else if (4 == event.getEventCode()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Cockpit.this.updateObjectsSummary(false);
                }
            });
            this.stopProgressDialog();
        } else if (0 == event.getEventCode()) {
            this.stopProgressDialog();
            String message = "Unable to upload objects";
            log.error((Object)message, event.getErrorCause());
            ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, message, event.getErrorCause());
        }
    }

    private void copyObjects() {
        try {
            final S3Object[] sourceObjects = this.getSelectedObjects();
            CopyObjectsDialog dialog = new CopyObjectsDialog(this.ownerFrame, "Copy or Move Objects", this.skinsFactory, sourceObjects, this.bucketTableModel.getBuckets());
            dialog.setVisible(true);
            if (dialog.isCopyActionApproved()) {
                final String currentBucketName = this.currentSelectedBucket.getName();
                final String destinationBucketName = dialog.getDestinationBucketName();
                final String[] sourceObjectKeys = dialog.getSourceObjectKeys();
                final S3Object[] destinationObjects = dialog.getDestinationObjects();
                final boolean isDeleteAfterCopy = dialog.isMoveOptionSelected();
                final boolean retainAcls = dialog.isCopyOriginalAccessControlLists();
                dialog.dispose();
                if (!destinationBucketName.equals(currentBucketName)) {
                    this.cachedBuckets.remove(destinationBucketName);
                }
                this.runInBackgroundThread(new Runnable(){

                    public void run() {
                        if (retainAcls) {
                            if (!Cockpit.this.s3ServiceMulti.getObjectACLs(Cockpit.this.currentSelectedBucket, sourceObjects)) {
                                return;
                            }
                            for (int i = 0; i < sourceObjects.length; ++i) {
                                destinationObjects[i].setAcl(sourceObjects[i].getAcl());
                            }
                        }
                        Cockpit.this.s3ServiceMulti.copyObjects(currentBucketName, destinationBucketName, sourceObjectKeys, destinationObjects, false);
                        if (isDeleteAfterCopy) {
                            S3Object[] sourceObjects2 = new S3Object[sourceObjectKeys.length];
                            for (int i = 0; i < sourceObjectKeys.length; ++i) {
                                sourceObjects2[i] = new S3Object(sourceObjectKeys[i]);
                            }
                            Cockpit.this.s3ServiceMulti.deleteObjects(Cockpit.this.currentSelectedBucket, sourceObjects2);
                        }
                        if (destinationBucketName.equals(currentBucketName) || isDeleteAfterCopy) {
                            Cockpit.this.listObjects();
                        }
                    }
                });
            } else {
                dialog.dispose();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.stopProgressDialog();
            String message = "Unable to modify objects";
            log.error((Object)message, (Throwable)e);
            ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, message, (Throwable)e);
        }
    }

    @Override
    public void s3ServiceEventPerformed(CopyObjectsEvent event) {
        if (1 == event.getEventCode()) {
            ThreadWatcher watcher = event.getThreadWatcher();
            this.startProgressDialog("Copied 0 of " + watcher.getThreadCount() + " objects", "", 0, (int)watcher.getThreadCount(), "Cancel Copy", event.getThreadWatcher().getCancelEventListener());
        } else if (3 == event.getEventCode()) {
            ThreadWatcher watcher = event.getThreadWatcher();
            String statusText = "Copied " + watcher.getCompletedThreads() + " of " + watcher.getThreadCount() + " objects";
            this.updateProgressDialog(statusText, "", (int)watcher.getCompletedThreads());
        } else if (2 == event.getEventCode() || 4 == event.getEventCode()) {
            this.stopProgressDialog();
        } else if (0 == event.getEventCode()) {
            this.stopProgressDialog();
            String message = "Unable to copy objects";
            log.error((Object)message, event.getErrorCause());
            ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, message, event.getErrorCause());
        }
    }

    private void generatePublicGetUrls() {
        S3Object[] objects = this.getSelectedObjects();
        if (objects.length < 1) {
            log.warn((Object)"Ignoring Generate Public URLs object command because no objects are selected");
            return;
        }
        SignedGetUrlDialog dialog = new SignedGetUrlDialog((Frame)this.ownerFrame, this, this.s3ServiceMulti.getS3Service(), objects);
        dialog.setVisible(true);
    }

    private void generateTorrentUrl() {
        S3Object[] objects = this.getSelectedObjects();
        if (objects.length != 1) {
            log.warn((Object)"Ignoring Generate Public URL object command, can only operate on a single object");
            return;
        }
        S3Object currentObject = objects[0];
        String torrentUrl = this.s3ServiceMulti.getS3Service().createTorrentUrl(this.currentSelectedBucket.getName(), currentObject.getKey());
        JOptionPane.showInputDialog(this.ownerFrame, "Torrent URL for '" + currentObject.getKey() + "'.", "Torrent URL", 1, null, null, torrentUrl);
    }

    private void deleteSelectedObjects() {
        final S3Object[] objects = this.getSelectedObjects();
        if (objects.length == 0) {
            log.warn((Object)"Ignoring delete objects command, no currently selected objects");
            return;
        }
        int response = JOptionPane.showConfirmDialog(this.ownerFrame, objects.length == 1 ? "Are you sure you want to delete '" + objects[0].getKey() + "'?" : "Are you sure you want to delete " + objects.length + " objects", "Delete Objects?", 0);
        if (response == 1) {
            return;
        }
        this.runInBackgroundThread(new Runnable(){

            public void run() {
                Cockpit.this.s3ServiceMulti.deleteObjects(Cockpit.this.currentSelectedBucket, objects);
                Cockpit.this.runInDispatcherThreadImmediately(new Runnable(){

                    public void run() {
                        Cockpit.this.updateObjectsSummary(false);
                        S3Object[] allObjects = Cockpit.this.objectTableModel.getObjects();
                        Cockpit.this.cachedBuckets.put(Cockpit.this.currentSelectedBucket.getName(), allObjects);
                    }
                });
            }
        });
    }

    @Override
    public void s3ServiceEventPerformed(final DeleteObjectsEvent event) {
        if (1 == event.getEventCode()) {
            this.startProgressDialog("Deleted 0 of " + event.getThreadWatcher().getThreadCount() + " objects", "", 0, (int)event.getThreadWatcher().getThreadCount(), "Cancel Delete Objects", event.getThreadWatcher().getCancelEventListener());
        } else if (3 == event.getEventCode()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    for (int i = 0; i < event.getDeletedObjects().length; ++i) {
                        Cockpit.this.objectTableModel.removeObject(event.getDeletedObjects()[i]);
                    }
                    if (event.getDeletedObjects().length > 0) {
                        Cockpit.this.updateObjectsSummary(true);
                    }
                }
            });
            ThreadWatcher progressStatus = event.getThreadWatcher();
            String statusText = "Deleted " + progressStatus.getCompletedThreads() + " of " + progressStatus.getThreadCount() + " objects";
            this.updateProgressDialog(statusText, "", (int)progressStatus.getCompletedThreads());
        } else if (2 == event.getEventCode()) {
            this.stopProgressDialog();
        } else if (4 == event.getEventCode()) {
            this.stopProgressDialog();
        } else if (0 == event.getEventCode()) {
            this.stopProgressDialog();
            String message = "Unable to delete objects";
            log.error((Object)message, event.getErrorCause());
            ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, message, event.getErrorCause());
        }
    }

    private boolean retrieveObjectsDetails(S3Object[] candidateObjects) {
        ArrayList<S3Object> s3ObjectsIncompleteList = new ArrayList<S3Object>();
        for (int i = 0; i < candidateObjects.length; ++i) {
            if (candidateObjects[i].isMetadataComplete()) continue;
            s3ObjectsIncompleteList.add(candidateObjects[i]);
        }
        log.debug((Object)("Of " + candidateObjects.length + " object candidates for HEAD requests " + s3ObjectsIncompleteList.size() + " are incomplete, performing requests for these only"));
        S3Object[] incompleteObjects = s3ObjectsIncompleteList.toArray(new S3Object[s3ObjectsIncompleteList.size()]);
        return this.s3ServiceMulti.getObjectsHeads(this.currentSelectedBucket, incompleteObjects);
    }

    @Override
    public void s3ServiceEventPerformed(final GetObjectHeadsEvent event) {
        if (1 == event.getEventCode()) {
            if (event.getThreadWatcher().getThreadCount() > 0L) {
                this.startProgressDialog("Retrieved details for 0 of " + event.getThreadWatcher().getThreadCount() + " objects", "", 0, (int)event.getThreadWatcher().getThreadCount(), "Cancel Retrieval", event.getThreadWatcher().getCancelEventListener());
            }
        } else if (3 == event.getEventCode()) {
            ThreadWatcher progressStatus = event.getThreadWatcher();
            this.runInDispatcherThreadImmediately(new Runnable(){

                public void run() {
                    for (int i = 0; i < event.getCompletedObjects().length; ++i) {
                        S3Object objectWithDetails = event.getCompletedObjects()[i];
                        S3Object originalObject = Cockpit.this.objectTableModel.getObjectByKey(objectWithDetails.getKey());
                        originalObject.replaceAllMetadata(objectWithDetails.getMetadataMap());
                        originalObject.setMetadataComplete(true);
                        log.debug((Object)("Updated table with " + originalObject.getKey() + ", content-type=" + originalObject.getContentType()));
                    }
                }
            });
            String statusText = "Retrieved details for " + progressStatus.getCompletedThreads() + " of " + progressStatus.getThreadCount() + " objects";
            this.updateProgressDialog(statusText, "", (int)progressStatus.getCompletedThreads());
        } else if (2 == event.getEventCode()) {
            this.stopProgressDialog();
        } else if (4 == event.getEventCode()) {
            this.stopProgressDialog();
        } else if (0 == event.getEventCode()) {
            this.stopProgressDialog();
            String message = "Unable to retrieve objects details";
            log.error((Object)message, event.getErrorCause());
            ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, message, event.getErrorCause());
        }
    }

    private String formatTransferDetails(ThreadWatcher watcher) {
        long bytesPerSecond = watcher.getBytesPerSecond();
        String detailsText = this.byteFormatter.formatByteSize(bytesPerSecond) + "/s";
        if (watcher.isTimeRemainingAvailable()) {
            long secondsRemaining = watcher.getTimeRemaining();
            detailsText = detailsText + " - Time remaining: " + this.timeFormatter.formatTime(secondsRemaining);
        }
        return detailsText;
    }

    private String formatBytesProgressWatcherDetails(BytesProgressWatcher watcher, boolean includeBytes) {
        long secondsRemaining = watcher.getRemainingTime();
        String detailsText = (includeBytes ? this.byteFormatter.formatByteSize(watcher.getBytesTransferred()) + " of " + this.byteFormatter.formatByteSize(watcher.getBytesToTransfer()) + " - " : "") + "Time remaining: " + this.timeFormatter.formatTime(secondsRemaining);
        return detailsText;
    }

    @Override
    public void followHyperlink(URL url, String target) {
        if (!this.isStandAloneApplication) {
            if (target == null) {
                this.getAppletContext().showDocument(url);
            } else {
                this.getAppletContext().showDocument(url, target);
            }
        } else {
            BareBonesBrowserLaunch.openURL(url.toString());
        }
    }

    public void setCredentials(AuthScope authscope, Credentials credentials) {
        this.mCredentialProvider.setCredentials(authscope, credentials);
    }

    public void clear() {
        this.mCredentialProvider.clear();
    }

    public Credentials getCredentials(AuthScope scope) {
        if (scope == null || scope.getScheme() == null) {
            return null;
        }
        Credentials credentials = this.mCredentialProvider.getCredentials(scope);
        if (credentials != null) {
            return credentials;
        }
        try {
            if (scope.getScheme().equals("ntlm")) {
                AuthenticationDialog pwDialog = new AuthenticationDialog((Frame)this.ownerFrame, "Authentication Required", "<html>Host <b>" + scope.getHost() + ":" + scope.getPort() + "</b> requires Windows authentication</html>", true);
                pwDialog.setVisible(true);
                if (pwDialog.getUser().length() > 0) {
                    credentials = new NTCredentials(pwDialog.getUser(), pwDialog.getPassword(), scope.getHost(), pwDialog.getDomain());
                }
                pwDialog.dispose();
            } else if (scope.getScheme().equals("basic") || scope.getScheme().equals("digest")) {
                AuthenticationDialog pwDialog = new AuthenticationDialog((Frame)this.ownerFrame, "Authentication Required", "<html><center>Host <b>" + scope.getHost() + ":" + scope.getPort() + "</b>" + " requires authentication for the realm:<br><b>" + scope.getRealm() + "</b></center></html>", false);
                pwDialog.setVisible(true);
                if (pwDialog.getUser().length() > 0) {
                    credentials = new UsernamePasswordCredentials(pwDialog.getUser(), pwDialog.getPassword());
                }
                pwDialog.dispose();
            } else {
                throw new IllegalArgumentException("Unsupported authentication scheme: " + scope.getScheme());
            }
            if (credentials != null) {
                this.mCredentialProvider.setCredentials(scope, credentials);
            }
            return credentials;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private boolean isObjectFilteringActive() {
        if (!this.filterObjectsCheckBox.isSelected()) {
            return false;
        }
        String delimiter = (String)this.filterObjectsDelimiter.getSelectedItem();
        return this.filterObjectsPrefix.getText().length() > 0 || delimiter.length() > 0;
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        JFrame ownerFrame = new JFrame(APPLICATION_TITLE);
        ownerFrame.addWindowListener(new WindowListener(){

            public void windowOpened(WindowEvent e) {
            }

            public void windowClosing(WindowEvent e) {
                e.getWindow().dispose();
            }

            public void windowClosed(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowActivated(WindowEvent e) {
            }

            public void windowDeactivated(WindowEvent e) {
            }
        });
        new Cockpit(ownerFrame);
    }

    private class ContextMenuListener
    extends MouseAdapter {
        private ContextMenuListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.showContextMenu(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.showContextMenu(e);
        }

        private void showContextMenu(MouseEvent e) {
            if (e.isPopupTrigger()) {
                JTable jTable;
                int rowIndex;
                if (e.getSource() instanceof JList) {
                    JList jList = (JList)e.getSource();
                    int locIndex = jList.locationToIndex(e.getPoint());
                    if (locIndex >= 0) {
                        jList.setSelectedIndex(locIndex);
                    }
                } else if (e.getSource() instanceof JTable && (rowIndex = (jTable = (JTable)e.getSource()).rowAtPoint(e.getPoint())) >= 0) {
                    jTable.addRowSelectionInterval(rowIndex, rowIndex);
                }
                if (e.getSource().equals(Cockpit.this.bucketsTable)) {
                    Cockpit.this.showBucketPopupMenu((JComponent)e.getSource(), e.getX(), e.getY());
                } else if (e.getSource().equals(Cockpit.this.objectsTable)) {
                    Cockpit.this.showObjectPopupMenu((JComponent)e.getSource(), e.getX(), e.getY());
                }
            }
        }
    }
}

