/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.samples;

import java.io.FileInputStream;
import java.util.List;
import org.jets3t.samples.SamplesUtils;
import org.jets3t.service.CloudFrontService;
import org.jets3t.service.model.cloudfront.CustomOrigin;
import org.jets3t.service.model.cloudfront.Distribution;
import org.jets3t.service.model.cloudfront.DistributionConfig;
import org.jets3t.service.model.cloudfront.Invalidation;
import org.jets3t.service.model.cloudfront.InvalidationSummary;
import org.jets3t.service.model.cloudfront.LoggingStatus;
import org.jets3t.service.model.cloudfront.OriginAccessIdentity;
import org.jets3t.service.model.cloudfront.OriginAccessIdentityConfig;
import org.jets3t.service.model.cloudfront.S3Origin;
import org.jets3t.service.model.cloudfront.StreamingDistribution;
import org.jets3t.service.model.cloudfront.StreamingDistributionConfig;
import org.jets3t.service.security.EncryptionUtil;
import org.jets3t.service.utils.ServiceUtils;

public class CloudFrontSamples {
    public static void main(String[] args) throws Exception {
        int i;
        CloudFrontService cloudFrontService = new CloudFrontService(SamplesUtils.loadAWSCredentials());
        Distribution[] bucketDistributions = cloudFrontService.listDistributions();
        for (i = 0; i < bucketDistributions.length; ++i) {
            System.out.println("Distribution " + (i + 1) + ": " + bucketDistributions[i]);
        }
        bucketDistributions = cloudFrontService.listDistributions("jets3t");
        for (i = 0; i < bucketDistributions.length; ++i) {
            System.out.println("Bucket distribution " + (i + 1) + ": " + bucketDistributions[i]);
        }
        String originBucket = "jets3t.s3.amazonaws.com";
        Distribution newDistribution = cloudFrontService.createDistribution(new S3Origin(originBucket), "" + System.currentTimeMillis(), new String[]{"test1.jamesmurty.com"}, "Testing", true, null);
        System.out.println("New Distribution: " + newDistribution);
        String testDistributionId = newDistribution.getId();
        Distribution distribution = cloudFrontService.getDistributionInfo(testDistributionId);
        System.out.println("Distribution: " + distribution);
        DistributionConfig distributionConfig = cloudFrontService.getDistributionConfig(testDistributionId);
        System.out.println("Distribution Config: " + distributionConfig);
        DistributionConfig updatedDistributionConfig = cloudFrontService.updateDistributionConfig(testDistributionId, null, new String[]{"test1.jamesmurty.com", "test2.jamesmurty.com"}, "Another comment for testing", true, new LoggingStatus("log-bucket.s3.amazonaws.com", "log-prefix/"));
        System.out.println("Updated Distribution Config: " + updatedDistributionConfig);
        updatedDistributionConfig = cloudFrontService.updateDistributionConfig(testDistributionId, null, new String[]{"test1.jamesmurty.com", "test2.jamesmurty.com"}, "HTTPS Only!", true, new LoggingStatus("log-bucket.s3.amazonaws.com", "log-prefix/"), false, null, new String[]{"https"}, "index.html");
        System.out.println("HTTPS only distribution Config: " + updatedDistributionConfig);
        updatedDistributionConfig.setMinTTL(5L);
        updatedDistributionConfig = cloudFrontService.updateDistributionConfig(testDistributionId, updatedDistributionConfig);
        System.out.println("Distribution Config with custom MinTTL: " + updatedDistributionConfig);
        DistributionConfig disabledDistributionConfig = cloudFrontService.updateDistributionConfig(testDistributionId, null, new String[0], "Deleting distribution", false, null);
        System.out.println("Disabled Distribution Config: " + disabledDistributionConfig);
        distribution = cloudFrontService.getDistributionInfo(testDistributionId);
        System.out.println("Distribution is deployed? " + distribution.isDeployed());
        cloudFrontService.disableDistributionForDeletion(testDistributionId);
        cloudFrontService.deleteDistribution(testDistributionId);
        OriginAccessIdentity originAccessIdentity = cloudFrontService.createOriginAccessIdentity(null, "Testing");
        System.out.println(originAccessIdentity.toString());
        List<OriginAccessIdentity> originAccessIdentityList = cloudFrontService.getOriginAccessIdentityList();
        System.out.println(originAccessIdentityList);
        OriginAccessIdentity identity = originAccessIdentityList.get(1);
        String originAccessIdentityId = identity.getId();
        System.out.println("originAccessIdentityId: " + originAccessIdentityId);
        originAccessIdentity = cloudFrontService.getOriginAccessIdentity(originAccessIdentityId);
        System.out.println(originAccessIdentity);
        OriginAccessIdentityConfig originAccessIdentityConfig = cloudFrontService.getOriginAccessIdentityConfig(originAccessIdentityId);
        System.out.println(originAccessIdentityConfig);
        OriginAccessIdentityConfig updatedConfig = cloudFrontService.updateOriginAccessIdentityConfig(originAccessIdentityId, "New Comment");
        System.out.println(updatedConfig);
        cloudFrontService.deleteOriginAccessIdentity(originAccessIdentityId);
        originBucket = "jets3t.s3.amazonaws.com";
        Distribution privateDistribution = cloudFrontService.createDistribution(new S3Origin(originBucket, originAccessIdentityId), "" + System.currentTimeMillis(), new String[0], "New private distribution -- URL signing not required", true, null, false, null, null, null);
        System.out.println("New Private Distribution: " + privateDistribution);
        updatedDistributionConfig = cloudFrontService.updateDistributionConfig(testDistributionId, new S3Origin(originBucket, originAccessIdentityId), new String[0], "Now a private distribution -- URL Signing required", true, null, true, null, null, "index.html");
        System.out.println("Made distribution private: " + updatedDistributionConfig);
        distribution = cloudFrontService.getDistributionInfo(testDistributionId);
        System.out.println("Active trusted signers: " + distribution.getActiveTrustedSigners());
        List selfKeypairIds = (List)distribution.getActiveTrustedSigners().get("Self");
        String keyPairId = (String)selfKeypairIds.get(0);
        System.out.println("Keypair ID: " + keyPairId);
        String distributionDomain = "a1b2c3d4e5f6g7.cloudfront.net";
        String privateKeyFilePath = "/path/to/rsa-private-key.pem";
        String s3ObjectKey = "s3/object/key.txt";
        String policyResourcePath = "http://" + distributionDomain + "/" + s3ObjectKey;
        byte[] derPrivateKey = EncryptionUtil.convertRsaPemToDer(new FileInputStream(privateKeyFilePath));
        String signedUrlCanned = CloudFrontService.signUrlCanned("http://" + distributionDomain + "/" + s3ObjectKey, keyPairId, derPrivateKey, ServiceUtils.parseIso8601Date("2009-11-14T22:20:00.000Z"));
        System.out.println(signedUrlCanned);
        String policy = CloudFrontService.buildPolicyForSignedUrl(policyResourcePath, ServiceUtils.parseIso8601Date("2009-11-14T22:20:00.000Z"), "0.0.0.0/0", ServiceUtils.parseIso8601Date("2009-10-16T06:31:56.000Z"));
        String signedUrl = CloudFrontService.signUrl("http://" + distributionDomain + "/" + s3ObjectKey, keyPairId, derPrivateKey, policy);
        System.out.println(signedUrl);
        StreamingDistribution[] streamingDistributions = cloudFrontService.listStreamingDistributions();
        for (int i2 = 0; i2 < streamingDistributions.length; ++i2) {
            System.out.println("Streaming distribution " + (i2 + 1) + ": " + streamingDistributions[i2]);
        }
        String streamingBucket = "jets3t-streaming.s3.amazonaws.com";
        StreamingDistribution newStreamingDistribution = cloudFrontService.createStreamingDistribution(new S3Origin(streamingBucket), "" + System.currentTimeMillis(), null, "Test streaming distribution", true, null);
        System.out.println("New Streaming Distribution: " + newStreamingDistribution);
        StreamingDistribution newPrivateStreamingDistribution = cloudFrontService.createStreamingDistribution(new S3Origin(streamingBucket, originAccessIdentityId), "" + System.currentTimeMillis(), new String[0], "New private streaming distribution -- URL signing not required", true, null, true, null);
        System.out.println("New Private Streaming Distribution: " + newPrivateStreamingDistribution);
        String testStreamingDistributionId = newStreamingDistribution.getId();
        StreamingDistribution streamingDistribution = cloudFrontService.getStreamingDistributionInfo(testStreamingDistributionId);
        System.out.println("Streaming Distribution: " + streamingDistribution);
        StreamingDistributionConfig streamingDistributionConfig = cloudFrontService.getStreamingDistributionConfig(testStreamingDistributionId);
        System.out.println("Streaming Distribution Config: " + streamingDistributionConfig);
        StreamingDistributionConfig updatedStreamingDistributionConfig = cloudFrontService.updateStreamingDistributionConfig(testStreamingDistributionId, null, new String[]{"cname.jets3t-streaming.com"}, "Updated this streaming distribution", true, new LoggingStatus("jets3t-streaming-logs.s3.amazonaws.com", "sdlog-"));
        System.out.println("Updated Streaming Distribution Config: " + updatedStreamingDistributionConfig);
        StreamingDistributionConfig disabledStreamingDistributionConfig = cloudFrontService.updateStreamingDistributionConfig(testStreamingDistributionId, null, new String[0], "Deleting distribution", false, null);
        System.out.println("Disabled Streaming Distribution Config: " + disabledStreamingDistributionConfig);
        StreamingDistribution streamingDistributionCheck = cloudFrontService.getStreamingDistributionInfo(testStreamingDistributionId);
        System.out.println("Streaming Distribution is deployed? " + streamingDistributionCheck.isDeployed());
        cloudFrontService.disableStreamingDistributionForDeletion(testStreamingDistributionId);
        cloudFrontService.deleteStreamingDistribution(testStreamingDistributionId);
        String[] objectKeys = new String[]{"downloads.html"};
        Invalidation invalidation = cloudFrontService.invalidateObjects(testDistributionId, objectKeys, "" + System.currentTimeMillis());
        System.out.println(invalidation);
        String invalidationId = invalidation.getId();
        Invalidation priorInvalidation = cloudFrontService.getInvalidation(testDistributionId, invalidationId);
        System.out.println(priorInvalidation);
        List<InvalidationSummary> invalidationSummaries = cloudFrontService.listInvalidations(testDistributionId);
        System.out.println(invalidationSummaries);
        CustomOrigin customOrigin = new CustomOrigin("www.jamesmurty.com", CustomOrigin.OriginProtocolPolicy.HTTP_ONLY);
        Distribution customOriginDistribution = cloudFrontService.createDistribution(customOrigin, "" + System.currentTimeMillis(), null, "Distribution with a non-S3 origin", true, null);
        System.out.println("Distribution with custom origin: " + customOriginDistribution);
    }
}

