/*
 * Decompiled with CFR 0.152.
 */
package net.java.sezpoz.impl;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.Filer;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.EnumConstantDeclaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.TypeMirror;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.java.sezpoz.Indexable;
import net.java.sezpoz.impl.SerAnnConst;
import net.java.sezpoz.impl.SerAnnotatedElement;
import net.java.sezpoz.impl.SerEnumConst;
import net.java.sezpoz.impl.SerTypeConst;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Indexer5
implements AnnotationProcessor {
    private final AnnotationProcessorEnvironment env;
    private final Map<String, List<SerAnnotatedElement>> output;

    public Indexer5(Set<AnnotationTypeDeclaration> ignore, AnnotationProcessorEnvironment env) {
        this.env = env;
        this.output = new HashMap<String, List<SerAnnotatedElement>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        for (TypeDeclaration typeDeclaration : this.env.getTypeDeclarations()) {
            this.analyze((Declaration)typeDeclaration);
            for (MethodDeclaration m : typeDeclaration.getMethods()) {
                this.analyze((Declaration)m);
            }
            for (FieldDeclaration f : typeDeclaration.getFields()) {
                this.analyze((Declaration)f);
            }
        }
        for (Map.Entry entry : this.output.entrySet()) {
            String annName = (String)entry.getKey();
            try {
                OutputStream os = this.env.getFiler().createBinaryFile(Filer.Location.CLASS_TREE, "", new File("META-INF" + File.separator + "annotations" + File.separator + annName));
                try {
                    ObjectOutputStream oos = new ObjectOutputStream(os);
                    for (SerAnnotatedElement el : (List)entry.getValue()) {
                        oos.writeObject(el);
                    }
                    oos.writeObject(null);
                    oos.flush();
                }
                finally {
                    os.close();
                }
            }
            catch (IOException x) {
                this.env.getMessager().printError(x.toString());
            }
        }
    }

    private void analyze(Declaration decl) {
        for (AnnotationMirror ann : decl.getAnnotationMirrors()) {
            boolean indexable = false;
            TypeMirror objType = null;
            for (AnnotationMirror metaAnn : ann.getAnnotationType().getDeclaration().getAnnotationMirrors()) {
                if (!Indexer5.getQualifiedNameUsingShell((TypeDeclaration)metaAnn.getAnnotationType().getDeclaration()).equals(Indexable.class.getName())) continue;
                Map values = metaAnn.getElementValues();
                if (!values.isEmpty()) {
                    AnnotationValue val = (AnnotationValue)values.values().iterator().next();
                    objType = (TypeMirror)val.getValue();
                }
                indexable = true;
                break;
            }
            if (!indexable) continue;
            String annName = Indexer5.getQualifiedNameUsingShell((TypeDeclaration)ann.getAnnotationType().getDeclaration());
            List<SerAnnotatedElement> existingOutput = this.output.get(annName);
            if (existingOutput == null) {
                existingOutput = new ArrayList<SerAnnotatedElement>();
                this.output.put(annName, existingOutput);
            }
            existingOutput.add(this.makeSerAnnotatedElement(decl, ann.getElementValues()));
        }
    }

    static String getQualifiedNameUsingShell(TypeDeclaration decl) {
        TypeDeclaration outer = decl.getDeclaringType();
        if (outer != null) {
            return Indexer5.getQualifiedNameUsingShell(outer) + '$' + decl.getSimpleName();
        }
        return decl.getQualifiedName();
    }

    private SerAnnotatedElement makeSerAnnotatedElement(Declaration decl, Map<AnnotationTypeElementDeclaration, AnnotationValue> annvalues) {
        boolean isMethod;
        String memberName;
        String className;
        if (decl instanceof TypeDeclaration) {
            className = Indexer5.getQualifiedNameUsingShell((TypeDeclaration)decl);
            memberName = null;
            isMethod = false;
        } else if (decl instanceof MethodDeclaration) {
            MethodDeclaration _decl = (MethodDeclaration)decl;
            className = Indexer5.getQualifiedNameUsingShell(_decl.getDeclaringType());
            memberName = _decl.getSimpleName();
            isMethod = true;
        } else {
            FieldDeclaration _decl = (FieldDeclaration)decl;
            className = Indexer5.getQualifiedNameUsingShell(_decl.getDeclaringType());
            memberName = _decl.getSimpleName();
            isMethod = false;
        }
        return new SerAnnotatedElement(className, memberName, isMethod, Indexer5.translate(annvalues));
    }

    private static TreeMap<String, Object> translate(Map<AnnotationTypeElementDeclaration, AnnotationValue> annvalues) {
        TreeMap<String, Object> values = new TreeMap<String, Object>();
        for (Map.Entry<AnnotationTypeElementDeclaration, AnnotationValue> entry : annvalues.entrySet()) {
            String key = entry.getKey().getSimpleName();
            AnnotationValue val = entry.getValue();
            values.put(key, Indexer5.translate(val.getValue()));
        }
        return values;
    }

    private static Object translate(Object annval) {
        if (annval instanceof Collection) {
            Collection annvals = (Collection)annval;
            ArrayList<Object> values = new ArrayList<Object>(annvals.size());
            for (AnnotationValue v : annvals) {
                values.add(Indexer5.translate(v.getValue()));
            }
            return values;
        }
        if (annval instanceof TypeMirror) {
            return new SerTypeConst(Indexer5.getQualifiedNameUsingShell(((DeclaredType)annval).getDeclaration()));
        }
        if (annval instanceof EnumConstantDeclaration) {
            EnumConstantDeclaration ecd = (EnumConstantDeclaration)annval;
            return new SerEnumConst(Indexer5.getQualifiedNameUsingShell((TypeDeclaration)ecd.getDeclaringType()), ecd.getSimpleName());
        }
        if (annval instanceof AnnotationMirror) {
            AnnotationMirror am = (AnnotationMirror)annval;
            return new SerAnnConst(Indexer5.getQualifiedNameUsingShell((TypeDeclaration)am.getAnnotationType().getDeclaration()), Indexer5.translate(am.getElementValues()));
        }
        return annval;
    }
}

