/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.web;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import net.kaczmarzyk.spring.data.jpa.domain.Conjunction;
import net.kaczmarzyk.spring.data.jpa.web.EnhancerUtil;
import net.kaczmarzyk.spring.data.jpa.web.SpecificationArgumentResolver;
import net.kaczmarzyk.spring.data.jpa.web.annotation.JoinFetch;
import net.kaczmarzyk.spring.data.jpa.web.annotation.Joins;
import org.springframework.core.MethodParameter;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

class JoinFetchSpecificationResolver
implements HandlerMethodArgumentResolver {
    private SpecificationArgumentResolver parentResolver;

    public JoinFetchSpecificationResolver(SpecificationArgumentResolver parent) {
        this.parentResolver = parent;
    }

    public boolean supportsParameter(MethodParameter param) {
        Class paramType = param.getParameterType();
        return paramType.isInterface() && Specification.class.isAssignableFrom(paramType) && (this.isAnnotatedWith(JoinFetch.class, param) || this.isAnnotatedWith(Joins.class, param));
    }

    private boolean isAnnotatedWith(Class<? extends Annotation> annotation, MethodParameter param) {
        return param.hasParameterAnnotation(annotation) || param.getParameterType().isAnnotationPresent(annotation);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Conjunction spec;
        Conjunction fetchSpec = this.resolveFetchSpec(parameter);
        Specification regularSpec = (Specification)this.parentResolver.resolveArgument(parameter, mavContainer, webRequest, binderFactory, this);
        Conjunction conjunction = spec = regularSpec == null ? fetchSpec : new Conjunction(Arrays.asList(fetchSpec, regularSpec));
        if (Specification.class == parameter.getParameterType()) {
            return spec;
        }
        return EnhancerUtil.wrapWithIfaceImplementation(parameter.getParameterType(), spec);
    }

    private Specification<Object> resolveFetchSpec(MethodParameter parameter) {
        if (this.isAnnotatedWith(JoinFetch.class, parameter)) {
            JoinFetch fetchDef = this.getFetchDef(JoinFetch.class, parameter);
            return this.newJoinFetch(fetchDef);
        }
        if (this.isAnnotatedWith(Joins.class, parameter)) {
            Joins joinsDef = this.getFetchDef(Joins.class, parameter);
            ArrayList joins = new ArrayList();
            for (JoinFetch fetchDef : joinsDef.value()) {
                joins.add(this.newJoinFetch(fetchDef));
            }
            return new Conjunction<Object>(joins);
        }
        throw new IllegalArgumentException("either @JoinFetch or @Joins expected!");
    }

    private net.kaczmarzyk.spring.data.jpa.domain.JoinFetch<Object> newJoinFetch(JoinFetch fetchDef) {
        return new net.kaczmarzyk.spring.data.jpa.domain.JoinFetch<Object>(fetchDef.paths(), fetchDef.joinType());
    }

    private <A extends Annotation> A getFetchDef(Class<A> annotation, MethodParameter parameter) {
        Annotation fetchDef = parameter.getParameterAnnotation(annotation);
        if (fetchDef == null) {
            fetchDef = parameter.getParameterType().getAnnotation(annotation);
        }
        return (A)fetchDef;
    }
}

