/*
 * Decompiled with CFR 0.152.
 */
package org.dozer;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedFieldsTracker {
    private final Map<Object, List<Object>> mappedFields = new IdentityHashMap<Object, List<Object>>();

    public void put(Object src, Object dest) {
        List<Object> mappedTo = this.mappedFields.get(src);
        if (mappedTo == null) {
            mappedTo = new ArrayList<Object>();
            this.mappedFields.put(src, mappedTo);
        }
        if (!mappedTo.contains(dest)) {
            mappedTo.add(dest);
        }
    }

    public Object getMappedValue(Object src, Class<?> destType) {
        List<Object> alreadyMappedValues = this.mappedFields.get(src);
        if (alreadyMappedValues != null) {
            for (Object alreadyMappedValue : alreadyMappedValues) {
                if (alreadyMappedValue == null || !destType.isAssignableFrom(alreadyMappedValue.getClass())) continue;
                return alreadyMappedValue;
            }
        }
        return null;
    }
}

