/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.loader;

import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dozer.classmap.ClassMap;
import org.dozer.classmap.ClassMapBuilder;
import org.dozer.classmap.ClassMappings;
import org.dozer.classmap.Configuration;
import org.dozer.classmap.MappingFileData;
import org.dozer.converters.CustomConverterContainer;
import org.dozer.converters.CustomConverterDescription;
import org.dozer.loader.LoadMappingsResult;
import org.dozer.loader.MappingsParser;
import org.dozer.loader.xml.MappingFileReader;
import org.dozer.loader.xml.XMLParserFactory;
import org.dozer.util.InitLogger;
import org.dozer.util.MappingUtils;
import org.dozer.util.MappingValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomMappingsLoader {
    private static final Log log = LogFactory.getLog(CustomMappingsLoader.class);
    private static final MappingsParser mappingsParser = MappingsParser.getInstance();
    private final MappingFileReader mappingFileReader = new MappingFileReader(XMLParserFactory.getInstance());

    public LoadMappingsResult load(List<String> mappingFiles) {
        List<MappingFileData> mappingFileDataList = this.loadFromFiles(mappingFiles);
        Configuration globalConfiguration = this.findConfiguration(mappingFileDataList);
        ClassMappings customMappings = new ClassMappings();
        for (MappingFileData mappingFileData : mappingFileDataList) {
            List<ClassMap> list = mappingFileData.getClassMaps();
            ClassMappings customMappingsPrime = mappingsParser.processMappings(list, globalConfiguration);
            customMappings.addAll(customMappingsPrime);
        }
        ClassMapBuilder.addDefaultFieldMappings(customMappings, globalConfiguration);
        LinkedHashSet<CustomConverterDescription> customConverterDescriptions = new LinkedHashSet<CustomConverterDescription>();
        if (globalConfiguration.getCustomConverters() != null && globalConfiguration.getCustomConverters().getConverters() != null) {
            for (CustomConverterDescription customConverterDescription : globalConfiguration.getCustomConverters().getConverters()) {
                customConverterDescriptions.add(customConverterDescription);
            }
        }
        for (Map.Entry entry : customMappings.getAll().entrySet()) {
            ClassMap classMap = (ClassMap)entry.getValue();
            if (classMap.getCustomConverters() != null) {
                classMap.getCustomConverters().setConverters(new ArrayList<CustomConverterDescription>(customConverterDescriptions));
                continue;
            }
            classMap.setCustomConverters(new CustomConverterContainer());
            classMap.getCustomConverters().setConverters(new ArrayList<CustomConverterDescription>(customConverterDescriptions));
        }
        return new LoadMappingsResult(customMappings, globalConfiguration);
    }

    private List<MappingFileData> loadFromFiles(List<String> mappingFiles) {
        ArrayList<MappingFileData> mappingFileDataList = new ArrayList<MappingFileData>();
        if (mappingFiles != null && mappingFiles.size() > 0) {
            InitLogger.log(log, "Using the following xml files to load custom mappings for the bean mapper instance: " + mappingFiles);
            for (String mappingFileName : mappingFiles) {
                InitLogger.log(log, "Trying to find xml mapping file: " + mappingFileName);
                URL url = MappingValidator.validateURL(mappingFileName);
                InitLogger.log(log, "Using URL [" + url + "] to load custom xml mappings");
                MappingFileData mappingFileData = this.mappingFileReader.read(url);
                InitLogger.log(log, "Successfully loaded custom xml mappings from URL: [" + url + "]");
                mappingFileDataList.add(mappingFileData);
            }
        }
        return mappingFileDataList;
    }

    private Configuration findConfiguration(List<MappingFileData> mappingFileDataList) {
        Configuration globalConfiguration = null;
        for (MappingFileData mappingFileData : mappingFileDataList) {
            if (mappingFileData.getConfiguration() == null) continue;
            if (globalConfiguration != null) {
                MappingUtils.throwMappingException("More than one global configuration found.  Only one global configuration block (<configuration></configuration>) can be specified across all mapping files.  You need to consolidate all global configuration blocks into a single one.");
            }
            globalConfiguration = mappingFileData.getConfiguration();
        }
        if (globalConfiguration == null) {
            globalConfiguration = new Configuration();
        }
        return globalConfiguration;
    }
}

