/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.propertydescriptor;

import java.lang.reflect.Field;
import org.dozer.fieldmap.FieldMap;
import org.dozer.fieldmap.HintContainer;
import org.dozer.propertydescriptor.AbstractPropertyDescriptor;
import org.dozer.propertydescriptor.DozerPropertyDescriptor;
import org.dozer.util.MappingUtils;
import org.dozer.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldPropertyDescriptor
extends AbstractPropertyDescriptor
implements DozerPropertyDescriptor {
    private Field field;

    public FieldPropertyDescriptor(Class<?> clazz, String fieldName, boolean isIndexed, int index, HintContainer srcDeepIndexHintContainer, HintContainer destDeepIndexHintContainer) {
        super(clazz, fieldName, isIndexed, index, srcDeepIndexHintContainer, destDeepIndexHintContainer);
        try {
            this.field = ReflectionUtils.getFieldFromBean(clazz, fieldName);
        }
        catch (NoSuchFieldException e) {
            MappingUtils.throwMappingException("No such field found " + clazz + "." + fieldName, e);
        }
        this.field.setAccessible(true);
    }

    @Override
    public Class<?> getPropertyType() {
        return this.field.getType();
    }

    @Override
    public Object getPropertyValue(Object bean) {
        Object result = null;
        try {
            result = this.field.get(bean);
        }
        catch (IllegalArgumentException e) {
            MappingUtils.throwMappingException(e);
        }
        catch (IllegalAccessException e) {
            MappingUtils.throwMappingException(e);
        }
        if (this.isIndexed) {
            result = MappingUtils.getIndexedValue(result, this.index);
        }
        return result;
    }

    @Override
    public void setPropertyValue(Object bean, Object value, FieldMap fieldMap) {
        if (this.getPropertyType().isPrimitive() && value == null) {
            return;
        }
        if (this.getPropertyValue(bean) == value) {
            return;
        }
        try {
            if (this.isIndexed) {
                Object existingValue = this.field.get(bean);
                this.field.set(bean, this.prepareIndexedCollection(existingValue, value));
            } else {
                this.field.set(bean, value);
            }
        }
        catch (IllegalAccessException e) {
            MappingUtils.throwMappingException(e);
        }
    }
}

