/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.util;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.beanutils.PropertyUtils;
import org.dozer.MappingException;
import org.dozer.fieldmap.HintContainer;
import org.dozer.propertydescriptor.DeepHierarchyElement;
import org.dozer.util.MappingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionUtils {
    private static final String IAE_MESSAGE = "argument type mismatch";

    private ReflectionUtils() {
    }

    public static PropertyDescriptor findPropertyDescriptor(Class<?> objectClass, String fieldName, HintContainer deepIndexHintContainer) {
        PropertyDescriptor result = null;
        if (MappingUtils.isDeepMapping(fieldName)) {
            DeepHierarchyElement[] hierarchy = ReflectionUtils.getDeepFieldHierarchy(objectClass, fieldName, deepIndexHintContainer);
            result = hierarchy[hierarchy.length - 1].getPropDescriptor();
        } else {
            PropertyDescriptor[] descriptors = ReflectionUtils.getPropertyDescriptors(objectClass);
            if (descriptors != null) {
                int size = descriptors.length;
                for (int i = 0; i < size; ++i) {
                    if (!fieldName.equalsIgnoreCase(descriptors[i].getName())) continue;
                    result = descriptors[i];
                    break;
                }
            }
        }
        return result;
    }

    public static DeepHierarchyElement[] getDeepFieldHierarchy(Class<?> parentClass, String field, HintContainer deepIndexHintContainer) {
        if (!MappingUtils.isDeepMapping(field)) {
            MappingUtils.throwMappingException("Field does not contain deep field delimitor");
        }
        StringTokenizer toks = new StringTokenizer(field, ".");
        Class<?> latestClass = parentClass;
        DeepHierarchyElement[] hierarchy = new DeepHierarchyElement[toks.countTokens()];
        int index = 0;
        int hintIndex = 0;
        while (toks.hasMoreTokens()) {
            String aFieldName;
            String theFieldName = aFieldName = toks.nextToken();
            int collectionIndex = -1;
            if (aFieldName.contains("[")) {
                theFieldName = aFieldName.substring(0, aFieldName.indexOf("["));
                collectionIndex = Integer.parseInt(aFieldName.substring(aFieldName.indexOf("[") + 1, aFieldName.indexOf("]")));
            }
            PropertyDescriptor propDescriptor = ReflectionUtils.findPropertyDescriptor(latestClass, theFieldName, deepIndexHintContainer);
            DeepHierarchyElement r = new DeepHierarchyElement(propDescriptor, collectionIndex);
            if (propDescriptor == null) {
                MappingUtils.throwMappingException("Exception occurred determining deep field hierarchy for Class --> " + parentClass.getName() + ", Field --> " + field + ".  Unable to determine property descriptor for Class --> " + latestClass.getName() + ", Field Name: " + aFieldName);
            }
            latestClass = propDescriptor.getPropertyType();
            if (toks.hasMoreTokens()) {
                if (latestClass.isArray()) {
                    latestClass = latestClass.getComponentType();
                } else if (Collection.class.isAssignableFrom(latestClass)) {
                    Class<?> genericType = ReflectionUtils.determineGenericsType(propDescriptor);
                    if (genericType == null && deepIndexHintContainer == null) {
                        MappingUtils.throwMappingException("Hint(s) or Generics not specified.  Hint(s) or Generics must be specified for deep mapping with indexed field(s). Exception occurred determining deep field hierarchy for Class --> " + parentClass.getName() + ", Field --> " + field + ".  Unable to determine property descriptor for Class --> " + latestClass.getName() + ", Field Name: " + aFieldName);
                    }
                    if (genericType != null) {
                        latestClass = genericType;
                    } else {
                        latestClass = deepIndexHintContainer.getHint(hintIndex);
                        ++hintIndex;
                    }
                }
            }
            hierarchy[index++] = r;
        }
        return hierarchy;
    }

    public static Method getMethod(Object obj, String methodName) {
        return ReflectionUtils.getMethod(obj.getClass(), methodName);
    }

    public static Method getMethod(Class<?> clazz, String methodName) {
        Method result = ReflectionUtils.findMethod(clazz, methodName);
        if (result == null) {
            MappingUtils.throwMappingException("No method found for class:" + clazz + " and method name:" + methodName);
        }
        return result;
    }

    private static Method findMethod(Class<?> clazz, String methodName) {
        Method[] methods = clazz.getMethods();
        Method result = null;
        for (Method method : methods) {
            if (!method.getName().equals(methodName)) continue;
            result = method;
        }
        return result;
    }

    public static Method findAMethod(Class<?> parentDestClass, String methodName) throws NoSuchMethodException {
        StringTokenizer tokenizer = new StringTokenizer(methodName, "(");
        String m = tokenizer.nextToken();
        if (tokenizer.hasMoreElements()) {
            StringTokenizer tokens = new StringTokenizer(tokenizer.nextToken(), ")");
            String params = tokens.hasMoreTokens() ? tokens.nextToken() : null;
            return ReflectionUtils.findMethodWithParam(parentDestClass, m, params);
        }
        return ReflectionUtils.findMethod(parentDestClass, methodName);
    }

    private static Method findMethodWithParam(Class<?> parentDestClass, String methodName, String params) throws NoSuchMethodException {
        ArrayList list = new ArrayList();
        if (params != null) {
            StringTokenizer tokenizer = new StringTokenizer(params, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                list.add(MappingUtils.loadClass(token));
            }
        }
        return ReflectionUtils.getMethod(parentDestClass, methodName, list.toArray(new Class[list.size()]));
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<?> objectClass) {
        if (objectClass.isInterface()) {
            return ReflectionUtils.getInterfacePropertyDescriptors(objectClass);
        }
        return PropertyUtils.getPropertyDescriptors(objectClass);
    }

    static PropertyDescriptor[] getInterfacePropertyDescriptors(Class<?> interfaceClass) {
        ArrayList<PropertyDescriptor> propDescriptors = new ArrayList<PropertyDescriptor>();
        propDescriptors.addAll(Arrays.asList(PropertyUtils.getPropertyDescriptors(interfaceClass)));
        Class<?>[] interfaces = interfaceClass.getInterfaces();
        if (interfaces != null) {
            for (Class<?> superInterfaceClass : interfaces) {
                List<PropertyDescriptor> superInterfacePropertyDescriptors = Arrays.asList(ReflectionUtils.getInterfacePropertyDescriptors(superInterfaceClass));
                for (PropertyDescriptor superPropDescriptor : superInterfacePropertyDescriptors) {
                    PropertyDescriptor existingPropDescriptor = ReflectionUtils.findPropDescriptorByName(propDescriptors, superPropDescriptor.getName());
                    if (existingPropDescriptor == null) {
                        propDescriptors.add(superPropDescriptor);
                        continue;
                    }
                    try {
                        if (existingPropDescriptor.getReadMethod() == null) {
                            existingPropDescriptor.setReadMethod(superPropDescriptor.getReadMethod());
                        }
                        if (existingPropDescriptor.getWriteMethod() != null) continue;
                        existingPropDescriptor.setWriteMethod(superPropDescriptor.getWriteMethod());
                    }
                    catch (IntrospectionException e) {
                        throw new MappingException(e);
                    }
                }
            }
        }
        return propDescriptors.toArray(new PropertyDescriptor[propDescriptors.size()]);
    }

    private static PropertyDescriptor findPropDescriptorByName(List<PropertyDescriptor> propDescriptors, String name) {
        PropertyDescriptor result = null;
        for (PropertyDescriptor pd : propDescriptors) {
            if (!pd.getName().equals(name)) continue;
            result = pd;
            break;
        }
        return result;
    }

    public static Field getFieldFromBean(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            if (clazz.getSuperclass() != null) {
                return ReflectionUtils.getFieldFromBean(clazz.getSuperclass(), fieldName);
            }
            throw e;
        }
    }

    public static Object invoke(Method method, Object obj, Object[] args) {
        Object result = null;
        try {
            result = method.invoke(obj, args);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().equals(IAE_MESSAGE)) {
                MappingUtils.throwMappingException(ReflectionUtils.prepareExceptionMessage(method, args), e);
            }
            MappingUtils.throwMappingException(e);
        }
        catch (IllegalAccessException e) {
            MappingUtils.throwMappingException(e);
        }
        catch (InvocationTargetException e) {
            MappingUtils.throwMappingException(e);
        }
        return result;
    }

    private static String prepareExceptionMessage(Method method, Object[] args) {
        StringBuffer message = new StringBuffer("Illegal object type for the method '" + method.getName() + "'. \n ");
        message.append("Expected types: \n");
        for (Class<?> type : method.getParameterTypes()) {
            message.append(type.getName());
        }
        message.append("\n Actual types: \n");
        for (Object param : args) {
            message.append(param.getClass().getName());
        }
        return message.toString();
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?>[] parameterTypes) throws NoSuchMethodException {
        return clazz.getMethod(name, parameterTypes);
    }

    public static <T> T newInstance(Class<T> clazz) {
        T result = null;
        try {
            result = clazz.newInstance();
        }
        catch (InstantiationException e) {
            MappingUtils.throwMappingException(e);
        }
        catch (IllegalAccessException e) {
            MappingUtils.throwMappingException(e);
        }
        return result;
    }

    public static Class<?> determineGenericsType(PropertyDescriptor propDescriptor) {
        Class<?> result = null;
        if (propDescriptor.getWriteMethod() != null) {
            result = ReflectionUtils.determineGenericsType(propDescriptor.getWriteMethod(), false);
        }
        if (result == null && propDescriptor.getReadMethod() != null) {
            result = ReflectionUtils.determineGenericsType(propDescriptor.getReadMethod(), true);
        }
        return result;
    }

    public static Class<?> determineGenericsType(Method method, boolean isReadMethod) {
        Class result = null;
        if (isReadMethod) {
            Type genericType;
            Type parameterType = method.getGenericReturnType();
            if (parameterType != null && ParameterizedType.class.isAssignableFrom(parameterType.getClass()) && (genericType = ((ParameterizedType)parameterType).getActualTypeArguments()[0]) != null) {
                result = (Class)genericType;
            }
        } else {
            Type genericType;
            Type[] parameterTypes = method.getGenericParameterTypes();
            if (parameterTypes != null && ParameterizedType.class.isAssignableFrom(parameterTypes[0].getClass()) && (genericType = ((ParameterizedType)parameterTypes[0]).getActualTypeArguments()[0]) != null) {
                result = (Class)genericType;
            }
        }
        return result;
    }
}

