/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.event;

import java.util.List;
import org.dozer.DozerEventListener;
import org.dozer.event.DozerEvent;
import org.dozer.event.DozerEventType;
import org.dozer.event.EventManager;
import org.dozer.util.MappingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DozerEventManager
implements EventManager {
    private final List<? extends DozerEventListener> eventListeners;

    public DozerEventManager(List<? extends DozerEventListener> eventListeners) {
        this.eventListeners = eventListeners;
    }

    @Override
    public void fireEvent(DozerEvent event) {
        if (this.eventListeners == null) {
            return;
        }
        DozerEventType eventType = event.getType();
        block6: for (DozerEventListener dozerEventListener : this.eventListeners) {
            switch (eventType) {
                case MAPPING_STARTED: {
                    dozerEventListener.mappingStarted(event);
                    continue block6;
                }
                case MAPPING_PRE_WRITING_DEST_VALUE: {
                    dozerEventListener.preWritingDestinationValue(event);
                    continue block6;
                }
                case MAPPING_POST_WRITING_DEST_VALUE: {
                    dozerEventListener.postWritingDestinationValue(event);
                    continue block6;
                }
                case MAPPING_FINISHED: {
                    dozerEventListener.mappingFinished(event);
                    continue block6;
                }
            }
            MappingUtils.throwMappingException("Unsupported event type: " + (Object)((Object)eventType));
        }
    }
}

