/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.farng.mp3.AbstractMP3FileItem;
import org.farng.mp3.AbstractMP3Tag;
import org.farng.mp3.TagException;
import org.farng.mp3.TagNotFoundException;
import org.farng.mp3.TagUtility;
import org.farng.mp3.id3.AbstractID3;
import org.farng.mp3.id3.AbstractID3v2Frame;
import org.farng.mp3.id3.ID3v2_2;
import org.farng.mp3.id3.ID3v2_3;
import org.farng.mp3.id3.ID3v2_4;

public abstract class AbstractID3v2
extends AbstractID3 {
    private static int paddingCounter = 0;
    private Map frameMap = new HashMap();
    private String duplicateFrameId = null;
    private byte majorVersion = 0;
    private byte revision = 0;
    private int duplicateBytes = 0;
    private int emptyFrameBytes = 0;
    private int fileReadSize = 0;
    private int invalidFrameBytes = 0;
    private int padding = 0;

    protected AbstractID3v2() {
    }

    protected AbstractID3v2(AbstractID3v2 abstractID3v2) {
        super(abstractID3v2);
        this.duplicateFrameId = abstractID3v2.duplicateFrameId;
        this.majorVersion = abstractID3v2.majorVersion;
        this.revision = abstractID3v2.revision;
        this.duplicateBytes = abstractID3v2.duplicateBytes;
        this.emptyFrameBytes = abstractID3v2.emptyFrameBytes;
        this.fileReadSize = abstractID3v2.fileReadSize;
        this.invalidFrameBytes = abstractID3v2.invalidFrameBytes;
        this.padding = abstractID3v2.padding;
        Iterator iterator = abstractID3v2.frameMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            AbstractID3v2Frame abstractID3v2Frame = (AbstractID3v2Frame)TagUtility.copyObject(abstractID3v2.frameMap.get(string));
            this.frameMap.put(abstractID3v2Frame.getIdentifier(), abstractID3v2Frame);
        }
    }

    public void setFrame(AbstractID3v2Frame abstractID3v2Frame) {
        if (abstractID3v2Frame.getBody() != null) {
            this.frameMap.put(abstractID3v2Frame.getIdentifier(), abstractID3v2Frame);
        }
    }

    public AbstractID3v2Frame getFrame(String string) {
        return (AbstractID3v2Frame)this.frameMap.get(string);
    }

    public int getFrameCount() {
        int n = 0;
        if (this.frameMap != null) {
            n = this.frameMap.size();
        }
        return n;
    }

    public void clearFrameMap() {
        this.frameMap.clear();
    }

    public Iterator getFrameIterator() {
        return this.frameMap.values().iterator();
    }

    public Iterator getFrameOfType(String string) {
        Iterator iterator = this.frameMap.keySet().iterator();
        HashSet hashSet = new HashSet(this.frameMap.size());
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.startsWith(string)) continue;
            hashSet.add(this.frameMap.get(string2));
        }
        return hashSet.iterator();
    }

    public boolean hasFrame(String string) {
        return this.frameMap.containsKey(string);
    }

    public boolean hasFrameOfType(String string) {
        Iterator iterator = this.frameMap.keySet().iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            String string2 = (String)iterator.next();
            if (!string2.startsWith(string)) continue;
            bl = true;
        }
        return bl;
    }

    public Iterator iterator() {
        return this.frameMap.values().iterator();
    }

    public void removeFrame(String string) {
        this.frameMap.remove(string);
    }

    public void removeFrameOfType(String string) {
        Iterator iterator = this.getFrameOfType(string);
        while (iterator.hasNext()) {
            AbstractID3v2Frame abstractID3v2Frame = (AbstractID3v2Frame)iterator.next();
            this.frameMap.remove(abstractID3v2Frame.getIdentifier());
        }
    }

    public Collection values() {
        return this.frameMap.values();
    }

    public void append(AbstractMP3Tag abstractMP3Tag) {
        AbstractID3v2 abstractID3v2 = this;
        if (abstractMP3Tag != null) {
            AbstractID3v2 abstractID3v22 = abstractMP3Tag instanceof AbstractID3v2 ? (AbstractID3v2)abstractMP3Tag : new ID3v2_4(abstractMP3Tag);
            Iterator iterator = abstractID3v22.getFrameIterator();
            while (iterator.hasNext()) {
                AbstractID3v2Frame abstractID3v2Frame = (AbstractID3v2Frame)iterator.next();
                if (abstractID3v2.hasFrame(abstractID3v2Frame.getIdentifier())) continue;
                abstractID3v2.setFrame(abstractID3v2Frame);
            }
        }
    }

    public void append(RandomAccessFile randomAccessFile) throws IOException, TagException {
        try {
            ID3v2_4 iD3v2_4 = new ID3v2_4(randomAccessFile);
            ((AbstractID3v2)iD3v2_4).append(this);
            ((AbstractMP3FileItem)iD3v2_4).write(randomAccessFile);
        }
        catch (TagNotFoundException tagNotFoundException) {
            try {
                ID3v2_3 iD3v2_3 = new ID3v2_3(randomAccessFile);
                ((AbstractID3v2)iD3v2_3).append(this);
                ((AbstractMP3FileItem)iD3v2_3).write(randomAccessFile);
            }
            catch (TagNotFoundException tagNotFoundException2) {
                try {
                    ID3v2_2 iD3v2_2 = new ID3v2_2(randomAccessFile);
                    ((AbstractID3v2)iD3v2_2).append(this);
                    ((AbstractMP3FileItem)iD3v2_2).write(randomAccessFile);
                }
                catch (TagNotFoundException tagNotFoundException3) {
                    this.write(randomAccessFile);
                }
            }
        }
    }

    public void delete(RandomAccessFile randomAccessFile) throws IOException {
        byte[] byArray = new byte[3];
        if (this.seek(randomAccessFile)) {
            randomAccessFile.seek(0L);
            randomAccessFile.write(byArray);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof AbstractID3v2)) {
            return false;
        }
        AbstractID3v2 abstractID3v2 = (AbstractID3v2)object;
        if (!((Object)this.frameMap).equals(abstractID3v2.frameMap)) {
            return false;
        }
        return super.equals(object);
    }

    public void overwrite(AbstractMP3Tag abstractMP3Tag) {
        AbstractID3v2 abstractID3v2 = this;
        if (abstractMP3Tag != null) {
            AbstractID3v2 abstractID3v22 = abstractMP3Tag instanceof AbstractID3v2 ? (AbstractID3v2)abstractMP3Tag : new ID3v2_4(abstractMP3Tag);
            Iterator iterator = abstractID3v22.getFrameIterator();
            while (iterator.hasNext()) {
                AbstractID3v2Frame abstractID3v2Frame = (AbstractID3v2Frame)iterator.next();
                abstractID3v2.setFrame(abstractID3v2Frame);
            }
        }
    }

    public void overwrite(RandomAccessFile randomAccessFile) throws IOException, TagException {
        try {
            ID3v2_4 iD3v2_4 = new ID3v2_4(randomAccessFile);
            ((AbstractID3v2)iD3v2_4).overwrite(this);
            ((AbstractMP3FileItem)iD3v2_4).write(randomAccessFile);
        }
        catch (TagNotFoundException tagNotFoundException) {
            try {
                ID3v2_3 iD3v2_3 = new ID3v2_3(randomAccessFile);
                ((AbstractID3v2)iD3v2_3).overwrite(this);
                ((AbstractMP3FileItem)iD3v2_3).write(randomAccessFile);
            }
            catch (TagNotFoundException tagNotFoundException2) {
                try {
                    ID3v2_2 iD3v2_2 = new ID3v2_2(randomAccessFile);
                    ((AbstractID3v2)iD3v2_2).overwrite(this);
                    ((AbstractMP3FileItem)iD3v2_2).write(randomAccessFile);
                }
                catch (TagNotFoundException tagNotFoundException3) {
                    this.write(randomAccessFile);
                }
            }
        }
    }

    public void write(AbstractMP3Tag abstractMP3Tag) {
        AbstractID3v2 abstractID3v2 = this;
        if (abstractMP3Tag != null) {
            AbstractID3v2 abstractID3v22 = abstractMP3Tag instanceof AbstractID3v2 ? (AbstractID3v2)abstractMP3Tag : new ID3v2_4(abstractMP3Tag);
            Iterator iterator = abstractID3v22.getFrameIterator();
            abstractID3v2.frameMap.clear();
            while (iterator.hasNext()) {
                AbstractID3v2Frame abstractID3v2Frame = (AbstractID3v2Frame)iterator.next();
                abstractID3v2.setFrame(abstractID3v2Frame);
            }
        }
    }

    protected static int byteArrayToSize(byte[] byArray) {
        return (byArray[0] << 21) + (byArray[1] << 14) + (byArray[2] << 7) + byArray[3];
    }

    protected static byte[] sizeToByteArray(int n) {
        byte[] byArray = new byte[]{(byte)((n & 0xFE00000) >> 21), (byte)((n & 0x1FC000) >> 14), (byte)((n & 0x3F80) >> 7), (byte)(n & 0x7F)};
        return byArray;
    }

    protected static void resetPaddingCounter() {
        paddingCounter = 0;
    }

    protected static void incrementPaddingCounter() {
        ++paddingCounter;
    }

    protected static void decrementPaddingCounter() {
        --paddingCounter;
    }

    protected static int getPaddingCounter() {
        return paddingCounter;
    }

    public byte getMajorVersion() {
        return this.majorVersion;
    }

    protected void setMajorVersion(byte by) {
        this.majorVersion = by;
    }

    public byte getRevision() {
        return this.revision;
    }

    protected void setRevision(byte by) {
        this.revision = by;
    }

    public int getDuplicateBytes() {
        return this.duplicateBytes;
    }

    public String getDuplicateFrameId() {
        return this.duplicateFrameId;
    }

    public int getEmptyFrameBytes() {
        return this.emptyFrameBytes;
    }

    public int getFileReadBytes() {
        return this.fileReadSize;
    }

    protected void setFileReadBytes(int n) {
        this.fileReadSize = n;
    }

    protected void setPaddingSize(int n) {
        this.padding = n;
    }

    protected void incrementDuplicateBytes(int n) {
        this.duplicateBytes += n;
    }

    protected void incrementEmptyFrameBytes(int n) {
        this.emptyFrameBytes += n;
    }

    protected void incrementInvalidFrameBytes() {
        ++this.invalidFrameBytes;
    }

    protected void appendDuplicateFrameId(String string) {
        this.duplicateFrameId = this.duplicateFrameId + string;
    }

    public int getInvalidFrameBytes() {
        return this.invalidFrameBytes;
    }

    public int getPaddingSize() {
        return this.padding;
    }
}

