/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import org.farng.mp3.AbstractMP3Tag;
import org.farng.mp3.TagNotFoundException;
import org.farng.mp3.TagOptionSingleton;
import org.farng.mp3.TagUtility;
import org.farng.mp3.id3.AbstractID3v1;
import org.farng.mp3.id3.ID3v1Iterator;
import org.farng.mp3.id3.ID3v1_1;
import org.farng.mp3.lyrics3.AbstractLyrics3;

public class ID3v1
extends AbstractID3v1 {
    protected String album = "";
    protected String artist = "";
    protected String comment = "";
    protected String title = "";
    protected String year = "";
    protected byte genre = (byte)-1;

    public ID3v1() {
    }

    public ID3v1(ID3v1 iD3v1) {
        super(iD3v1);
        this.album = new String(iD3v1.album);
        this.artist = new String(iD3v1.artist);
        this.comment = new String(iD3v1.comment);
        this.title = new String(iD3v1.title);
        this.year = new String(iD3v1.year);
        this.genre = iD3v1.genre;
    }

    public ID3v1(AbstractMP3Tag abstractMP3Tag) {
        if (abstractMP3Tag != null) {
            if (abstractMP3Tag instanceof ID3v1 && !(abstractMP3Tag instanceof ID3v1_1)) {
                throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
            }
            ID3v1_1 iD3v1_1 = abstractMP3Tag instanceof ID3v1_1 ? (ID3v1_1)abstractMP3Tag : new ID3v1_1(abstractMP3Tag);
            this.album = new String(iD3v1_1.album.trim());
            this.artist = new String(iD3v1_1.artist.trim());
            this.comment = new String(iD3v1_1.comment.trim());
            this.title = new String(iD3v1_1.title.trim());
            this.year = new String(iD3v1_1.year.trim());
            this.genre = iD3v1_1.genre;
        }
    }

    public ID3v1(RandomAccessFile randomAccessFile) throws TagNotFoundException, IOException {
        this.read(randomAccessFile);
    }

    public void setAlbum(String string) {
        this.album = TagUtility.truncate(string, 30);
    }

    public String getAlbum() {
        return this.album;
    }

    public void setArtist(String string) {
        this.artist = TagUtility.truncate(string, 30);
    }

    public String getArtist() {
        return this.artist;
    }

    public void setComment(String string) {
        this.comment = TagUtility.truncate(string, 30);
    }

    public String getComment() {
        return this.comment;
    }

    public void setGenre(byte by) {
        this.genre = by;
    }

    public byte getGenre() {
        return this.genre;
    }

    public ID3v1 getID3tag(RandomAccessFile randomAccessFile) throws IOException {
        ID3v1 iD3v1 = new ID3v1_1();
        if (iD3v1.seek(randomAccessFile)) {
            try {
                iD3v1.read(randomAccessFile);
                iD3v1.delete(randomAccessFile);
            }
            catch (TagNotFoundException tagNotFoundException) {
                iD3v1 = null;
            }
        } else {
            iD3v1 = null;
        }
        if (iD3v1 == null) {
            iD3v1 = new ID3v1();
            if (iD3v1.seek(randomAccessFile)) {
                try {
                    iD3v1.read(randomAccessFile);
                    iD3v1.delete(randomAccessFile);
                }
                catch (TagNotFoundException tagNotFoundException) {
                    iD3v1 = null;
                }
            } else {
                iD3v1 = null;
            }
        }
        return iD3v1;
    }

    public String getIdentifier() {
        return "ID3v1.00";
    }

    public int getSize() {
        return 128;
    }

    public void setTitle(String string) {
        this.title = TagUtility.truncate(string, 30);
    }

    public String getTitle() {
        return this.title;
    }

    public void setYear(String string) {
        this.year = TagUtility.truncate(string, 4);
    }

    public String getYear() {
        return this.year;
    }

    public void append(AbstractMP3Tag abstractMP3Tag) {
        ID3v1 iD3v1 = this;
        if (abstractMP3Tag != null) {
            ID3v1 iD3v12 = abstractMP3Tag instanceof ID3v1 ? (ID3v1)abstractMP3Tag : new ID3v1();
            if (abstractMP3Tag instanceof AbstractLyrics3) {
                TagOptionSingleton.getInstance().setId3v1SaveYear(false);
                TagOptionSingleton.getInstance().setId3v1SaveComment(false);
            }
            iD3v1.title = TagOptionSingleton.getInstance().isId3v1SaveTitle() && iD3v1.title.length() == 0 ? iD3v12.title : iD3v1.title;
            iD3v1.artist = TagOptionSingleton.getInstance().isId3v1SaveArtist() && iD3v1.artist.length() == 0 ? iD3v12.artist : iD3v1.artist;
            iD3v1.album = TagOptionSingleton.getInstance().isId3v1SaveAlbum() && iD3v1.album.length() == 0 ? iD3v12.album : iD3v1.album;
            iD3v1.year = TagOptionSingleton.getInstance().isId3v1SaveYear() && iD3v1.year.length() == 0 ? iD3v12.year : iD3v1.year;
            iD3v1.comment = TagOptionSingleton.getInstance().isId3v1SaveComment() && iD3v1.comment.length() == 0 ? iD3v12.comment : iD3v1.comment;
            iD3v1.genre = TagOptionSingleton.getInstance().isId3v1SaveGenre() && iD3v1.genre < 0 ? iD3v12.genre : iD3v1.genre;
        }
    }

    public void delete(RandomAccessFile randomAccessFile) throws IOException {
        if (this.seek(randomAccessFile)) {
            randomAccessFile.setLength(randomAccessFile.length() - 128L);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof ID3v1)) {
            return false;
        }
        ID3v1 iD3v1 = (ID3v1)object;
        if (!this.album.equals(iD3v1.album)) {
            return false;
        }
        if (!this.artist.equals(iD3v1.artist)) {
            return false;
        }
        if (!this.comment.equals(iD3v1.comment)) {
            return false;
        }
        if (this.genre != iD3v1.genre) {
            return false;
        }
        if (!this.title.equals(iD3v1.title)) {
            return false;
        }
        if (!this.year.equals(iD3v1.year)) {
            return false;
        }
        return super.equals(object);
    }

    public Iterator iterator() {
        return new ID3v1Iterator(this);
    }

    public void overwrite(AbstractMP3Tag abstractMP3Tag) {
        ID3v1 iD3v1 = this;
        if (abstractMP3Tag != null) {
            ID3v1 iD3v12 = abstractMP3Tag instanceof ID3v1 ? (ID3v1)abstractMP3Tag : new ID3v1();
            if (abstractMP3Tag instanceof AbstractLyrics3) {
                TagOptionSingleton.getInstance().setId3v1SaveYear(false);
                TagOptionSingleton.getInstance().setId3v1SaveComment(false);
            }
            iD3v1.title = TagOptionSingleton.getInstance().isId3v1SaveTitle() ? iD3v12.title : iD3v1.artist;
            iD3v1.artist = TagOptionSingleton.getInstance().isId3v1SaveArtist() ? iD3v12.artist : iD3v1.artist;
            iD3v1.album = TagOptionSingleton.getInstance().isId3v1SaveAlbum() ? iD3v12.album : iD3v1.album;
            iD3v1.year = TagOptionSingleton.getInstance().isId3v1SaveYear() ? iD3v12.year : iD3v1.year;
            iD3v1.comment = TagOptionSingleton.getInstance().isId3v1SaveComment() ? iD3v12.comment : iD3v1.comment;
            iD3v1.genre = TagOptionSingleton.getInstance().isId3v1SaveGenre() ? iD3v12.genre : iD3v1.genre;
        }
    }

    public void read(RandomAccessFile randomAccessFile) throws TagNotFoundException, IOException {
        byte[] byArray = new byte[30];
        if (!this.seek(randomAccessFile)) {
            throw new TagNotFoundException("ID3v1 tag not found");
        }
        randomAccessFile.read(byArray, 0, 30);
        this.title = new String(byArray, 0, 30, "ISO-8859-1").trim();
        randomAccessFile.read(byArray, 0, 30);
        this.artist = new String(byArray, 0, 30, "ISO-8859-1").trim();
        randomAccessFile.read(byArray, 0, 30);
        this.album = new String(byArray, 0, 30, "ISO-8859-1").trim();
        randomAccessFile.read(byArray, 0, 4);
        this.year = new String(byArray, 0, 4, "ISO-8859-1").trim();
        randomAccessFile.read(byArray, 0, 30);
        this.comment = new String(byArray, 0, 30, "ISO-8859-1").trim();
        randomAccessFile.read(byArray, 0, 1);
        this.genre = byArray[0];
    }

    public boolean seek(RandomAccessFile randomAccessFile) throws IOException {
        byte[] byArray = new byte[3];
        randomAccessFile.seek(randomAccessFile.length() - 128L);
        randomAccessFile.read(byArray, 0, 3);
        String string = new String(byArray, 0, 3);
        return string.equals("TAG");
    }

    public String toString() {
        String string = this.getIdentifier() + " " + this.getSize() + "\n";
        string = string + "Title = " + this.title + "\n";
        string = string + "Artist = " + this.artist + "\n";
        string = string + "Album = " + this.album + "\n";
        string = string + "Comment = " + this.comment + "\n";
        string = string + "Year = " + this.year + "\n";
        string = string + "Genre = " + this.genre + "\n";
        return string;
    }

    public void write(AbstractMP3Tag abstractMP3Tag) {
        ID3v1 iD3v1 = this;
        if (abstractMP3Tag != null) {
            ID3v1 iD3v12 = abstractMP3Tag instanceof ID3v1 ? (ID3v1)abstractMP3Tag : new ID3v1_1(abstractMP3Tag);
            iD3v1.title = iD3v12.title;
            iD3v1.artist = iD3v12.artist;
            iD3v1.album = iD3v12.album;
            iD3v1.year = iD3v12.year;
            iD3v1.comment = iD3v12.comment;
            iD3v1.genre = iD3v12.genre;
        }
    }

    public void write(RandomAccessFile randomAccessFile) throws IOException {
        int n;
        String string;
        byte[] byArray = new byte[128];
        int n2 = 3;
        this.delete(randomAccessFile);
        randomAccessFile.seek(randomAccessFile.length());
        byArray[0] = 84;
        byArray[1] = 65;
        byArray[2] = 71;
        if (TagOptionSingleton.getInstance().isId3v1SaveTitle()) {
            string = TagUtility.truncate(this.title, 30);
            for (n = 0; n < string.length(); ++n) {
                byArray[n + n2] = (byte)string.charAt(n);
            }
        }
        n2 += 30;
        if (TagOptionSingleton.getInstance().isId3v1SaveArtist()) {
            string = TagUtility.truncate(this.artist, 30);
            for (n = 0; n < string.length(); ++n) {
                byArray[n + n2] = (byte)string.charAt(n);
            }
        }
        n2 += 30;
        if (TagOptionSingleton.getInstance().isId3v1SaveAlbum()) {
            string = TagUtility.truncate(this.album, 30);
            for (n = 0; n < string.length(); ++n) {
                byArray[n + n2] = (byte)string.charAt(n);
            }
        }
        n2 += 30;
        if (TagOptionSingleton.getInstance().isId3v1SaveYear()) {
            string = TagUtility.truncate(this.year, 4);
            for (n = 0; n < string.length(); ++n) {
                byArray[n + n2] = (byte)string.charAt(n);
            }
        }
        n2 += 4;
        if (TagOptionSingleton.getInstance().isId3v1SaveComment()) {
            string = TagUtility.truncate(this.comment, 30);
            for (n = 0; n < string.length(); ++n) {
                byArray[n + n2] = (byte)string.charAt(n);
            }
        }
        n2 += 30;
        if (TagOptionSingleton.getInstance().isId3v1SaveGenre()) {
            byArray[n2] = this.genre;
        }
        randomAccessFile.write(byArray);
    }

    public String getSongTitle() {
        return this.getTitle().trim();
    }

    public String getLeadArtist() {
        return this.getArtist().trim();
    }

    public String getAlbumTitle() {
        return this.getAlbum().trim();
    }

    public String getYearReleased() {
        return this.getYear().trim();
    }

    public String getSongComment() {
        return this.getComment().trim();
    }

    public String getSongGenre() {
        return Integer.toString(this.getGenre());
    }

    public String getTrackNumberOnAlbum() {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public String getSongLyric() {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public String getAuthorComposer() {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public void setSongTitle(String string) {
        this.setTitle(string.trim());
    }

    public void setLeadArtist(String string) {
        this.setArtist(string.trim());
    }

    public void setAlbumTitle(String string) {
        this.setAlbum(string.trim());
    }

    public void setYearReleased(String string) {
        this.setYear(string.trim());
    }

    public void setSongComment(String string) {
        this.setComment(string.trim());
    }

    public void setSongGenre(String string) {
        this.setGenre(Byte.parseByte(string.trim()));
    }

    public void setTrackNumberOnAlbum(String string) {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public void setSongLyric(String string) {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public void setAuthorComposer(String string) {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }
}

