/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.farng.mp3.id3.ID3v1;
import org.farng.mp3.id3.ID3v1_1;

public class ID3v1Iterator
implements Iterator {
    private static final int TITLE = 1;
    private static final int ARTIST = 2;
    private static final int ALBUM = 3;
    private static final int COMMENT = 4;
    private static final int YEAR = 5;
    private static final int GENRE = 6;
    private static final int TRACK = 7;
    private ID3v1 id3v1tag;
    private int lastIndex = 0;

    public ID3v1Iterator(ID3v1 iD3v1) {
        this.id3v1tag = iD3v1;
    }

    public boolean hasNext() {
        return this.hasNext(this.lastIndex);
    }

    public Object next() {
        return this.next(this.lastIndex);
    }

    public void remove() {
        switch (this.lastIndex) {
            case 1: {
                this.id3v1tag.title = "";
            }
            case 2: {
                this.id3v1tag.artist = "";
            }
            case 3: {
                this.id3v1tag.album = "";
            }
            case 4: {
                this.id3v1tag.comment = "";
            }
            case 5: {
                this.id3v1tag.year = "";
            }
            case 6: {
                this.id3v1tag.genre = (byte)-1;
            }
            case 7: {
                if (!(this.id3v1tag instanceof ID3v1_1)) break;
                ((ID3v1_1)this.id3v1tag).track = (byte)-1;
            }
        }
    }

    private boolean hasNext(int n) {
        switch (n) {
            case 1: {
                return this.id3v1tag.title.length() > 0 || this.hasNext(n + 1);
            }
            case 2: {
                return this.id3v1tag.artist.length() > 0 || this.hasNext(n + 1);
            }
            case 3: {
                return this.id3v1tag.album.length() > 0 || this.hasNext(n + 1);
            }
            case 4: {
                return this.id3v1tag.comment.length() > 0 || this.hasNext(n + 1);
            }
            case 5: {
                return this.id3v1tag.year.length() > 0 || this.hasNext(n + 1);
            }
            case 6: {
                return this.id3v1tag.genre >= 0 || this.hasNext(n + 1);
            }
            case 7: {
                if (!(this.id3v1tag instanceof ID3v1_1)) break;
                return ((ID3v1_1)this.id3v1tag).track >= 0 || this.hasNext(n + 1);
            }
        }
        return false;
    }

    private Object next(int n) {
        switch (this.lastIndex) {
            case 0: {
                return this.id3v1tag.title.length() > 0 ? this.id3v1tag.title : this.next(n + 1);
            }
            case 1: {
                return this.id3v1tag.artist.length() > 0 ? this.id3v1tag.artist : this.next(n + 1);
            }
            case 2: {
                return this.id3v1tag.album.length() > 0 ? this.id3v1tag.album : this.next(n + 1);
            }
            case 3: {
                return this.id3v1tag.comment.length() > 0 ? this.id3v1tag.comment : this.next(n + 1);
            }
            case 4: {
                return this.id3v1tag.year.length() > 0 ? this.id3v1tag.year : this.next(n + 1);
            }
            case 5: {
                return this.id3v1tag.genre >= 0 ? new Byte(this.id3v1tag.genre) : this.next(n + 1);
            }
            case 6: {
                return this.id3v1tag instanceof ID3v1_1 && ((ID3v1_1)this.id3v1tag).track >= 0 ? new Byte(((ID3v1_1)this.id3v1tag).track) : null;
            }
        }
        throw new NoSuchElementException("Iteration has no more elements.");
    }
}

