/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import org.farng.mp3.AbstractMP3Tag;
import org.farng.mp3.TagException;
import org.farng.mp3.TagNotFoundException;
import org.farng.mp3.TagOptionSingleton;
import org.farng.mp3.TagUtility;
import org.farng.mp3.id3.FrameBodyCOMM;
import org.farng.mp3.id3.FrameBodyTALB;
import org.farng.mp3.id3.FrameBodyTCON;
import org.farng.mp3.id3.FrameBodyTDRC;
import org.farng.mp3.id3.FrameBodyTIT2;
import org.farng.mp3.id3.FrameBodyTPE1;
import org.farng.mp3.id3.FrameBodyTRCK;
import org.farng.mp3.id3.ID3v1;
import org.farng.mp3.id3.ID3v2_4;
import org.farng.mp3.id3.ID3v2_4Frame;
import org.farng.mp3.lyrics3.AbstractLyrics3;

public class ID3v1_1
extends ID3v1 {
    protected byte track = (byte)-1;

    public ID3v1_1() {
    }

    public ID3v1_1(ID3v1_1 iD3v1_1) {
        super(iD3v1_1);
        this.track = iD3v1_1.track;
    }

    public ID3v1_1(AbstractMP3Tag abstractMP3Tag) {
        if (abstractMP3Tag != null) {
            if (abstractMP3Tag instanceof ID3v1) {
                if (abstractMP3Tag instanceof ID3v1_1) {
                    throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
                }
                ID3v1 iD3v1 = (ID3v1)abstractMP3Tag;
                this.title = new String(iD3v1.title.trim());
                this.artist = new String(iD3v1.artist.trim());
                this.album = new String(iD3v1.album.trim());
                this.comment = new String(iD3v1.comment.trim());
                this.year = new String(iD3v1.year.trim());
                this.genre = iD3v1.genre;
            } else {
                String string;
                ID3v2_4Frame iD3v2_4Frame;
                ID3v2_4 iD3v2_4 = new ID3v2_4(abstractMP3Tag);
                if (iD3v2_4.hasFrame("TIT2")) {
                    iD3v2_4Frame = (ID3v2_4Frame)iD3v2_4.getFrame("TIT2");
                    string = ((FrameBodyTIT2)iD3v2_4Frame.getBody()).getText();
                    this.title = TagUtility.truncate(string, 30);
                }
                if (iD3v2_4.hasFrame("TPE1")) {
                    iD3v2_4Frame = (ID3v2_4Frame)iD3v2_4.getFrame("TPE1");
                    string = ((FrameBodyTPE1)iD3v2_4Frame.getBody()).getText();
                    this.artist = TagUtility.truncate(string, 30);
                }
                if (iD3v2_4.hasFrame("TALB")) {
                    iD3v2_4Frame = (ID3v2_4Frame)iD3v2_4.getFrame("TALB");
                    string = ((FrameBodyTALB)iD3v2_4Frame.getBody()).getText();
                    this.album = TagUtility.truncate(string, 30);
                }
                if (iD3v2_4.hasFrame("TDRC")) {
                    iD3v2_4Frame = (ID3v2_4Frame)iD3v2_4.getFrame("TDRC");
                    string = ((FrameBodyTDRC)iD3v2_4Frame.getBody()).getText();
                    this.year = TagUtility.truncate(string, 4);
                }
                if (iD3v2_4.hasFrameOfType("COMM")) {
                    Iterator iterator = iD3v2_4.getFrameOfType("COMM");
                    string = "";
                    while (iterator.hasNext()) {
                        iD3v2_4Frame = (ID3v2_4Frame)iterator.next();
                        string = string + ((FrameBodyCOMM)iD3v2_4Frame.getBody()).getText() + " ";
                    }
                    this.comment = TagUtility.truncate(string, 28);
                }
                if (iD3v2_4.hasFrame("TCON")) {
                    iD3v2_4Frame = (ID3v2_4Frame)iD3v2_4.getFrame("TCON");
                    string = ((FrameBodyTCON)iD3v2_4Frame.getBody()).getText();
                    try {
                        this.genre = (byte)TagUtility.findNumber(string);
                    }
                    catch (TagException tagException) {
                        this.genre = 0;
                    }
                }
                if (iD3v2_4.hasFrame("TRCK")) {
                    iD3v2_4Frame = (ID3v2_4Frame)iD3v2_4.getFrame("TRCK");
                    string = ((FrameBodyTRCK)iD3v2_4Frame.getBody()).getText();
                    try {
                        this.track = (byte)TagUtility.findNumber(string);
                    }
                    catch (TagException tagException) {
                        this.track = 0;
                    }
                }
            }
        }
    }

    public ID3v1_1(RandomAccessFile randomAccessFile) throws TagNotFoundException, IOException {
        this.read(randomAccessFile);
    }

    public void setComment(String string) {
        this.comment = TagUtility.truncate(string, 28);
    }

    public String getComment() {
        return this.comment;
    }

    public String getIdentifier() {
        return "ID3v1_1.10";
    }

    public void setTrack(byte by) {
        this.track = by;
    }

    public byte getTrack() {
        return this.track;
    }

    public void append(AbstractMP3Tag abstractMP3Tag) {
        ID3v1_1 iD3v1_1 = this;
        if (abstractMP3Tag != null) {
            ID3v1_1 iD3v1_12 = abstractMP3Tag instanceof ID3v1_1 ? (ID3v1_1)abstractMP3Tag : new ID3v1_1(abstractMP3Tag);
            if (abstractMP3Tag instanceof AbstractLyrics3) {
                TagOptionSingleton.getInstance().setId3v1SaveTrack(false);
            }
            iD3v1_1.track = TagOptionSingleton.getInstance().isId3v1SaveTrack() && iD3v1_1.track <= 0 ? iD3v1_12.track : iD3v1_1.track;
        }
        super.append(abstractMP3Tag);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ID3v1_1)) {
            return false;
        }
        ID3v1_1 iD3v1_1 = (ID3v1_1)object;
        if (this.track != iD3v1_1.track) {
            return false;
        }
        return super.equals(object);
    }

    public void overwrite(AbstractMP3Tag abstractMP3Tag) {
        ID3v1_1 iD3v1_1 = this;
        ID3v1_1 iD3v1_12 = null;
        if (abstractMP3Tag != null) {
            iD3v1_12 = abstractMP3Tag instanceof ID3v1_1 ? (ID3v1_1)abstractMP3Tag : new ID3v1_1(abstractMP3Tag);
            if (abstractMP3Tag instanceof AbstractLyrics3) {
                TagOptionSingleton.getInstance().setId3v1SaveTrack(false);
            }
            iD3v1_1.track = TagOptionSingleton.getInstance().isId3v1SaveTrack() ? iD3v1_12.track : iD3v1_1.track;
        }
        super.overwrite(iD3v1_12);
    }

    public void read(RandomAccessFile randomAccessFile) throws TagNotFoundException, IOException {
        byte[] byArray = new byte[30];
        if (!this.seek(randomAccessFile)) {
            throw new TagNotFoundException("ID3v1.1 tag not found");
        }
        randomAccessFile.read(byArray, 0, 30);
        this.title = new String(byArray, 0, 30, "ISO-8859-1").trim();
        randomAccessFile.read(byArray, 0, 30);
        this.artist = new String(byArray, 0, 30, "ISO-8859-1").trim();
        randomAccessFile.read(byArray, 0, 30);
        this.album = new String(byArray, 0, 30, "ISO-8859-1").trim();
        randomAccessFile.read(byArray, 0, 4);
        this.year = new String(byArray, 0, 4, "ISO-8859-1").trim();
        randomAccessFile.read(byArray, 0, 28);
        this.comment = new String(byArray, 0, 28, "ISO-8859-1").trim();
        randomAccessFile.read(byArray, 0, 2);
        if (byArray[0] != 0) {
            throw new TagNotFoundException("ID3v1.1 Tag Not found");
        }
        this.track = byArray[1];
        randomAccessFile.read(byArray, 0, 1);
        this.genre = byArray[0];
    }

    public boolean seek(RandomAccessFile randomAccessFile) throws IOException {
        byte[] byArray = new byte[3];
        if (randomAccessFile.length() < 128L) {
            return false;
        }
        randomAccessFile.seek(randomAccessFile.length() - 3L);
        byArray[0] = randomAccessFile.readByte();
        if (byArray[0] != 0) {
            return false;
        }
        randomAccessFile.seek(randomAccessFile.length() - 128L);
        randomAccessFile.read(byArray, 0, 3);
        String string = new String(byArray, 0, 3);
        return string.equals("TAG");
    }

    public String toString() {
        String string = this.getIdentifier() + " " + this.getSize() + "\n";
        string = string + "Title = " + this.title + "\n";
        string = string + "Artist = " + this.artist + "\n";
        string = string + "Album = " + this.album + "\n";
        string = string + "Comment = " + this.comment + "\n";
        string = string + "Year = " + this.year + "\n";
        string = string + "Genre = " + this.genre + "\n";
        string = string + "Track = " + this.track + "\n";
        return string;
    }

    public void write(AbstractMP3Tag abstractMP3Tag) {
        ID3v1_1 iD3v1_1 = this;
        ID3v1_1 iD3v1_12 = null;
        if (abstractMP3Tag != null) {
            iD3v1_12 = abstractMP3Tag instanceof ID3v1_1 ? (ID3v1_1)abstractMP3Tag : new ID3v1_1(abstractMP3Tag);
            iD3v1_1.track = iD3v1_12.track;
        }
        super.write(iD3v1_12);
    }

    public void write(RandomAccessFile randomAccessFile) throws IOException {
        int n;
        byte[] byArray = new byte[128];
        int n2 = 3;
        this.delete(randomAccessFile);
        randomAccessFile.seek(randomAccessFile.length());
        byArray[0] = 84;
        byArray[1] = 65;
        byArray[2] = 71;
        String string = TagUtility.truncate(this.title, 30);
        for (n = 0; n < string.length(); ++n) {
            byArray[n + n2] = (byte)string.charAt(n);
        }
        n2 += 30;
        string = TagUtility.truncate(this.artist, 30);
        for (n = 0; n < string.length(); ++n) {
            byArray[n + n2] = (byte)string.charAt(n);
        }
        n2 += 30;
        string = TagUtility.truncate(this.album, 30);
        for (n = 0; n < string.length(); ++n) {
            byArray[n + n2] = (byte)string.charAt(n);
        }
        n2 += 30;
        string = TagUtility.truncate(this.year, 4);
        for (n = 0; n < string.length(); ++n) {
            byArray[n + n2] = (byte)string.charAt(n);
        }
        n2 += 4;
        string = TagUtility.truncate(this.comment, 28);
        for (n = 0; n < string.length(); ++n) {
            byArray[n + n2] = (byte)string.charAt(n);
        }
        n2 += 28;
        byArray[++n2] = this.track;
        byArray[++n2] = this.genre;
        randomAccessFile.write(byArray);
    }

    public String getTrackNumberOnAlbum() {
        return Integer.toString(this.getTrack());
    }

    public void setTrackNumberOnAlbum(String string) {
        this.setTrack(Byte.parseByte(string.trim()));
    }
}

