/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import org.farng.mp3.AbstractMP3Tag;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.MP3File;
import org.farng.mp3.TagException;
import org.farng.mp3.TagNotFoundException;
import org.farng.mp3.id3.AbstractID3v2;
import org.farng.mp3.id3.AbstractID3v2Frame;
import org.farng.mp3.id3.AbstractID3v2FrameBody;
import org.farng.mp3.id3.FrameBodyCOMM;
import org.farng.mp3.id3.FrameBodySYLT;
import org.farng.mp3.id3.FrameBodyTALB;
import org.farng.mp3.id3.FrameBodyTCOM;
import org.farng.mp3.id3.FrameBodyTCON;
import org.farng.mp3.id3.FrameBodyTIT2;
import org.farng.mp3.id3.FrameBodyTPE1;
import org.farng.mp3.id3.FrameBodyTRCK;
import org.farng.mp3.id3.FrameBodyTYER;
import org.farng.mp3.id3.FrameBodyUSLT;
import org.farng.mp3.id3.ID3v2_2;
import org.farng.mp3.id3.ID3v2_3Frame;
import org.farng.mp3.id3.ID3v2_4;

public class ID3v2_3
extends ID3v2_2 {
    protected boolean crcDataFlag = false;
    protected boolean experimental = false;
    protected boolean extended = false;
    protected int crcData = 0;
    protected int paddingSize = 0;

    public ID3v2_3() {
        this.setMajorVersion((byte)2);
        this.setRevision((byte)3);
    }

    public ID3v2_3(ID3v2_3 iD3v2_3) {
        super(iD3v2_3);
        this.crcDataFlag = iD3v2_3.crcDataFlag;
        this.experimental = iD3v2_3.experimental;
        this.extended = iD3v2_3.extended;
        this.crcData = iD3v2_3.crcData;
        this.paddingSize = iD3v2_3.paddingSize;
    }

    public ID3v2_3(AbstractMP3Tag abstractMP3Tag) {
        if (abstractMP3Tag != null) {
            if (!(abstractMP3Tag instanceof ID3v2_4) && abstractMP3Tag instanceof ID3v2_3) {
                throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
            }
            ID3v2_4 iD3v2_4 = abstractMP3Tag instanceof ID3v2_4 ? (ID3v2_4)abstractMP3Tag : new ID3v2_4(abstractMP3Tag);
            this.extended = iD3v2_4.extended;
            this.experimental = iD3v2_4.experimental;
            this.crcDataFlag = iD3v2_4.crcDataFlag;
            this.crcData = iD3v2_4.crcData;
            this.paddingSize = iD3v2_4.paddingSize;
            this.compression = iD3v2_4.compression;
            this.unsynchronization = iD3v2_4.unsynchronization;
            ID3v2_4 iD3v2_42 = iD3v2_4;
            Iterator iterator = iD3v2_42.getFrameIterator();
            while (iterator.hasNext()) {
                AbstractID3v2Frame abstractID3v2Frame = (AbstractID3v2Frame)iterator.next();
                ID3v2_3Frame iD3v2_3Frame = new ID3v2_3Frame(abstractID3v2Frame);
                this.setFrame(iD3v2_3Frame);
            }
        }
    }

    public ID3v2_3(RandomAccessFile randomAccessFile) throws TagException, IOException {
        this.read(randomAccessFile);
    }

    public String getIdentifier() {
        return "ID3v2.30";
    }

    public int getSize() {
        int n = 10;
        if (this.extended) {
            n = this.crcDataFlag ? (n += 14) : (n += 10);
        }
        Iterator iterator = this.getFrameIterator();
        while (iterator.hasNext()) {
            AbstractID3v2Frame abstractID3v2Frame = (AbstractID3v2Frame)iterator.next();
            n += abstractID3v2Frame.getSize();
        }
        return n;
    }

    public void append(AbstractMP3Tag abstractMP3Tag) {
        if (abstractMP3Tag instanceof ID3v2_3) {
            this.experimental = ((ID3v2_3)abstractMP3Tag).experimental;
            this.extended = ((ID3v2_3)abstractMP3Tag).extended;
            this.crcDataFlag = ((ID3v2_3)abstractMP3Tag).crcDataFlag;
            this.paddingSize = ((ID3v2_3)abstractMP3Tag).paddingSize;
            this.crcData = ((ID3v2_3)abstractMP3Tag).crcData;
        }
        super.append(abstractMP3Tag);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ID3v2_3)) {
            return false;
        }
        ID3v2_3 iD3v2_3 = (ID3v2_3)object;
        if (this.crcData != iD3v2_3.crcData) {
            return false;
        }
        if (this.crcDataFlag != iD3v2_3.crcDataFlag) {
            return false;
        }
        if (this.experimental != iD3v2_3.experimental) {
            return false;
        }
        if (this.extended != iD3v2_3.extended) {
            return false;
        }
        if (this.paddingSize != iD3v2_3.paddingSize) {
            return false;
        }
        return super.equals(object);
    }

    public void overwrite(AbstractMP3Tag abstractMP3Tag) {
        if (abstractMP3Tag instanceof ID3v2_3) {
            this.experimental = ((ID3v2_3)abstractMP3Tag).experimental;
            this.extended = ((ID3v2_3)abstractMP3Tag).extended;
            this.crcDataFlag = ((ID3v2_3)abstractMP3Tag).crcDataFlag;
            this.paddingSize = ((ID3v2_3)abstractMP3Tag).paddingSize;
            this.crcData = ((ID3v2_3)abstractMP3Tag).crcData;
        }
        super.overwrite(abstractMP3Tag);
    }

    public void read(RandomAccessFile randomAccessFile) throws TagException, IOException {
        byte[] byArray = new byte[4];
        if (!this.seek(randomAccessFile)) {
            throw new TagNotFoundException(this.getIdentifier() + " tag not found");
        }
        randomAccessFile.read(byArray, 0, 3);
        if (byArray[0] != 3 || byArray[1] != 0) {
            throw new TagNotFoundException(this.getIdentifier() + " tag not found");
        }
        this.setMajorVersion(byArray[0]);
        this.setRevision(byArray[1]);
        this.unsynchronization = (byArray[2] & 0x80) != 0;
        this.extended = (byArray[2] & 0x40) != 0;
        this.experimental = (byArray[2] & 0x20) != 0;
        randomAccessFile.read(byArray, 0, 4);
        int n = ID3v2_3.byteArrayToSize(byArray);
        long l = randomAccessFile.getFilePointer();
        if (this.extended) {
            int n2 = randomAccessFile.readInt();
            if (n2 != 6 && n2 != 10) {
                throw new InvalidTagException("Invalid Extended Header Size.");
            }
            randomAccessFile.read(byArray, 0, 2);
            boolean bl = this.crcDataFlag = (byArray[0] & 0x80) != 0;
            if (n2 == 10 && !this.crcDataFlag || n2 == 6 && this.crcDataFlag) {
                throw new InvalidTagException("CRC Data flag not set correctly.");
            }
            this.paddingSize = randomAccessFile.readInt();
            if (n2 == 10 && this.crcDataFlag) {
                this.crcData = randomAccessFile.readInt();
            }
        }
        this.clearFrameMap();
        this.setFileReadBytes(n);
        AbstractID3v2.resetPaddingCounter();
        while (randomAccessFile.getFilePointer() - l <= (long)n) {
            try {
                ID3v2_3Frame iD3v2_3Frame = new ID3v2_3Frame(randomAccessFile);
                String string = iD3v2_3Frame.getIdentifier();
                if (this.hasFrame(string)) {
                    this.appendDuplicateFrameId(string + "; ");
                    this.incrementDuplicateBytes(this.getFrame(string).getSize());
                }
                this.setFrame(iD3v2_3Frame);
            }
            catch (InvalidTagException invalidTagException) {
                if (invalidTagException.getMessage().equals("Found empty frame")) {
                    this.incrementEmptyFrameBytes(10);
                    continue;
                }
                this.incrementInvalidFrameBytes();
            }
        }
        this.setPaddingSize(ID3v2_3.getPaddingCounter());
    }

    public boolean seek(RandomAccessFile randomAccessFile) throws IOException {
        byte[] byArray = new byte[3];
        randomAccessFile.seek(0L);
        randomAccessFile.read(byArray, 0, 3);
        String string = new String(byArray, 0, 3);
        if (!string.equals("ID3")) {
            return false;
        }
        randomAccessFile.read(byArray, 0, 2);
        randomAccessFile.seek(randomAccessFile.getFilePointer() - 2L);
        return byArray[0] == 3 && byArray[1] == 0;
    }

    public String toString() {
        Iterator iterator = this.getFrameIterator();
        String string = this.getIdentifier() + " " + this.getSize() + "\n";
        string = string + "compression        = " + this.compression + "\n";
        string = string + "unsynchronization  = " + this.unsynchronization + "\n";
        string = string + "crcData            = " + this.crcData + "\n";
        string = string + "crcDataFlag        = " + this.crcDataFlag + "\n";
        string = string + "experimental       = " + this.experimental + "\n";
        string = string + "extended           = " + this.extended + "\n";
        string = string + "paddingSize        = " + this.paddingSize + "\n";
        while (iterator.hasNext()) {
            ID3v2_3Frame iD3v2_3Frame = (ID3v2_3Frame)iterator.next();
            string = string + iD3v2_3Frame.toString() + "\n";
        }
        return string + "\n";
    }

    public void write(AbstractMP3Tag abstractMP3Tag) {
        if (abstractMP3Tag instanceof ID3v2_3) {
            this.experimental = ((ID3v2_3)abstractMP3Tag).experimental;
            this.extended = ((ID3v2_3)abstractMP3Tag).extended;
            this.crcDataFlag = ((ID3v2_3)abstractMP3Tag).crcDataFlag;
            this.paddingSize = ((ID3v2_3)abstractMP3Tag).paddingSize;
            this.crcData = ((ID3v2_3)abstractMP3Tag).crcData;
        }
        super.write(abstractMP3Tag);
    }

    public void write(RandomAccessFile randomAccessFile) throws IOException {
        byte[] byArray = new byte[6];
        MP3File mP3File = new MP3File();
        mP3File.seekMP3Frame(randomAccessFile);
        long l = randomAccessFile.getFilePointer();
        randomAccessFile.seek(0L);
        String string = "ID3";
        for (int i = 0; i < string.length(); ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        byArray[3] = 3;
        byArray[4] = 0;
        if (this.unsynchronization) {
            byArray[5] = (byte)(byArray[5] | 0x80);
        }
        if (this.extended) {
            byArray[5] = (byte)(byArray[5] | 0x40);
        }
        if (this.experimental) {
            byArray[5] = (byte)(byArray[5] | 0x20);
        }
        randomAccessFile.write(byArray);
        randomAccessFile.write(ID3v2_3.sizeToByteArray((int)l - 10));
        if (this.extended) {
            if (this.crcDataFlag) {
                randomAccessFile.writeInt(10);
                byArray[0] = 0;
                byArray[0] = (byte)(byArray[0] | 0x80);
                randomAccessFile.write(byArray, 0, 2);
                randomAccessFile.writeInt(this.paddingSize);
                randomAccessFile.writeInt(this.crcData);
            } else {
                randomAccessFile.writeInt(6);
                randomAccessFile.write(byArray, 0, 2);
                randomAccessFile.writeInt(this.paddingSize);
            }
        }
        Iterator iterator = this.getFrameIterator();
        while (iterator.hasNext()) {
            ID3v2_3Frame iD3v2_3Frame = (ID3v2_3Frame)iterator.next();
            iD3v2_3Frame.write(randomAccessFile);
        }
    }

    public String getSongTitle() {
        String string = "";
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("TIT2");
        if (abstractID3v2Frame != null) {
            FrameBodyTIT2 frameBodyTIT2 = (FrameBodyTIT2)abstractID3v2Frame.getBody();
            string = frameBodyTIT2.getText();
        }
        return string.trim();
    }

    public String getLeadArtist() {
        String string = "";
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("TPE1");
        if (abstractID3v2Frame != null) {
            FrameBodyTPE1 frameBodyTPE1 = (FrameBodyTPE1)abstractID3v2Frame.getBody();
            string = frameBodyTPE1.getText();
        }
        return string.trim();
    }

    public String getAlbumTitle() {
        String string = "";
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("TALB");
        if (abstractID3v2Frame != null) {
            FrameBodyTALB frameBodyTALB = (FrameBodyTALB)abstractID3v2Frame.getBody();
            string = frameBodyTALB.getText();
        }
        return string.trim();
    }

    public String getYearReleased() {
        String string = "";
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("TYER");
        if (abstractID3v2Frame != null) {
            FrameBodyTYER frameBodyTYER = (FrameBodyTYER)abstractID3v2Frame.getBody();
            string = frameBodyTYER.getText();
        }
        return string.trim();
    }

    public String getSongComment() {
        String string = "";
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("COMM\u0000eng\u0000");
        if (abstractID3v2Frame != null) {
            FrameBodyCOMM frameBodyCOMM = (FrameBodyCOMM)abstractID3v2Frame.getBody();
            string = frameBodyCOMM.getText();
        }
        return string.trim();
    }

    public String getSongGenre() {
        String string = "";
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("TCON");
        if (abstractID3v2Frame != null) {
            FrameBodyTCON frameBodyTCON = (FrameBodyTCON)abstractID3v2Frame.getBody();
            string = frameBodyTCON.getText();
        }
        return string.trim();
    }

    public String getTrackNumberOnAlbum() {
        String string = "";
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("TRCK");
        if (abstractID3v2Frame != null) {
            FrameBodyTRCK frameBodyTRCK = (FrameBodyTRCK)abstractID3v2Frame.getBody();
            string = frameBodyTRCK.getText();
        }
        return string.trim();
    }

    public String getSongLyric() {
        AbstractID3v2FrameBody abstractID3v2FrameBody;
        String string = "";
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("SYLT");
        if (abstractID3v2Frame != null) {
            abstractID3v2FrameBody = (FrameBodySYLT)abstractID3v2Frame.getBody();
            string = ((FrameBodySYLT)abstractID3v2FrameBody).getLyric();
        }
        if (string == "" && (abstractID3v2Frame = this.getFrame("USLT\u0000eng\u0000")) != null) {
            abstractID3v2FrameBody = (FrameBodyUSLT)abstractID3v2Frame.getBody();
            string = ((FrameBodyUSLT)abstractID3v2FrameBody).getLyric();
        }
        return string.trim();
    }

    public String getAuthorComposer() {
        String string = "";
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("TCOM");
        if (abstractID3v2Frame != null) {
            FrameBodyTCOM frameBodyTCOM = (FrameBodyTCOM)abstractID3v2Frame.getBody();
            string = frameBodyTCOM.getText();
        }
        return string.trim();
    }

    public void setSongTitle(String string) {
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("TIT2");
        if (abstractID3v2Frame == null) {
            abstractID3v2Frame = new ID3v2_3Frame(new FrameBodyTIT2(0, string.trim()));
            this.setFrame(abstractID3v2Frame);
        } else {
            ((FrameBodyTIT2)abstractID3v2Frame.getBody()).setText(string.trim());
        }
    }

    public void setLeadArtist(String string) {
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("TPE1");
        if (abstractID3v2Frame == null) {
            abstractID3v2Frame = new ID3v2_3Frame(new FrameBodyTPE1(0, string.trim()));
            this.setFrame(abstractID3v2Frame);
        } else {
            ((FrameBodyTPE1)abstractID3v2Frame.getBody()).setText(string.trim());
        }
    }

    public void setAlbumTitle(String string) {
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("TALB");
        if (abstractID3v2Frame == null) {
            abstractID3v2Frame = new ID3v2_3Frame(new FrameBodyTALB(0, string.trim()));
            this.setFrame(abstractID3v2Frame);
        } else {
            ((FrameBodyTALB)abstractID3v2Frame.getBody()).setText(string.trim());
        }
    }

    public void setYearReleased(String string) {
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("TYER");
        if (abstractID3v2Frame == null) {
            abstractID3v2Frame = new ID3v2_3Frame(new FrameBodyTYER(0, string.trim()));
            this.setFrame(abstractID3v2Frame);
        } else {
            ((FrameBodyTYER)abstractID3v2Frame.getBody()).setText(string.trim());
        }
    }

    public void setSongComment(String string) {
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("COMM");
        if (abstractID3v2Frame == null) {
            abstractID3v2Frame = new ID3v2_3Frame(new FrameBodyCOMM(0, "ENG", "", string.trim()));
            this.setFrame(abstractID3v2Frame);
        } else {
            ((FrameBodyCOMM)abstractID3v2Frame.getBody()).setText(string.trim());
        }
    }

    public void setSongGenre(String string) {
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("TCON");
        if (abstractID3v2Frame == null) {
            abstractID3v2Frame = new ID3v2_3Frame(new FrameBodyTCON(0, string.trim()));
            this.setFrame(abstractID3v2Frame);
        } else {
            ((FrameBodyTCON)abstractID3v2Frame.getBody()).setText(string.trim());
        }
    }

    public void setTrackNumberOnAlbum(String string) {
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("TRCK");
        if (abstractID3v2Frame == null) {
            abstractID3v2Frame = new ID3v2_3Frame(new FrameBodyTRCK(0, string.trim()));
            this.setFrame(abstractID3v2Frame);
        } else {
            ((FrameBodyTRCK)abstractID3v2Frame.getBody()).setText(string.trim());
        }
    }

    public void setSongLyric(String string) {
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("SYLT");
        if (abstractID3v2Frame == null) {
            abstractID3v2Frame = new ID3v2_3Frame(new FrameBodyUSLT(0, "ENG", "", string.trim()));
            this.setFrame(abstractID3v2Frame);
        } else {
            ((FrameBodyUSLT)abstractID3v2Frame.getBody()).setLyric(string.trim());
        }
    }

    public void setAuthorComposer(String string) {
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("TCOM");
        if (abstractID3v2Frame == null) {
            abstractID3v2Frame = new ID3v2_3Frame(new FrameBodyTCOM(0, string.trim()));
            this.setFrame(abstractID3v2Frame);
        } else {
            ((FrameBodyTCOM)abstractID3v2Frame.getBody()).setText(string.trim());
        }
    }
}

