/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.object;

import org.farng.mp3.TagUtility;
import org.farng.mp3.object.AbstractMP3Object;

public class ObjectNumberFixedLength
extends AbstractMP3Object {
    int length = 0;

    public ObjectNumberFixedLength(String string, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Length is less than zero: " + this.length);
        }
        this.length = n;
        this.identifier = string;
    }

    public ObjectNumberFixedLength(ObjectNumberFixedLength objectNumberFixedLength) {
        super(objectNumberFixedLength);
        this.length = objectNumberFixedLength.length;
    }

    public int getLength() {
        return this.length;
    }

    public void setSize(int n) {
        if (n > 0) {
            this.length = n;
        }
    }

    public int getSize() {
        return this.length;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ObjectNumberFixedLength)) {
            return false;
        }
        ObjectNumberFixedLength objectNumberFixedLength = (ObjectNumberFixedLength)object;
        if (this.length != objectNumberFixedLength.length) {
            return false;
        }
        return super.equals(object);
    }

    public void readByteArray(byte[] byArray, int n) {
        if (byArray == null) {
            throw new NullPointerException("Byte array is null");
        }
        if (n < 0 || n >= byArray.length) {
            throw new IndexOutOfBoundsException("Offset to byte array is out of bounds: offset = " + n + ", array.length = " + byArray.length);
        }
        long l = 0L;
        for (int i = n; i < n + this.length; ++i) {
            l <<= 8;
            l += (long)byArray[i];
        }
        this.value = new Long(l);
    }

    public void readString(String string, int n) {
        if (string == null) {
            throw new NullPointerException("Number string is null");
        }
        if (n < 0 || n >= string.length()) {
            throw new IndexOutOfBoundsException("Offset to number string is out of bounds: offset = " + n + ", string.length()" + string.length());
        }
        this.value = Long.getLong(string.substring(n));
    }

    public String toString() {
        if (this.value == null) {
            return "";
        }
        return this.value.toString();
    }

    public byte[] writeByteArray() {
        byte[] byArray = new byte[this.length];
        if (this.value != null) {
            long l = TagUtility.getWholeNumber(this.value);
            for (int i = this.length - 1; i >= 0; --i) {
                byArray[i] = (byte)(l & 0xFFL);
                l >>= 8;
            }
        }
        return byArray;
    }

    public String writeString() {
        if (this.value == null) {
            return String.valueOf(new char[this.length]);
        }
        return this.value.toString();
    }
}

