/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.object;

import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import org.farng.mp3.TagConstant;
import org.farng.mp3.object.ObjectHashMapInterface;
import org.farng.mp3.object.ObjectStringFixedLength;

public class ObjectStringHashMap
extends ObjectStringFixedLength
implements ObjectHashMapInterface {
    public static final String LANGUAGE = "Language";
    HashMap idToString = null;
    HashMap stringToId = null;
    boolean hasEmptyValue = false;

    public ObjectStringHashMap(String string, int n) {
        super(string, n);
        if (!string.equals(LANGUAGE)) {
            throw new IllegalArgumentException("Hashmap identifier not defined in this class: " + string);
        }
        this.stringToId = TagConstant.languageStringToId;
        this.idToString = TagConstant.languageIdToString;
    }

    public ObjectStringHashMap(ObjectStringHashMap objectStringHashMap) {
        super(objectStringHashMap);
        this.hasEmptyValue = objectStringHashMap.hasEmptyValue;
        this.idToString = objectStringHashMap.idToString;
        this.stringToId = objectStringHashMap.stringToId;
    }

    public HashMap getIdToString() {
        return this.idToString;
    }

    public HashMap getStringToId() {
        return this.stringToId;
    }

    public void setValue(Object object) {
        this.value = object instanceof String ? ((String)object).toLowerCase() : object;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ObjectStringHashMap)) {
            return false;
        }
        ObjectStringHashMap objectStringHashMap = (ObjectStringHashMap)object;
        if (this.hasEmptyValue != objectStringHashMap.hasEmptyValue) {
            return false;
        }
        if (this.idToString == null ? objectStringHashMap.idToString != null : !this.idToString.equals(objectStringHashMap.idToString)) {
            return false;
        }
        if (this.idToString == null ? objectStringHashMap.idToString != null : !this.stringToId.equals(objectStringHashMap.stringToId)) {
            return false;
        }
        return super.equals(object);
    }

    public Iterator iterator() {
        if (this.idToString == null) {
            return null;
        }
        TreeSet treeSet = new TreeSet(this.idToString.values());
        if (this.hasEmptyValue) {
            treeSet.add("");
        }
        return treeSet.iterator();
    }

    public String toString() {
        if (this.value == null) {
            return "";
        }
        if (this.idToString.get(this.value) == null) {
            return "";
        }
        return this.idToString.get(this.value).toString();
    }
}

