/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.DefaultPageCreator;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.util.EncodingSniffer;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebResponse
implements Serializable {
    private static final Log LOG = LogFactory.getLog(WebResponse.class);
    private static final ByteOrderMark[] BOM_HEADERS = new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_16BE};
    private long loadTime_;
    private WebResponseData responseData_;
    private WebRequest request_;

    public WebResponse(WebResponseData responseData, URL url, HttpMethod requestMethod, long loadTime) {
        this(responseData, new WebRequest(url, requestMethod), loadTime);
    }

    public WebResponse(WebResponseData responseData, WebRequest request, long loadTime) {
        this.responseData_ = responseData;
        this.request_ = request;
        this.loadTime_ = loadTime;
    }

    public WebRequest getWebRequest() {
        return this.request_;
    }

    public List<NameValuePair> getResponseHeaders() {
        return this.responseData_.getResponseHeaders();
    }

    public String getResponseHeaderValue(String headerName) {
        for (NameValuePair pair : this.responseData_.getResponseHeaders()) {
            if (!pair.getName().equalsIgnoreCase(headerName)) continue;
            return pair.getValue();
        }
        return null;
    }

    public int getStatusCode() {
        return this.responseData_.getStatusCode();
    }

    public String getStatusMessage() {
        return this.responseData_.getStatusMessage();
    }

    public String getContentType() {
        String contentTypeHeader = this.getResponseHeaderValue("content-type");
        if (contentTypeHeader == null) {
            return "";
        }
        int index = contentTypeHeader.indexOf(59);
        if (index == -1) {
            return contentTypeHeader;
        }
        return contentTypeHeader.substring(0, index);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Charset getContentCharsetOrNull() {
        try (InputStream is = this.getContentAsStream();){
            Charset charset = EncodingSniffer.sniffEncoding(this.getResponseHeaders(), is);
            return charset;
        }
        catch (IOException e) {
            LOG.warn((Object)"Error trying to sniff encoding.", (Throwable)e);
            return null;
        }
    }

    public Charset getContentCharset() {
        Charset charset = this.getContentCharsetOrNull();
        if (charset == null) {
            String contentType = this.getContentType();
            if (null != contentType && DefaultPageCreator.PageType.XML == DefaultPageCreator.determinePageType(contentType)) {
                return StandardCharsets.UTF_8;
            }
            charset = this.getWebRequest().getCharset();
        }
        if (charset == null) {
            charset = StandardCharsets.ISO_8859_1;
        }
        return charset;
    }

    public String getContentAsString() {
        return this.getContentAsString(this.getContentCharset());
    }

    public String getContentAsString(Charset encoding) {
        return this.getContentAsString(encoding, false);
    }

    /*
     * Exception decompiling
     */
    public String getContentAsString(Charset encoding, boolean ignoreUtf8Bom) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public long getContentLength() {
        if (this.responseData_ == null) {
            return 0L;
        }
        return this.responseData_.getContentLength();
    }

    public InputStream getContentAsStream() throws IOException {
        return this.responseData_.getInputStream();
    }

    public long getLoadTime() {
        return this.loadTime_;
    }

    public void cleanUp() {
        if (this.responseData_ != null) {
            this.responseData_.cleanUp();
        }
    }
}

