/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.AbstractJavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleSheet;
import com.gargoylesoftware.htmlunit.javascript.host.css.StyleSheetList;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLLinkElement;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HtmlLink
extends HtmlElement {
    private static final Log LOG = LogFactory.getLog(HtmlLink.class);
    public static final String TAG_NAME = "link";
    private WebResponse cachedWebResponse_;

    HtmlLink(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    public final String getCharsetAttribute() {
        return this.getAttribute("charset");
    }

    public final String getHrefAttribute() {
        return this.getAttribute("href");
    }

    public final String getHrefLangAttribute() {
        return this.getAttribute("hreflang");
    }

    public final String getTypeAttribute() {
        return this.getAttribute("type");
    }

    public final String getRelAttribute() {
        return this.getAttribute("rel");
    }

    public final String getRevAttribute() {
        return this.getAttribute("rev");
    }

    public final String getMediaAttribute() {
        return this.getAttribute("media");
    }

    public final String getTargetAttribute() {
        return this.getAttribute("target");
    }

    public WebResponse getWebResponse(boolean downloadIfNeeded) throws IOException {
        return this.getWebResponse(downloadIfNeeded, null);
    }

    public WebResponse getWebResponse(boolean downloadIfNeeded, WebRequest request) throws IOException {
        if (downloadIfNeeded && this.cachedWebResponse_ == null) {
            WebClient webclient = this.getPage().getWebClient();
            if (null == request) {
                request = this.getWebRequest();
            }
            try {
                boolean successful;
                this.cachedWebResponse_ = webclient.loadWebResponse(request);
                int statusCode = this.cachedWebResponse_.getStatusCode();
                boolean bl = successful = statusCode >= 200 && statusCode < 300;
                if (successful) {
                    this.executeEvent("load");
                } else {
                    this.executeEvent("error");
                }
            }
            catch (IOException e) {
                this.executeEvent("error");
                throw e;
            }
        }
        return this.cachedWebResponse_;
    }

    public WebRequest getWebRequest() throws MalformedURLException {
        HtmlPage page = (HtmlPage)this.getPage();
        URL url = page.getFullyQualifiedUrl(this.getHrefAttribute());
        WebRequest request = new WebRequest(url);
        request.setAdditionalHeader("Referer", page.getUrl().toExternalForm());
        String accept = page.getWebClient().getBrowserVersion().getCssAcceptHeader();
        request.setAdditionalHeader("Accept", accept);
        return request;
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        if (this.hasFeature(BrowserVersionFeatures.CSS_DISPLAY_BLOCK2)) {
            return HtmlElement.DisplayStyle.NONE;
        }
        return HtmlElement.DisplayStyle.INLINE;
    }

    @Override
    public boolean mayBeDisplayed() {
        return false;
    }

    private void executeEvent(String type) {
        Object scriptable = this.getScriptableObject();
        HTMLLinkElement link = (HTMLLinkElement)scriptable;
        Event event = new Event(this, type);
        link.executeEventLocally(event);
    }

    @Override
    protected void onAllChildrenAddedToPage(boolean postponed) {
        if (this.getOwnerDocument() instanceof XmlPage) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Link node added: " + this.asXml()));
        }
        if (!this.getPage().getWebClient().getOptions().isCssEnabled() || !StyleSheetList.isStyleSheetLink(this)) {
            return;
        }
        PostponedAction action = new PostponedAction(this.getPage(), "Loading of link " + this){

            @Override
            public void execute() {
                HTMLLinkElement linkElem = (HTMLLinkElement)HtmlLink.this.getScriptableObject();
                CSSStyleSheet.loadStylesheet(linkElem, HtmlLink.this, null);
            }
        };
        AbstractJavaScriptEngine<?> engine = this.getPage().getWebClient().getJavaScriptEngine();
        if (postponed) {
            engine.addPostponedAction(action);
        } else {
            try {
                action.execute();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

