/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.AbstractJavaScriptConfiguration;
import com.gargoylesoftware.htmlunit.javascript.configuration.ClassConfiguration;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxStaticFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxStaticGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.EDGE})
public class Symbol
extends SimpleScriptable {
    static final String ITERATOR_STRING = "Symbol(Symbol.iterator)";
    private static Map<String, Map<String, Symbol>> SYMBOL_MAP_ = new HashMap<String, Map<String, Symbol>>();
    private Object name_;

    public Symbol() {
    }

    @JsxConstructor
    public Symbol(Object name) {
        this.name_ = name;
        for (StackTraceElement stackElement : new Throwable().getStackTrace()) {
            if (!stackElement.getClassName().contains("BaseFunction") || !"construct".equals(stackElement.getMethodName())) continue;
            throw ScriptRuntime.typeError((String)"Symbol is not a constructor");
        }
    }

    @JsxStaticGetter
    public static Symbol getIterator(Scriptable thisObj) {
        return Symbol.getSymbol(thisObj, "iterator");
    }

    private static Symbol getSymbol(Scriptable thisObj, String name) {
        Symbol symbol;
        SimpleScriptable scope = (SimpleScriptable)thisObj.getParentScope();
        BrowserVersion browserVersion = scope.getBrowserVersion();
        Map<String, Symbol> map = SYMBOL_MAP_.get(browserVersion.getNickname());
        if (map == null) {
            map = new HashMap<String, Symbol>();
            SYMBOL_MAP_.put(browserVersion.getNickname(), map);
        }
        if ((symbol = map.get(name)) == null) {
            symbol = new Symbol();
            symbol.name_ = name;
            symbol.setParentScope((Scriptable)scope);
            symbol.setPrototype(scope.getPrototype(symbol.getClass()));
            map.put(name, symbol);
        }
        return symbol;
    }

    @JsxStaticGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF52})
    public static Symbol getUnscopables(Scriptable thisObj) {
        return Symbol.getSymbol(thisObj, "unscopables");
    }

    @JsxStaticGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF52})
    public static Symbol getIsConcatSpreadable(Scriptable thisObj) {
        return Symbol.getSymbol(thisObj, "isConcatSpreadable");
    }

    @JsxStaticGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF})
    public static Symbol getToPrimitive(Scriptable thisObj) {
        return Symbol.getSymbol(thisObj, "toPrimitive");
    }

    @JsxStaticGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF52})
    public static Symbol getToStringTag(Scriptable thisObj) {
        return Symbol.getSymbol(thisObj, "toStringTag");
    }

    @JsxStaticGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF})
    public static Symbol getMatch(Scriptable thisObj) {
        return Symbol.getSymbol(thisObj, "match");
    }

    @JsxStaticGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF52})
    public static Symbol getHasInstance(Scriptable thisObj) {
        return Symbol.getSymbol(thisObj, "hasInstance");
    }

    @JsxStaticGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF52})
    public static Symbol getReplace(Scriptable thisObj) {
        return Symbol.getSymbol(thisObj, "replace");
    }

    @JsxStaticGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF52})
    public static Symbol getSearch(Scriptable thisObj) {
        return Symbol.getSymbol(thisObj, "search");
    }

    @JsxStaticGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF52})
    public static Symbol getSplit(Scriptable thisObj) {
        return Symbol.getSymbol(thisObj, "split");
    }

    @JsxStaticGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF})
    public static Symbol getSpecies(Scriptable thisObj) {
        return Symbol.getSymbol(thisObj, "species");
    }

    @JsxStaticFunction(functionName="for")
    public static Symbol forFunction(Context context, Scriptable thisObj, Object[] args, Function function) {
        String key = Context.toString((Object)(args.length != 0 ? args[0] : Undefined.instance));
        Symbol symbol = (Symbol)((ScriptableObject)thisObj).get((Object)key);
        if (symbol == null) {
            SimpleScriptable parentScope = (SimpleScriptable)thisObj.getParentScope();
            symbol = new Symbol();
            symbol.name_ = key;
            symbol.setParentScope((Scriptable)parentScope);
            symbol.setPrototype(parentScope.getPrototype(symbol.getClass()));
            thisObj.put(key, thisObj, (Object)symbol);
        }
        return symbol;
    }

    public String getTypeOf() {
        return "symbol";
    }

    @JsxFunction
    public String toString() {
        String name;
        if (this.name_ == Undefined.instance) {
            name = "";
        } else {
            name = Context.toString((Object)this.name_);
            ClassConfiguration config = AbstractJavaScriptConfiguration.getClassConfiguration(this.getClass(), this.getBrowserVersion());
            for (Map.Entry<String, ClassConfiguration.PropertyInfo> propertyEntry : config.getStaticPropertyEntries()) {
                if (!propertyEntry.getKey().equals(name)) continue;
                name = "Symbol." + name;
                break;
            }
        }
        return "Symbol(" + name + ')';
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if (String.class.equals(hint) || hint == null) {
            return this.toString();
        }
        return super.getDefaultValue(hint);
    }

    public static void remove(Window window) {
        for (Map<String, Symbol> symbols : SYMBOL_MAP_.values()) {
            Iterator<Symbol> it = symbols.values().iterator();
            while (it.hasNext()) {
                if (it.next().getParentScope() != window) continue;
                it.remove();
            }
        }
    }
}

