/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlLink;
import com.gargoylesoftware.htmlunit.html.HtmlStyle;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleSheet;
import com.gargoylesoftware.htmlunit.javascript.host.dom.AbstractList;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Document;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLLinkElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLStyleElement;
import com.steadystate.css.dom.MediaListImpl;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.lang3.StringUtils;
import org.w3c.css.sac.SACMediaList;
import org.w3c.dom.stylesheets.MediaList;

@JsxClass
public class StyleSheetList
extends SimpleScriptable {
    private HTMLCollection nodes_;

    public static boolean isStyleSheetLink(DomNode domNode) {
        if (domNode instanceof HtmlLink) {
            HtmlLink link = (HtmlLink)domNode;
            String rel = link.getRelAttribute();
            if (rel != null) {
                rel = rel.trim();
            }
            return "stylesheet".equalsIgnoreCase(rel);
        }
        return false;
    }

    public boolean isActiveStyleSheetLink(DomNode domNode) {
        if (domNode instanceof HtmlLink) {
            HtmlLink link = (HtmlLink)domNode;
            String rel = link.getRelAttribute();
            if (rel != null) {
                rel = rel.trim();
            }
            if ("stylesheet".equalsIgnoreCase(rel)) {
                String media = link.getMediaAttribute();
                if (StringUtils.isBlank((CharSequence)media)) {
                    return true;
                }
                WebClient webClient = this.getWindow().getWebWindow().getWebClient();
                SACMediaList mediaList = CSSStyleSheet.parseMedia(webClient.getCssErrorHandler(), media);
                return CSSStyleSheet.isActive((SimpleScriptable)this, (MediaList)new MediaListImpl(mediaList));
            }
        }
        return false;
    }

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.EDGE})
    public StyleSheetList() {
    }

    public StyleSheetList(Document document) {
        this.setParentScope((Scriptable)document);
        this.setPrototype(this.getPrototype(this.getClass()));
        WebClient webClient = this.getWindow().getWebWindow().getWebClient();
        if (webClient.getOptions().isCssEnabled()) {
            final boolean onlyActive = webClient.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_STYLESHEETLIST_ACTIVE_ONLY);
            this.nodes_ = new HTMLCollection(document.getDomNodeOrDie(), true){

                @Override
                protected boolean isMatching(DomNode node) {
                    if (node instanceof HtmlStyle) {
                        return true;
                    }
                    if (onlyActive) {
                        return StyleSheetList.this.isActiveStyleSheetLink(node);
                    }
                    return StyleSheetList.isStyleSheetLink(node);
                }

                @Override
                protected AbstractList.EffectOnCache getEffectOnCache(HtmlAttributeChangeEvent event) {
                    HtmlElement node = event.getHtmlElement();
                    if (node instanceof HtmlLink && "rel".equalsIgnoreCase(event.getName())) {
                        return AbstractList.EffectOnCache.RESET;
                    }
                    return AbstractList.EffectOnCache.NONE;
                }
            };
        } else {
            this.nodes_ = HTMLCollection.emptyCollection(this.getWindow().getDomNodeOrDie());
        }
    }

    @JsxGetter
    public int getLength() {
        return this.nodes_.getLength();
    }

    @JsxFunction
    public Object item(int index) {
        if (this.nodes_ == null || index < 0 || index >= this.nodes_.getLength()) {
            return Undefined.instance;
        }
        HTMLElement element = (HTMLElement)this.nodes_.item(index);
        CSSStyleSheet sheet = element instanceof HTMLStyleElement ? ((HTMLStyleElement)element).getSheet() : ((HTMLLinkElement)element).getSheet();
        return sheet;
    }

    public Object get(int index, Scriptable start) {
        if (this == start) {
            return this.item(index);
        }
        return super.get(index, start);
    }

    @Override
    protected Object equivalentValues(Object value) {
        return value != null && this.getClass() == value.getClass() && this.getDomNodeOrNull() == ((StyleSheetList)value).getDomNodeOrNull();
    }
}

