/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.file;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstant;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.host.arrays.ArrayBuffer;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventTarget;
import com.gargoylesoftware.htmlunit.javascript.host.file.File;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;

@JsxClass
public class FileReader
extends EventTarget {
    @JsxConstant
    public static final short EMPTY = 0;
    @JsxConstant
    public static final short LOADING = 1;
    @JsxConstant
    public static final short DONE = 2;
    private int readyState_ = 0;
    private Object result_;

    @JsxConstructor
    public FileReader() {
    }

    @JsxGetter
    public int getReadyState() {
        return this.readyState_;
    }

    @JsxGetter
    public Object getResult() {
        return this.result_;
    }

    @JsxFunction
    public void readAsDataURL(Object object) throws IOException {
        this.readyState_ = 1;
        java.io.File file = ((File)object).getFile();
        String contentType = Files.probeContentType(file.toPath());
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            FileUtils.copyFile((java.io.File)file, (OutputStream)bos);
            byte[] bytes = bos.toByteArray();
            String value = new String(new Base64().encode(bytes));
            BrowserVersion browserVersion = this.getBrowserVersion();
            this.result_ = "data:";
            boolean includeConentType = browserVersion.hasFeature(BrowserVersionFeatures.JS_FILEREADER_CONTENT_TYPE);
            if (!value.isEmpty() || includeConentType) {
                if (contentType == null) {
                    contentType = includeConentType ? "application/octet-stream" : "";
                }
                this.result_ = this.result_ + contentType + ";base64," + value;
            }
            if (value.isEmpty() && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_FILEREADER_EMPTY_NULL)) {
                this.result_ = "null";
            }
        }
        this.readyState_ = 2;
        Event event = new Event(this, "load");
        this.fireEvent(event);
    }

    @JsxFunction
    public void readAsArrayBuffer(Object object) throws IOException {
        this.readyState_ = 1;
        java.io.File file = ((File)object).getFile();
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            FileUtils.copyFile((java.io.File)file, (OutputStream)bos);
            byte[] bytes = bos.toByteArray();
            ArrayBuffer buffer = new ArrayBuffer(bytes);
            buffer.setParentScope(this.getParentScope());
            buffer.setPrototype(this.getPrototype(buffer.getClass()));
            this.result_ = buffer;
        }
        this.readyState_ = 2;
        Event event = new Event(this, "load");
        this.fireEvent(event);
    }

    @JsxGetter
    public Function getOnload() {
        return this.getEventHandler("load");
    }

    @JsxSetter
    public void setOnload(Object onload) {
        this.setEventHandler("load", onload);
    }

    @JsxGetter
    public Function getOnerror() {
        return this.getEventHandler("error");
    }

    @JsxSetter
    public void setOnerror(Object onerror) {
        this.setEventHandler("error", onerror);
    }
}

