/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.core.common.spring.project;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.activiti.core.common.project.model.ProjectManifest;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;

public class ProjectModelService {
    private String projectManifestFilePath;
    private final ObjectMapper objectMapper;
    private ResourcePatternResolver resourceLoader;

    public ProjectModelService(String path, ObjectMapper objectMapper, ResourcePatternResolver resourceLoader) {
        this.projectManifestFilePath = path;
        this.objectMapper = objectMapper;
        this.resourceLoader = resourceLoader;
    }

    private Optional<Resource> retrieveResource() {
        Resource resource = this.resourceLoader.getResource(this.projectManifestFilePath);
        if (resource.exists()) {
            return Optional.of(resource);
        }
        return Optional.empty();
    }

    private ProjectManifest read(InputStream inputStream) throws IOException {
        return (ProjectManifest)this.objectMapper.readValue(inputStream, ProjectManifest.class);
    }

    public ProjectManifest loadProjectManifest() throws IOException {
        Optional<Resource> resourceOptional = this.retrieveResource();
        return this.read(resourceOptional.orElseThrow(() -> new FileNotFoundException("'" + this.projectManifestFilePath + "' manifest not found.")).getInputStream());
    }

    public boolean hasProjectManifest() {
        return this.retrieveResource().isPresent();
    }
}

