/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.redis;

import java.util.Map;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.connectors.redis.RedisSink;
import org.apache.flink.streaming.connectors.redis.common.config.FlinkJedisConfigBase;
import org.apache.flink.streaming.connectors.redis.common.hanlder.FlinkJedisConfigHandler;
import org.apache.flink.streaming.connectors.redis.common.hanlder.RedisHandlerServices;
import org.apache.flink.streaming.connectors.redis.common.hanlder.RedisMapperHandler;
import org.apache.flink.streaming.connectors.redis.common.mapper.RedisMapper;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sinks.UpsertStreamTableSink;
import org.apache.flink.table.utils.TableConnectorUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class RedisTableSink
implements UpsertStreamTableSink<Row> {
    private FlinkJedisConfigBase flinkJedisConfigBase;
    private RedisMapper redisMapper;
    private TableSchema tableSchema;
    private String[] keyFields;
    private boolean isAppendOnly;
    private Map<String, String> properties = null;

    public RedisTableSink(Map<String, String> properties) {
        this.properties = properties;
        Preconditions.checkNotNull(properties, (String)"properties should not be null");
        this.redisMapper = RedisHandlerServices.findRedisHandler(RedisMapperHandler.class, properties).createRedisMapper(properties);
        this.flinkJedisConfigBase = RedisHandlerServices.findRedisHandler(FlinkJedisConfigHandler.class, properties).createFlinkJedisConfig(properties);
        DescriptorProperties descriptorProperties = new DescriptorProperties(true);
        descriptorProperties.putProperties(properties);
        this.tableSchema = descriptorProperties.getTableSchema("schema");
    }

    public DataStreamSink<?> consumeDataStream(DataStream<Tuple2<Boolean, Row>> dataStream) {
        return dataStream.addSink(new RedisSink(this.flinkJedisConfigBase, this.redisMapper)).setParallelism(dataStream.getParallelism()).name(TableConnectorUtils.generateRuntimeName(this.getClass(), (String[])this.getFieldNames()));
    }

    public TableSink configure(String[] fieldNames, TypeInformation[] fieldTypes) {
        return new RedisTableSink(this.getProperties());
    }

    public TableSchema getTableSchema() {
        return this.tableSchema;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void setKeyFields(String[] keys) {
        this.keyFields = keys;
    }

    public void setIsAppendOnly(Boolean isAppendOnly) {
        this.isAppendOnly = isAppendOnly;
    }

    public TypeInformation<Row> getRecordType() {
        return this.tableSchema.toRowType();
    }
}

