/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.redis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.connectors.redis.RedisTableSink;
import org.apache.flink.table.factories.StreamTableSinkFactory;
import org.apache.flink.table.sinks.StreamTableSink;
import org.apache.flink.types.Row;

public class RedisTableSinkFactory
implements StreamTableSinkFactory<Tuple2<Boolean, Row>> {
    public StreamTableSink<Tuple2<Boolean, Row>> createStreamTableSink(Map<String, String> properties) {
        return new RedisTableSink(properties);
    }

    public Map<String, String> requiredContext() {
        HashMap<String, String> require = new HashMap<String, String>();
        require.put("connector.type", "redis");
        return require;
    }

    public List<String> supportedProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("redis-mode");
        properties.add("command");
        properties.add("cluster-nodes");
        properties.add("master.name");
        properties.add("cluster.password");
        properties.add("sentinel");
        properties.add("key.ttl");
        properties.add("schema.#.data-type");
        properties.add("schema.#.name");
        properties.add("schema.#.from");
        properties.add("format.*");
        properties.add("connector.*");
        return properties;
    }
}

