/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.redis.common.config;

import java.io.Serializable;
import org.apache.flink.streaming.connectors.redis.common.Util;

public abstract class FlinkJedisConfigBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final int maxTotal;
    protected final int maxIdle;
    protected final int minIdle;
    protected final int connectionTimeout;
    protected final String password;
    protected final boolean testOnBorrow;
    protected final boolean testOnReturn;
    protected final boolean testWhileIdle;

    protected FlinkJedisConfigBase(int connectionTimeout, int maxTotal, int maxIdle, int minIdle, String password, boolean testOnBorrow, boolean testOnReturn, boolean testWhileIdle) {
        Util.checkArgument(connectionTimeout >= 0, "connection timeout can not be negative");
        Util.checkArgument(maxTotal >= 0, "maxTotal value can not be negative");
        Util.checkArgument(maxIdle >= 0, "maxIdle value can not be negative");
        Util.checkArgument(minIdle >= 0, "minIdle value can not be negative");
        this.connectionTimeout = connectionTimeout;
        this.maxTotal = maxTotal;
        this.maxIdle = maxIdle;
        this.minIdle = minIdle;
        this.testOnBorrow = testOnBorrow;
        this.testOnReturn = testOnReturn;
        this.testWhileIdle = testWhileIdle;
        this.password = password;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getTestOnBorrow() {
        return this.testOnBorrow;
    }

    public boolean getTestOnReturn() {
        return this.testOnReturn;
    }

    public boolean getTestWhileIdle() {
        return this.testWhileIdle;
    }
}

