/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.redis.common.config;

import java.util.Objects;
import org.apache.flink.streaming.connectors.redis.common.config.FlinkJedisConfigBase;

public class FlinkJedisPoolConfig
extends FlinkJedisConfigBase {
    private static final long serialVersionUID = 1L;
    private final String host;
    private final int port;
    private final int database;

    private FlinkJedisPoolConfig(String host, int port, int connectionTimeout, String password, int database, int maxTotal, int maxIdle, int minIdle, boolean testOnBorrow, boolean testOnReturn, boolean testWhileIdle) {
        super(connectionTimeout, maxTotal, maxIdle, minIdle, password, testOnBorrow, testOnReturn, testWhileIdle);
        Objects.requireNonNull(host, "Host information should be presented");
        this.host = host;
        this.port = port;
        this.database = database;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getDatabase() {
        return this.database;
    }

    public String toString() {
        return "FlinkJedisPoolConfig{host=" + this.host + ", port=" + this.port + ", database=" + this.database + ", maxTotal=" + this.maxTotal + ", maxIdle=" + this.maxIdle + ", minIdle=" + this.minIdle + ", connectionTimeout=, password=" + this.password + ", testOnBorrow=" + this.testOnBorrow + ", testOnReturn=" + this.testOnReturn + ", testWhileIdle=" + this.testWhileIdle + '}';
    }

    public static class Builder {
        private String host;
        private int port = 6379;
        private int timeout = 2000;
        private int database = 0;
        private String password;
        private int maxTotal = 8;
        private int maxIdle = 8;
        private int minIdle = 0;
        private boolean testOnBorrow = false;
        private boolean testOnReturn = false;
        private boolean testWhileIdle = false;

        public Builder setMaxTotal(int maxTotal) {
            this.maxTotal = maxTotal;
            return this;
        }

        public Builder setMaxIdle(int maxIdle) {
            this.maxIdle = maxIdle;
            return this;
        }

        public Builder setMinIdle(int minIdle) {
            this.minIdle = minIdle;
            return this;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder setDatabase(int database) {
            this.database = database;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder setTestOnBorrow(boolean testOnBorrow) {
            this.testOnBorrow = testOnBorrow;
            return this;
        }

        public Builder setTestOnReturn(boolean testOnReturn) {
            this.testOnReturn = testOnReturn;
            return this;
        }

        public Builder setTestWhileIdle(boolean testWhileIdle) {
            this.testWhileIdle = testWhileIdle;
            return this;
        }

        public FlinkJedisPoolConfig build() {
            return new FlinkJedisPoolConfig(this.host, this.port, this.timeout, this.password, this.database, this.maxTotal, this.maxIdle, this.minIdle, this.testOnBorrow, this.testOnReturn, this.testWhileIdle);
        }
    }
}

