/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.redis.common.config;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.streaming.connectors.redis.common.Util;
import org.apache.flink.streaming.connectors.redis.common.config.FlinkJedisConfigBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkJedisSentinelConfig
extends FlinkJedisConfigBase {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(FlinkJedisSentinelConfig.class);
    private final String masterName;
    private final Set<String> sentinels;
    private final int soTimeout;
    private final int database;

    private FlinkJedisSentinelConfig(String masterName, Set<String> sentinels, int connectionTimeout, int soTimeout, String password, int database, int maxTotal, int maxIdle, int minIdle, boolean testOnBorrow, boolean testOnReturn, boolean testWhileIdle) {
        super(connectionTimeout, maxTotal, maxIdle, minIdle, password, testOnBorrow, testOnReturn, testWhileIdle);
        Objects.requireNonNull(masterName, "Master name should be presented");
        Objects.requireNonNull(sentinels, "Sentinels information should be presented");
        Util.checkArgument(!sentinels.isEmpty(), "Sentinel hosts should not be empty");
        this.masterName = masterName;
        this.sentinels = new HashSet<String>(sentinels);
        this.soTimeout = soTimeout;
        this.database = database;
    }

    public String getMasterName() {
        return this.masterName;
    }

    public Set<String> getSentinels() {
        return this.sentinels;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public int getDatabase() {
        return this.database;
    }

    public String toString() {
        return "FlinkJedisSentinelConfig{masterName=" + this.masterName + ", sentinels=" + this.sentinels + ", soTimeout=" + this.soTimeout + ", database=" + this.database + ", maxTotal=" + this.maxTotal + ", maxIdle=" + this.maxIdle + ", minIdle=" + this.minIdle + ", connectionTimeout=" + this.connectionTimeout + ", password=" + this.password + ", testOnBorrow=" + this.testOnBorrow + ", testOnReturn=" + this.testOnReturn + ", testWhileIdle=" + this.testWhileIdle + '}';
    }

    public static class Builder {
        private String masterName;
        private Set<String> sentinels;
        private int connectionTimeout = 2000;
        private int soTimeout = 2000;
        private String password;
        private int database = 0;
        private int maxTotal = 8;
        private int maxIdle = 8;
        private int minIdle = 0;
        private boolean testOnBorrow = false;
        private boolean testOnReturn = false;
        private boolean testWhileIdle = false;

        public Builder setMasterName(String masterName) {
            this.masterName = masterName;
            return this;
        }

        public Builder setSentinels(Set<String> sentinels) {
            this.sentinels = sentinels;
            return this;
        }

        public Builder setConnectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder setSoTimeout(int soTimeout) {
            this.soTimeout = soTimeout;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder setDatabase(int database) {
            this.database = database;
            return this;
        }

        public Builder setMaxTotal(int maxTotal) {
            this.maxTotal = maxTotal;
            return this;
        }

        public Builder setMaxIdle(int maxIdle) {
            this.maxIdle = maxIdle;
            return this;
        }

        public Builder setMinIdle(int minIdle) {
            this.minIdle = minIdle;
            return this;
        }

        public Builder setTestOnBorrow(boolean testOnBorrow) {
            this.testOnBorrow = testOnBorrow;
            return this;
        }

        public Builder setTestOnReturn(boolean testOnReturn) {
            this.testOnReturn = testOnReturn;
            return this;
        }

        public Builder setTestWhileIdle(boolean testWhileIdle) {
            this.testWhileIdle = testWhileIdle;
            return this;
        }

        public FlinkJedisSentinelConfig build() {
            return new FlinkJedisSentinelConfig(this.masterName, this.sentinels, this.connectionTimeout, this.soTimeout, this.password, this.database, this.maxTotal, this.maxIdle, this.minIdle, this.testOnBorrow, this.testOnReturn, this.testWhileIdle);
        }
    }
}

