/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.redis.common.config.handler;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.streaming.connectors.redis.common.config.FlinkJedisClusterConfig;
import org.apache.flink.streaming.connectors.redis.common.config.FlinkJedisConfigBase;
import org.apache.flink.streaming.connectors.redis.common.hanlder.FlinkJedisConfigHandler;
import org.apache.flink.util.Preconditions;

public class FlinkJedisClusterConfigHandler
implements FlinkJedisConfigHandler {
    @Override
    public FlinkJedisConfigBase createFlinkJedisConfig(Map<String, String> properties) {
        Preconditions.checkArgument((boolean)properties.containsKey("cluster-nodes"), (Object)"nodes should not be null in cluster mode");
        String nodesInfo = properties.get("cluster-nodes");
        Set<InetSocketAddress> nodes = Arrays.stream(nodesInfo.split(",")).map(r -> {
            String[] arr = r.split(":");
            return new InetSocketAddress(arr[0].trim(), Integer.parseInt(arr[1].trim()));
        }).collect(Collectors.toSet());
        String clusterPassword = properties.getOrDefault("cluster.password", null);
        FlinkJedisClusterConfig.Builder builder = new FlinkJedisClusterConfig.Builder();
        builder.setNodes(nodes);
        if (StringUtils.isNotBlank((CharSequence)clusterPassword)) {
            builder.setPassword(clusterPassword);
        }
        return builder.build();
    }

    @Override
    public Map<String, String> requiredContext() {
        HashMap<String, String> require = new HashMap<String, String>();
        require.put("redis-mode", "cluster");
        return require;
    }
}

