/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.redis.common.config.handler;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.streaming.connectors.redis.common.config.FlinkJedisConfigBase;
import org.apache.flink.streaming.connectors.redis.common.config.FlinkJedisSentinelConfig;
import org.apache.flink.streaming.connectors.redis.common.hanlder.FlinkJedisConfigHandler;

public class FlinkJedisSentinelConfigHandler
implements FlinkJedisConfigHandler {
    @Override
    public FlinkJedisConfigBase createFlinkJedisConfig(Map<String, String> properties) {
        String masterName = properties.computeIfAbsent("master.name", null);
        String sentinelsInfo = properties.computeIfAbsent("sentinels.info", null);
        Objects.requireNonNull(masterName, "master should not be null in sentinel mode");
        Objects.requireNonNull(sentinelsInfo, "sentinels should not be null in sentinel mode");
        HashSet<String> sentinels = new HashSet<String>(Arrays.asList(sentinelsInfo.split(",")));
        String sentinelsPassword = properties.computeIfAbsent("sentinels.password", null);
        if (sentinelsPassword != null && sentinelsPassword.trim().isEmpty()) {
            sentinelsPassword = null;
        }
        FlinkJedisSentinelConfig flinkJedisSentinelConfig = new FlinkJedisSentinelConfig.Builder().setMasterName(masterName).setSentinels(sentinels).setPassword(sentinelsPassword).build();
        return flinkJedisSentinelConfig;
    }

    @Override
    public Map<String, String> requiredContext() {
        HashMap<String, String> require = new HashMap<String, String>();
        require.put("redis-mode", "sentinel");
        return require;
    }
}

