/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.redis.common.container;

import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import org.apache.flink.streaming.connectors.redis.common.container.RedisCommandsContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisCluster;

public class RedisClusterContainer
implements RedisCommandsContainer,
Closeable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(RedisClusterContainer.class);
    private transient JedisCluster jedisCluster;

    public RedisClusterContainer(JedisCluster jedisCluster) {
        Objects.requireNonNull(jedisCluster, "Jedis cluster can not be null");
        this.jedisCluster = jedisCluster;
    }

    @Override
    public void open() throws Exception {
        this.jedisCluster.echo("Test");
    }

    @Override
    public void hset(String key, String hashField, String value, Integer ttl) {
        try {
            this.jedisCluster.hset(key, hashField, value);
            if (ttl != null) {
                this.jedisCluster.expire(key, ttl.intValue());
            }
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot send Redis message with command HSET to hash {} of key {} error message {}", new Object[]{hashField, key, e.getMessage()});
            }
            throw e;
        }
    }

    @Override
    public void hincrBy(String key, String hashField, Long value, Integer ttl) {
        try {
            this.jedisCluster.hincrBy(key, hashField, value.longValue());
            if (ttl != null) {
                this.jedisCluster.expire(key, ttl.intValue());
            }
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot send Redis message with command HINCRBY to hash {} of key {} error message {}", new Object[]{hashField, key, e.getMessage()});
            }
            throw e;
        }
    }

    @Override
    public void rpush(String listName, String value) {
        try {
            this.jedisCluster.rpush(listName, new String[]{value});
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot send Redis message with command RPUSH to list {} error message: {}", (Object)listName, (Object)e.getMessage());
            }
            throw e;
        }
    }

    @Override
    public void lpush(String listName, String value) {
        try {
            this.jedisCluster.lpush(listName, new String[]{value});
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot send Redis message with command LPUSH to list {} error message: {}", (Object)listName, (Object)e.getMessage());
            }
            throw e;
        }
    }

    @Override
    public void sadd(String setName, String value) {
        try {
            this.jedisCluster.sadd(setName, new String[]{value});
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot send Redis message with command RPUSH to set {} error message {}", (Object)setName, (Object)e.getMessage());
            }
            throw e;
        }
    }

    @Override
    public void publish(String channelName, String message) {
        try {
            this.jedisCluster.publish(channelName, message);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot send Redis message with command PUBLISH to channel {} error message {}", (Object)channelName, (Object)e.getMessage());
            }
            throw e;
        }
    }

    @Override
    public void set(String key, String value) {
        try {
            this.jedisCluster.set(key, value);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot send Redis message with command SET to key {} error message {}", (Object)key, (Object)e.getMessage());
            }
            throw e;
        }
    }

    @Override
    public void setex(String key, String value, Integer ttl) {
        try {
            this.jedisCluster.setex(key, ttl.intValue(), value);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot send Redis message with command SETEX to key {} error message {}", (Object)key, (Object)e.getMessage());
            }
            throw e;
        }
    }

    @Override
    public void pfadd(String key, String element) {
        try {
            this.jedisCluster.pfadd(key, new String[]{element});
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot send Redis message with command PFADD to key {} error message {}", (Object)key, (Object)e.getMessage());
            }
            throw e;
        }
    }

    @Override
    public void zadd(String key, String score, String element) {
        try {
            this.jedisCluster.zadd(key, Double.valueOf(score).doubleValue(), element);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot send Redis message with command ZADD to set {} error message {}", (Object)key, (Object)e.getMessage());
            }
            throw e;
        }
    }

    @Override
    public void zincrBy(String key, String score, String element) {
        try {
            this.jedisCluster.zincrby(key, Double.valueOf(score).doubleValue(), element);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot send Redis message with command ZINCRBY to set {} error message {}", (Object)key, (Object)e.getMessage());
            }
            throw e;
        }
    }

    @Override
    public void zrem(String key, String element) {
        block2: {
            try {
                this.jedisCluster.zrem(key, new String[]{element});
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.error("Cannot send Redis message with command ZREM to set {} error message {}", (Object)key, (Object)e.getMessage());
            }
        }
    }

    @Override
    public void incrByEx(String key, Long value, Integer ttl) {
        try {
            this.jedisCluster.incrBy(key, value.longValue());
            if (ttl != null) {
                this.jedisCluster.expire(key, ttl.intValue());
            }
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot send Redis message with command incrby and ttl to key {} with increment {} and tll {} error message {}", new Object[]{key, value, ttl, e.getMessage()});
            }
            throw e;
        }
    }

    @Override
    public void decrByEx(String key, Long value, Integer ttl) {
        try {
            this.jedisCluster.decrBy(key, value.longValue());
            if (ttl != null) {
                this.jedisCluster.expire(key, ttl.intValue());
            }
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot send Redis message with command descry and ttl to key {} with increment {} and tll {} error message {}", new Object[]{key, value, ttl, e.getMessage()});
            }
            throw e;
        }
    }

    @Override
    public void incrBy(String key, Long value) {
        try {
            this.jedisCluster.incrBy(key, value.longValue());
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot send Redis message with command incrby to key {} with increment {} error message {}", new Object[]{key, value, e.getMessage()});
            }
            throw e;
        }
    }

    @Override
    public void decrBy(String key, Long value) {
        try {
            this.jedisCluster.decrBy(key, value.longValue());
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot send Redis message with command descry to key {} with decrement {} error message {}", new Object[]{key, value, e.getMessage()});
            }
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        this.jedisCluster.close();
    }
}

