/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.redis.common.hanlder;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.apache.flink.streaming.connectors.redis.common.hanlder.RedisHandler;
import org.apache.flink.table.api.TableException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisHandlerServices<T> {
    private static final ServiceLoader<RedisHandler> defaultLoader = ServiceLoader.load(RedisHandler.class);
    private static final Logger LOG = LoggerFactory.getLogger(RedisHandlerServices.class);

    public static <T extends RedisHandler> T findRedisHandler(Class<T> RedisHanlderClass, Map<String, String> meta) {
        Preconditions.checkNotNull(meta);
        return RedisHandlerServices.findSingRedisHandler(RedisHanlderClass, meta, Optional.empty());
    }

    private static <T extends RedisHandler> T findSingRedisHandler(Class<T> RedisHanlderClass, Map<String, String> meta, Optional<ClassLoader> classLoader) {
        List<RedisHandler> redisHandlers = RedisHandlerServices.discoverRedisHanlder(classLoader);
        List<T> filtered = RedisHandlerServices.filter(redisHandlers, RedisHanlderClass, meta);
        return (T)((RedisHandler)filtered.get(0));
    }

    private static <T extends RedisHandler> List<T> filter(List<RedisHandler> redis, Class<T> redisClass, Map<String, String> meta) {
        Preconditions.checkNotNull(redisClass);
        Preconditions.checkNotNull(meta);
        List<T> redisFactories = RedisHandlerServices.filterByFactoryClass(redisClass, redis);
        List<T> contextFactories = RedisHandlerServices.filterByContext(meta, redisFactories);
        return contextFactories;
    }

    private static List<RedisHandler> discoverRedisHanlder(Optional<ClassLoader> classLoader) {
        try {
            LinkedList<RedisHandler> result = new LinkedList<RedisHandler>();
            if (classLoader.isPresent()) {
                ServiceLoader.load(RedisHandler.class, classLoader.get()).iterator().forEachRemaining(result::add);
            } else {
                defaultLoader.iterator().forEachRemaining(result::add);
            }
            return result;
        }
        catch (ServiceConfigurationError e) {
            LOG.error("Could not load service provider for redis handler.", (Throwable)e);
            throw new TableException("Could not load service provider for redis handler.", (Throwable)e);
        }
    }

    private static <T> List<T> filterByFactoryClass(Class<T> redisClass, List<RedisHandler> redis) {
        List redisList = redis.stream().filter(p -> redisClass.isAssignableFrom(p.getClass())).collect(Collectors.toList());
        if (redisList.isEmpty()) {
            throw new RuntimeException(String.format("No redis hanlder implements '%s'.", redisClass.getCanonicalName()));
        }
        return redisList;
    }

    private static <T extends RedisHandler> List<T> filterByContext(Map<String, String> meta, List<T> redisList) {
        List matchingredis = redisList.stream().filter(factory -> {
            Map<String, String> requestedContext = RedisHandlerServices.normalizeContext(factory);
            HashMap<String, String> plainContext = new HashMap<String, String>(requestedContext);
            return plainContext.keySet().stream().allMatch(e -> meta.containsKey(e) && ((String)meta.get(e)).equals(plainContext.get(e)));
        }).collect(Collectors.toList());
        if (matchingredis.isEmpty()) {
            throw new RuntimeException("no match redis");
        }
        return matchingredis;
    }

    private static Map<String, String> normalizeContext(RedisHandler redis) {
        Map<String, String> requiredContext = redis.requiredContext();
        if (requiredContext == null) {
            throw new RuntimeException(String.format("Required context of redis '%s' must not be null.", redis.getClass().getName()));
        }
        return requiredContext.keySet().stream().collect(Collectors.toMap(String::toLowerCase, requiredContext::get));
    }
}

