/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.redis.common.hanlder;

import java.lang.reflect.Constructor;
import java.util.Map;
import org.apache.flink.streaming.connectors.redis.common.hanlder.RedisHandler;
import org.apache.flink.streaming.connectors.redis.common.mapper.RedisMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RedisMapperHandler
extends RedisHandler {
    public static final Logger LOGGER = LoggerFactory.getLogger(RedisMapperHandler.class);

    default public RedisMapper createRedisMapper(Map<String, String> properties) {
        String ttl = properties.get("key.ttl");
        try {
            Class<?> redisMapper = Class.forName(this.getClass().getCanonicalName());
            if (ttl == null) {
                return (RedisMapper)redisMapper.newInstance();
            }
            Constructor<?> c = redisMapper.getConstructor(Integer.class);
            return (RedisMapper)c.newInstance(Integer.parseInt(ttl));
        }
        catch (Exception e) {
            LOGGER.error("create redis mapper failed", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

